/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.lights;

import android.annotation.SystemApi;
import android.hardware.lights.Light;
import android.hardware.lights.LightState;
import android.util.SparseArray;
import com.android.internal.util.Preconditions;

@SystemApi
public class LightsRequest {
    final int[] mLightIds;
    final LightState[] mLightStates;

    private LightsRequest(SparseArray<LightState> changes) {
        int n = changes.size();
        this.mLightIds = new int[n];
        this.mLightStates = new LightState[n];
        for (int i = 0; i < n; ++i) {
            this.mLightIds[i] = changes.keyAt(i);
            this.mLightStates[i] = changes.valueAt(i);
        }
    }

    public static class Builder {
        private final SparseArray<LightState> mChanges = new SparseArray();

        public Builder setLight(Light light, LightState state) {
            Preconditions.checkNotNull(light);
            Preconditions.checkNotNull(state);
            this.mChanges.put(light.getId(), state);
            return this;
        }

        public Builder clearLight(Light light) {
            Preconditions.checkNotNull(light);
            this.mChanges.put(light.getId(), null);
            return this;
        }

        public LightsRequest build() {
            return new LightsRequest(this.mChanges);
        }
    }
}

