/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.face;

import android.app.ActivityManager;
import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.BiometricFaceConstants;
import android.hardware.biometrics.CryptoObject;
import android.hardware.biometrics.IBiometricServiceLockoutResetCallback;
import android.hardware.face.Face;
import android.hardware.face.IFaceService;
import android.hardware.face.IFaceServiceReceiver;
import android.os.Binder;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.Trace;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import com.android.internal.os.SomeArgs;
import java.util.List;

public class FaceManager
implements BiometricAuthenticator,
BiometricFaceConstants {
    private static final String TAG = "FaceManager";
    private static final boolean DEBUG = true;
    private static final int MSG_ENROLL_RESULT = 100;
    private static final int MSG_ACQUIRED = 101;
    private static final int MSG_AUTHENTICATION_SUCCEEDED = 102;
    private static final int MSG_AUTHENTICATION_FAILED = 103;
    private static final int MSG_ERROR = 104;
    private static final int MSG_REMOVED = 105;
    private static final int MSG_GET_FEATURE_COMPLETED = 106;
    private static final int MSG_SET_FEATURE_COMPLETED = 107;
    private IFaceService mService;
    private final Context mContext;
    private IBinder mToken = new Binder();
    private AuthenticationCallback mAuthenticationCallback;
    private EnrollmentCallback mEnrollmentCallback;
    private RemovalCallback mRemovalCallback;
    private SetFeatureCallback mSetFeatureCallback;
    private GetFeatureCallback mGetFeatureCallback;
    private CryptoObject mCryptoObject;
    private Face mRemovalFace;
    private Handler mHandler;
    private IFaceServiceReceiver mServiceReceiver = new IFaceServiceReceiver.Stub(){

        @Override
        public void onEnrollResult(long deviceId, int faceId, int remaining) {
            FaceManager.this.mHandler.obtainMessage(100, remaining, 0, new Face(null, faceId, deviceId)).sendToTarget();
        }

        @Override
        public void onAcquired(long deviceId, int acquireInfo, int vendorCode) {
            FaceManager.this.mHandler.obtainMessage(101, acquireInfo, vendorCode, deviceId).sendToTarget();
        }

        @Override
        public void onAuthenticationSucceeded(long deviceId, Face face, int userId, boolean isStrongBiometric) {
            FaceManager.this.mHandler.obtainMessage(102, userId, isStrongBiometric ? 1 : 0, face).sendToTarget();
        }

        @Override
        public void onAuthenticationFailed(long deviceId) {
            FaceManager.this.mHandler.obtainMessage(103).sendToTarget();
        }

        @Override
        public void onError(long deviceId, int error, int vendorCode) {
            FaceManager.this.mHandler.obtainMessage(104, error, vendorCode, deviceId).sendToTarget();
        }

        @Override
        public void onRemoved(long deviceId, int faceId, int remaining) {
            FaceManager.this.mHandler.obtainMessage(105, remaining, 0, new Face(null, faceId, deviceId)).sendToTarget();
        }

        @Override
        public void onEnumerated(long deviceId, int faceId, int remaining) {
        }

        @Override
        public void onFeatureSet(boolean success, int feature) {
            FaceManager.this.mHandler.obtainMessage(107, feature, 0, success).sendToTarget();
        }

        @Override
        public void onFeatureGet(boolean success, int feature, boolean value) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = success;
            args.argi1 = feature;
            args.arg2 = value;
            FaceManager.this.mHandler.obtainMessage(106, args).sendToTarget();
        }
    };

    public FaceManager(Context context, IFaceService service) {
        this.mContext = context;
        this.mService = service;
        if (this.mService == null) {
            Slog.v(TAG, "FaceAuthenticationManagerService was null");
        }
        this.mHandler = new MyHandler(context);
    }

    public void authenticate(CryptoObject crypto, CancellationSignal cancel, int flags, AuthenticationCallback callback, Handler handler) {
        this.authenticate(crypto, cancel, flags, callback, handler, this.mContext.getUserId());
    }

    private void useHandler(Handler handler) {
        if (handler != null) {
            this.mHandler = new MyHandler(handler.getLooper());
        } else if (this.mHandler.getLooper() != this.mContext.getMainLooper()) {
            this.mHandler = new MyHandler(this.mContext.getMainLooper());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(CryptoObject crypto, CancellationSignal cancel, int flags, AuthenticationCallback callback, Handler handler, int userId) {
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an authentication callback");
        }
        if (cancel != null) {
            if (cancel.isCanceled()) {
                Log.w(TAG, "authentication already canceled");
                return;
            }
            cancel.setOnCancelListener(new OnAuthenticationCancelListener(crypto));
        }
        if (this.mService != null) {
            try {
                this.useHandler(handler);
                this.mAuthenticationCallback = callback;
                this.mCryptoObject = crypto;
                long sessionId = crypto != null ? crypto.getOpId() : 0L;
                Trace.beginSection("FaceManager#authenticate");
                this.mService.authenticate(this.mToken, sessionId, userId, this.mServiceReceiver, flags, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Remote exception while authenticating: ", e);
                if (callback != null) {
                    callback.onAuthenticationError(1, FaceManager.getErrorString(this.mContext, 1, 0));
                }
            }
            finally {
                Trace.endSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enroll(int userId, byte[] token, CancellationSignal cancel, EnrollmentCallback callback, int[] disabledFeatures) {
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an enrollment callback");
        }
        if (cancel != null) {
            if (cancel.isCanceled()) {
                Log.w(TAG, "enrollment already canceled");
                return;
            }
            cancel.setOnCancelListener(new OnEnrollCancelListener());
        }
        if (this.mService != null) {
            try {
                this.mEnrollmentCallback = callback;
                Trace.beginSection("FaceManager#enroll");
                this.mService.enroll(userId, this.mToken, token, this.mServiceReceiver, this.mContext.getOpPackageName(), disabledFeatures);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Remote exception in enroll: ", e);
                if (callback != null) {
                    callback.onEnrollmentError(1, FaceManager.getErrorString(this.mContext, 1, 0));
                }
            }
            finally {
                Trace.endSection();
            }
        }
    }

    public long generateChallenge() {
        long result = 0L;
        if (this.mService != null) {
            try {
                result = this.mService.generateChallenge(this.mToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result;
    }

    public int revokeChallenge() {
        int result = 0;
        if (this.mService != null) {
            try {
                result = this.mService.revokeChallenge(this.mToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result;
    }

    public void setFeature(int userId, int feature, boolean enabled, byte[] token, SetFeatureCallback callback) {
        if (this.mService != null) {
            try {
                this.mSetFeatureCallback = callback;
                this.mService.setFeature(userId, feature, enabled, token, this.mServiceReceiver, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void getFeature(int userId, int feature, GetFeatureCallback callback) {
        if (this.mService != null) {
            try {
                this.mGetFeatureCallback = callback;
                this.mService.getFeature(userId, feature, this.mServiceReceiver, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void userActivity() {
        if (this.mService != null) {
            try {
                this.mService.userActivity();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Override
    public void setActiveUser(int userId) {
        if (this.mService != null) {
            try {
                this.mService.setActiveUser(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void remove(Face face, int userId, RemovalCallback callback) {
        block3: {
            if (this.mService != null) {
                try {
                    this.mRemovalCallback = callback;
                    this.mRemovalFace = face;
                    this.mService.remove(this.mToken, face.getBiometricId(), userId, this.mServiceReceiver, this.mContext.getOpPackageName());
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Remote exception in remove: ", e);
                    if (callback == null) break block3;
                    callback.onRemovalError(face, 1, FaceManager.getErrorString(this.mContext, 1, 0));
                }
            }
        }
    }

    public List<Face> getEnrolledFaces(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getEnrolledFaces(userId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public List<Face> getEnrolledFaces() {
        return this.getEnrolledFaces(UserHandle.myUserId());
    }

    @Override
    public boolean hasEnrolledTemplates() {
        if (this.mService != null) {
            try {
                return this.mService.hasEnrolledFaces(UserHandle.myUserId(), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @Override
    public boolean hasEnrolledTemplates(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.hasEnrolledFaces(userId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @Override
    public boolean isHardwareDetected() {
        if (this.mService != null) {
            try {
                return this.mService.isHardwareDetected(this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Log.w(TAG, "isFaceHardwareDetected(): Service not connected!");
        return false;
    }

    public void addLockoutResetCallback(final LockoutResetCallback callback) {
        if (this.mService != null) {
            try {
                final PowerManager powerManager = this.mContext.getSystemService(PowerManager.class);
                this.mService.addLockoutResetCallback(new IBiometricServiceLockoutResetCallback.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLockoutReset(long deviceId, IRemoteCallback serverCallback) throws RemoteException {
                        try {
                            PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, "faceLockoutResetCallback");
                            wakeLock.acquire();
                            FaceManager.this.mHandler.post(() -> {
                                try {
                                    callback.onLockoutReset();
                                }
                                finally {
                                    wakeLock.release();
                                }
                            });
                        }
                        finally {
                            serverCallback.sendResult(null);
                        }
                    }
                });
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Log.w(TAG, "addLockoutResetCallback(): Service not connected!");
        }
    }

    private int getCurrentUserId() {
        try {
            return ActivityManager.getService().getCurrentUser().id;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void cancelEnrollment() {
        if (this.mService != null) {
            try {
                this.mService.cancelEnrollment(this.mToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private void cancelAuthentication(CryptoObject cryptoObject) {
        if (this.mService != null) {
            try {
                this.mService.cancelAuthentication(this.mToken, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public static String getErrorString(Context context, int errMsg, int vendorCode) {
        switch (errMsg) {
            case 1: {
                return context.getString(17040164);
            }
            case 2: {
                return context.getString(17040172);
            }
            case 3: {
                return context.getString(17040171);
            }
            case 4: {
                return context.getString(17040168);
            }
            case 5: {
                return context.getString(17040163);
            }
            case 7: {
                return context.getString(17040166);
            }
            case 9: {
                return context.getString(17040167);
            }
            case 10: {
                return context.getString(17040173);
            }
            case 11: {
                return context.getString(17040169);
            }
            case 12: {
                return context.getString(17040165);
            }
            case 15: {
                return context.getString(17040170);
            }
            case 8: {
                String[] msgArray = context.getResources().getStringArray(17236102);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Invalid error message: " + errMsg + ", " + vendorCode);
        return "";
    }

    public static String getAcquiredString(Context context, int acquireInfo, int vendorCode) {
        switch (acquireInfo) {
            case 0: {
                return null;
            }
            case 1: {
                return context.getString(17040141);
            }
            case 2: {
                return context.getString(17040150);
            }
            case 3: {
                return context.getString(17040152);
            }
            case 4: {
                return context.getString(17040151);
            }
            case 5: {
                return context.getString(17040154);
            }
            case 6: {
                return context.getString(17040155);
            }
            case 7: {
                return context.getString(17040157);
            }
            case 8: {
                return context.getString(17040159);
            }
            case 9: {
                return context.getString(17040156);
            }
            case 10: {
                return context.getString(17040145);
            }
            case 11: {
                return context.getString(17040142);
            }
            case 12: {
                return context.getString(17040158);
            }
            case 13: {
                return context.getString(17040146);
            }
            case 14: {
                return context.getString(17040153);
            }
            case 15: {
                return context.getString(17040160);
            }
            case 16: {
                return context.getString(17040144);
            }
            case 17: {
                return context.getString(17040149);
            }
            case 18: {
                return context.getString(17040147);
            }
            case 19: {
                return context.getString(17040143);
            }
            case 20: {
                return null;
            }
            case 21: {
                return context.getString(17040148);
            }
            case 22: {
                String[] msgArray = context.getResources().getStringArray(17236101);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Invalid acquired message: " + acquireInfo + ", " + vendorCode);
        return null;
    }

    public static int getMappedAcquiredInfo(int acquireInfo, int vendorCode) {
        switch (acquireInfo) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return 1;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return 2;
            }
            case 22: {
                return 1000 + vendorCode;
            }
        }
        return 0;
    }

    private void sendSetFeatureCompleted(boolean success, int feature) {
        if (this.mSetFeatureCallback == null) {
            return;
        }
        this.mSetFeatureCallback.onCompleted(success, feature);
    }

    private void sendGetFeatureCompleted(boolean success, int feature, boolean value) {
        if (this.mGetFeatureCallback == null) {
            return;
        }
        this.mGetFeatureCallback.onCompleted(success, feature, value);
    }

    private void sendRemovedResult(Face face, int remaining) {
        if (this.mRemovalCallback == null) {
            return;
        }
        if (face == null) {
            Log.e(TAG, "Received MSG_REMOVED, but face is null");
            return;
        }
        this.mRemovalCallback.onRemovalSucceeded(face, remaining);
    }

    private void sendErrorResult(long deviceId, int errMsgId, int vendorCode) {
        int clientErrMsgId;
        int n = clientErrMsgId = errMsgId == 8 ? vendorCode + 1000 : errMsgId;
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentError(clientErrMsgId, FaceManager.getErrorString(this.mContext, errMsgId, vendorCode));
        } else if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationError(clientErrMsgId, FaceManager.getErrorString(this.mContext, errMsgId, vendorCode));
        } else if (this.mRemovalCallback != null) {
            this.mRemovalCallback.onRemovalError(this.mRemovalFace, clientErrMsgId, FaceManager.getErrorString(this.mContext, errMsgId, vendorCode));
        }
    }

    private void sendEnrollResult(Face face, int remaining) {
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentProgress(remaining);
        }
    }

    private void sendAuthenticatedSucceeded(Face face, int userId, boolean isStrongBiometric) {
        if (this.mAuthenticationCallback != null) {
            AuthenticationResult result = new AuthenticationResult(this.mCryptoObject, face, userId, isStrongBiometric);
            this.mAuthenticationCallback.onAuthenticationSucceeded(result);
        }
    }

    private void sendAuthenticatedFailed() {
        if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationFailed();
        }
    }

    private void sendAcquiredResult(long deviceId, int acquireInfo, int vendorCode) {
        int clientInfo;
        if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationAcquired(acquireInfo);
        }
        String msg = FaceManager.getAcquiredString(this.mContext, acquireInfo, vendorCode);
        int n = clientInfo = acquireInfo == 22 ? vendorCode + 1000 : acquireInfo;
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentHelp(clientInfo, msg);
        } else if (this.mAuthenticationCallback != null && msg != null) {
            this.mAuthenticationCallback.onAuthenticationHelp(clientInfo, msg);
        }
    }

    private class MyHandler
    extends Handler {
        private MyHandler(Context context) {
            super(context.getMainLooper());
        }

        private MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            Trace.beginSection("FaceManager#handleMessage: " + Integer.toString(msg.what));
            switch (msg.what) {
                case 100: {
                    FaceManager.this.sendEnrollResult((Face)msg.obj, msg.arg1);
                    break;
                }
                case 101: {
                    FaceManager.this.sendAcquiredResult((Long)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 102: {
                    FaceManager.this.sendAuthenticatedSucceeded((Face)msg.obj, msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 103: {
                    FaceManager.this.sendAuthenticatedFailed();
                    break;
                }
                case 104: {
                    FaceManager.this.sendErrorResult((Long)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 105: {
                    FaceManager.this.sendRemovedResult((Face)msg.obj, msg.arg1);
                    break;
                }
                case 107: {
                    FaceManager.this.sendSetFeatureCompleted((Boolean)msg.obj, msg.arg1);
                    break;
                }
                case 106: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    FaceManager.this.sendGetFeatureCompleted((Boolean)args.arg1, args.argi1, (Boolean)args.arg2);
                    args.recycle();
                    break;
                }
                default: {
                    Log.w(FaceManager.TAG, "Unknown message: " + msg.what);
                }
            }
            Trace.endSection();
        }
    }

    private class OnAuthenticationCancelListener
    implements CancellationSignal.OnCancelListener {
        private CryptoObject mCrypto;

        OnAuthenticationCancelListener(CryptoObject crypto) {
            this.mCrypto = crypto;
        }

        @Override
        public void onCancel() {
            FaceManager.this.cancelAuthentication(this.mCrypto);
        }
    }

    private class OnEnrollCancelListener
    implements CancellationSignal.OnCancelListener {
        private OnEnrollCancelListener() {
        }

        @Override
        public void onCancel() {
            FaceManager.this.cancelEnrollment();
        }
    }

    public static abstract class GetFeatureCallback {
        public abstract void onCompleted(boolean var1, int var2, boolean var3);
    }

    public static abstract class SetFeatureCallback {
        public abstract void onCompleted(boolean var1, int var2);
    }

    public static abstract class LockoutResetCallback {
        public void onLockoutReset() {
        }
    }

    public static abstract class RemovalCallback {
        public void onRemovalError(Face face, int errMsgId, CharSequence errString) {
        }

        public void onRemovalSucceeded(Face face, int remaining) {
        }
    }

    public static abstract class EnrollmentCallback {
        public void onEnrollmentError(int errMsgId, CharSequence errString) {
        }

        public void onEnrollmentHelp(int helpMsgId, CharSequence helpString) {
        }

        public void onEnrollmentProgress(int remaining) {
        }
    }

    public static abstract class AuthenticationCallback
    extends BiometricAuthenticator.AuthenticationCallback {
        @Override
        public void onAuthenticationError(int errorCode, CharSequence errString) {
        }

        @Override
        public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
        }

        public void onAuthenticationSucceeded(AuthenticationResult result) {
        }

        @Override
        public void onAuthenticationFailed() {
        }

        @Override
        public void onAuthenticationAcquired(int acquireInfo) {
        }
    }

    public static class AuthenticationResult {
        private Face mFace;
        private CryptoObject mCryptoObject;
        private int mUserId;
        private boolean mIsStrongBiometric;

        public AuthenticationResult(CryptoObject crypto, Face face, int userId, boolean isStrongBiometric) {
            this.mCryptoObject = crypto;
            this.mFace = face;
            this.mUserId = userId;
            this.mIsStrongBiometric = isStrongBiometric;
        }

        public CryptoObject getCryptoObject() {
            return this.mCryptoObject;
        }

        public Face getFace() {
            return this.mFace;
        }

        public int getUserId() {
            return this.mUserId;
        }

        public boolean isStrongBiometric() {
            return this.mIsStrongBiometric;
        }
    }
}

