/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.graphics.BidiRenderer;
import android.graphics.Paint_Delegate;
import android.graphics.RectF;
import android.graphics.text.LineBreaker_Delegate;
import android.graphics.text.MeasuredText_Delegate;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.ArrayList;
import java.util.Arrays;

public class MeasuredText_Builder_Delegate {
    protected static final DelegateManager<MeasuredText_Builder_Delegate> sBuilderManager = new DelegateManager<MeasuredText_Builder_Delegate>(MeasuredText_Builder_Delegate.class);
    protected final ArrayList<LineBreaker_Delegate.Run> mRuns = new ArrayList();

    @LayoutlibDelegate
    static long nInitBuilder() {
        return sBuilderManager.addNewDelegate(new MeasuredText_Builder_Delegate());
    }

    @LayoutlibDelegate
    static void nAddStyleRun(long nativeBuilderPtr, long paintPtr, int start, int end, boolean isRtl) {
        MeasuredText_Builder_Delegate builder = sBuilderManager.getDelegate(nativeBuilderPtr);
        if (builder == null) {
            return;
        }
        builder.mRuns.add(new StyleRun(paintPtr, start, end, isRtl));
    }

    @LayoutlibDelegate
    static void nAddReplacementRun(long nativeBuilderPtr, long paintPtr, int start, int end, float width) {
        MeasuredText_Builder_Delegate builder = sBuilderManager.getDelegate(nativeBuilderPtr);
        if (builder == null) {
            return;
        }
        builder.mRuns.add(new ReplacementRun(start, end, width));
    }

    @LayoutlibDelegate
    static long nBuildMeasuredText(long nativeBuilderPtr, long hintMtPtr, char[] text, boolean computeHyphenation, boolean computeLayout) {
        MeasuredText_Delegate delegate = new MeasuredText_Delegate();
        delegate.mNativeBuilderPtr = nativeBuilderPtr;
        return MeasuredText_Delegate.sManager.addNewDelegate(delegate);
    }

    @LayoutlibDelegate
    static void nFreeBuilder(long nativeBuilderPtr) {
        sBuilderManager.removeJavaReferenceFor(nativeBuilderPtr);
    }

    private static float measureText(long nativePaint, char[] text, int index, int count, float[] widths, int bidiFlags) {
        Paint_Delegate paint = Paint_Delegate.getDelegate(nativePaint);
        RectF bounds = new BidiRenderer(null, paint, text).renderText(index, index + count, bidiFlags, widths, 0, false);
        return bounds.right - bounds.left;
    }

    private static class ReplacementRun
    extends LineBreaker_Delegate.Run {
        private final float mWidth;

        private ReplacementRun(int start, int end, float width) {
            super(start, end);
            this.mWidth = width;
        }

        @Override
        void addTo(LineBreaker_Delegate.Builder builder) {
            builder.mWidths[this.mStart] = this.mWidth;
            Arrays.fill(builder.mWidths, this.mStart + 1, this.mEnd, 0.0f);
        }
    }

    private static class StyleRun
    extends LineBreaker_Delegate.Run {
        private final long mNativePaint;
        private final boolean mIsRtl;

        private StyleRun(long nativePaint, int start, int end, boolean isRtl) {
            super(start, end);
            this.mNativePaint = nativePaint;
            this.mIsRtl = isRtl;
        }

        @Override
        void addTo(LineBreaker_Delegate.Builder builder) {
            int bidiFlags = this.mIsRtl ? 5 : 4;
            MeasuredText_Builder_Delegate.measureText(this.mNativePaint, builder.mText, this.mStart, this.mEnd - this.mStart, builder.mWidths, bidiFlags);
        }
    }
}

