/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.AssetManager;
import android.content.res.FontResourcesParser;
import android.graphics.FontFamily;
import android.graphics.Typeface_Builder_Delegate;
import android.graphics.Typeface_Delegate;
import android.graphics.fonts.Font;
import android.graphics.fonts.FontFamily;
import android.graphics.fonts.FontStyle;
import android.graphics.fonts.FontVariationAxis;
import android.graphics.fonts.SystemFonts;
import android.os.ParcelFileDescriptor;
import android.provider.FontRequest;
import android.provider.FontsContract;
import android.text.FontConfig;
import android.util.Base64;
import android.util.LongSparseArray;
import android.util.LruCache;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import libcore.util.NativeAllocationRegistry;

public class Typeface {
    private static String TAG;
    private static final NativeAllocationRegistry sRegistry;
    public static final Typeface DEFAULT;
    public static final Typeface DEFAULT_BOLD;
    public static final Typeface SANS_SERIF;
    public static final Typeface SERIF;
    public static final Typeface MONOSPACE;
    @UnsupportedAppUsage(trackingBug=123769446L)
    static Typeface[] sDefaults;
    @GuardedBy(value={"sStyledCacheLock"})
    private static final LongSparseArray<SparseArray<Typeface>> sStyledTypefaceCache;
    private static final Object sStyledCacheLock;
    @GuardedBy(value={"sWeightCacheLock"})
    private static final LongSparseArray<SparseArray<Typeface>> sWeightTypefaceCache;
    private static final Object sWeightCacheLock;
    @GuardedBy(value={"sDynamicCacheLock"})
    public static final LruCache<String, Typeface> sDynamicTypefaceCache;
    private static final Object sDynamicCacheLock;
    static Typeface sDefaultTypeface;
    @UnsupportedAppUsage(trackingBug=123769347L)
    static final Map<String, Typeface> sSystemFontMap;
    @Deprecated
    @UnsupportedAppUsage(trackingBug=123768928L)
    static final Map<String, FontFamily[]> sSystemFallbackMap;
    @UnsupportedAppUsage
    public long native_instance;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    public static final int STYLE_MASK = 3;
    @UnsupportedAppUsage
    private int mStyle = 0;
    private int mWeight = 0;
    public static final int RESOLVE_BY_FONT_TABLE = -1;
    public static final String DEFAULT_FAMILY = "sans-serif";
    private static final int STYLE_NORMAL = 0;
    private static final int STYLE_ITALIC = 1;
    private int[] mSupportedAxes;
    private static final int[] EMPTY_AXES;

    @UnsupportedAppUsage(maxTargetSdk=28)
    private static void setDefault(Typeface t) {
        sDefaultTypeface = t;
        Typeface.nativeSetDefault(t.native_instance);
    }

    public int getWeight() {
        return this.mWeight;
    }

    public int getStyle() {
        return this.mStyle;
    }

    public boolean isBold() {
        return (this.mStyle & 1) != 0;
    }

    public boolean isItalic() {
        return (this.mStyle & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromResources(FontResourcesParser.FamilyResourceEntry entry, AssetManager mgr, String path) {
        if (entry instanceof FontResourcesParser.ProviderResourceEntry) {
            FontRequest request;
            Typeface typeface;
            FontResourcesParser.ProviderResourceEntry providerEntry = (FontResourcesParser.ProviderResourceEntry)entry;
            List<List<String>> givenCerts = providerEntry.getCerts();
            ArrayList<List<byte[]>> certs = new ArrayList<List<byte[]>>();
            if (givenCerts != null) {
                for (int i = 0; i < givenCerts.size(); ++i) {
                    List<String> certSet = givenCerts.get(i);
                    ArrayList<byte[]> byteArraySet = new ArrayList<byte[]>();
                    for (int j = 0; j < certSet.size(); ++j) {
                        byteArraySet.add(Base64.decode(certSet.get(j), 0));
                    }
                    certs.add(byteArraySet);
                }
            }
            return (typeface = FontsContract.getFontSync(request = new FontRequest(providerEntry.getAuthority(), providerEntry.getPackage(), providerEntry.getQuery(), certs))) == null ? DEFAULT : typeface;
        }
        Typeface typeface = Typeface.findFromCache(mgr, path);
        if (typeface != null) {
            return typeface;
        }
        FontResourcesParser.FontFamilyFilesResourceEntry filesEntry = (FontResourcesParser.FontFamilyFilesResourceEntry)entry;
        try {
            FontFamily.Builder familyBuilder = null;
            for (FontResourcesParser.FontFileResourceEntry fontFile : filesEntry.getEntries()) {
                Font.Builder fontBuilder = new Font.Builder(mgr, fontFile.getFileName(), false, 0).setTtcIndex(fontFile.getTtcIndex()).setFontVariationSettings(fontFile.getVariationSettings());
                if (fontFile.getWeight() != -1) {
                    fontBuilder.setWeight(fontFile.getWeight());
                }
                if (fontFile.getItalic() != -1) {
                    fontBuilder.setSlant(fontFile.getItalic() == 1 ? 1 : 0);
                }
                if (familyBuilder == null) {
                    familyBuilder = new FontFamily.Builder(fontBuilder.build());
                    continue;
                }
                familyBuilder.addFont(fontBuilder.build());
            }
            if (familyBuilder == null) {
                return DEFAULT;
            }
            android.graphics.fonts.FontFamily family = familyBuilder.build();
            FontStyle normal = new FontStyle(400, 0);
            Font bestFont = family.getFont(0);
            int bestScore = normal.getMatchScore(bestFont.getStyle());
            for (int i = 1; i < family.getSize(); ++i) {
                Font candidate = family.getFont(i);
                int score = normal.getMatchScore(candidate.getStyle());
                if (score >= bestScore) continue;
                bestFont = candidate;
                bestScore = score;
            }
            typeface = new CustomFallbackBuilder(family).setStyle(bestFont.getStyle()).build();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IOException e) {
            typeface = DEFAULT;
        }
        Object object = sDynamicCacheLock;
        synchronized (object) {
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1, DEFAULT_FAMILY);
            sDynamicTypefaceCache.put(key, typeface);
        }
        return typeface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface findFromCache(AssetManager mgr, String path) {
        Object object = sDynamicCacheLock;
        synchronized (object) {
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1, DEFAULT_FAMILY);
            Typeface typeface = sDynamicTypefaceCache.get(key);
            if (typeface != null) {
                return typeface;
            }
        }
        return null;
    }

    public static Typeface create_Original(String familyName, int style2) {
        return Typeface.create(Typeface.getSystemDefaultTypeface(familyName), style2);
    }

    @LayoutlibDelegate
    public static Typeface create(String string2, int n) {
        return Typeface_Delegate.create(string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface create_Original(Typeface family, int style2) {
        Typeface typeface;
        if ((style2 & 0xFFFFFFFC) != 0) {
            style2 = 0;
        }
        if (family == null) {
            family = sDefaultTypeface;
        }
        if (family.mStyle == style2) {
            return family;
        }
        long ni = family.native_instance;
        Object object = sStyledCacheLock;
        synchronized (object) {
            SparseArray<Typeface> styles = sStyledTypefaceCache.get(ni);
            if (styles == null) {
                styles = new SparseArray(4);
                sStyledTypefaceCache.put(ni, styles);
            } else {
                typeface = styles.get(style2);
                if (typeface != null) {
                    return typeface;
                }
            }
            typeface = new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
            styles.put(style2, typeface);
        }
        return typeface;
    }

    @LayoutlibDelegate
    public static Typeface create(Typeface typeface, int n) {
        return Typeface_Delegate.create(typeface, n);
    }

    public static Typeface create_Original(Typeface family, int weight, boolean italic) {
        Preconditions.checkArgumentInRange(weight, 0, 1000, "weight");
        if (family == null) {
            family = sDefaultTypeface;
        }
        return Typeface.createWeightStyle(family, weight, italic);
    }

    @LayoutlibDelegate
    public static Typeface create(Typeface typeface, int n, boolean bl) {
        return Typeface_Delegate.create(typeface, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Typeface createWeightStyle(Typeface base, int weight, boolean italic) {
        Typeface typeface;
        int key = weight << 1 | (italic ? 1 : 0);
        Object object = sWeightCacheLock;
        synchronized (object) {
            SparseArray<Typeface> innerCache = sWeightTypefaceCache.get(base.native_instance);
            if (innerCache == null) {
                innerCache = new SparseArray(4);
                sWeightTypefaceCache.put(base.native_instance, innerCache);
            } else {
                typeface = innerCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
            }
            typeface = new Typeface(Typeface.nativeCreateFromTypefaceWithExactStyle(base.native_instance, weight, italic));
            innerCache.put(key, typeface);
        }
        return typeface;
    }

    public static Typeface createFromTypefaceWithVariation(Typeface family, List<FontVariationAxis> axes) {
        Typeface base = family == null ? DEFAULT : family;
        return new Typeface(Typeface.nativeCreateFromTypefaceWithVariation(base.native_instance, axes));
    }

    public static Typeface defaultFromStyle(int style2) {
        return sDefaults[style2];
    }

    public static Typeface createFromAsset(AssetManager mgr, String path) {
        Preconditions.checkNotNull(path);
        Preconditions.checkNotNull(mgr);
        Typeface typeface = new Builder(mgr, path).build();
        if (typeface != null) {
            return typeface;
        }
        try {
            InputStream inputStream = mgr.open(path);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Font asset not found " + path);
        }
        return DEFAULT;
    }

    private static String createProviderUid(String authority, String query) {
        StringBuilder builder = new StringBuilder();
        builder.append("provider:");
        builder.append(authority);
        builder.append("-");
        builder.append(query);
        return builder.toString();
    }

    public static Typeface createFromFile(File file) {
        Typeface typeface = new Builder(file).build();
        if (typeface != null) {
            return typeface;
        }
        if (!file.exists()) {
            throw new RuntimeException("Font asset not found " + file.getAbsolutePath());
        }
        return DEFAULT;
    }

    public static Typeface createFromFile(String path) {
        Preconditions.checkNotNull(path);
        return Typeface.createFromFile(new File(path));
    }

    @Deprecated
    @UnsupportedAppUsage(trackingBug=123768928L)
    private static Typeface createFromFamilies(FontFamily[] families) {
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, -1, -1));
    }

    private static Typeface createFromFamilies(android.graphics.fonts.FontFamily[] families) {
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].getNativePtr();
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, -1, -1));
    }

    @Deprecated
    @UnsupportedAppUsage(trackingBug=123768395L)
    private static Typeface createFromFamiliesWithDefault(FontFamily[] families, int weight, int italic) {
        return Typeface.createFromFamiliesWithDefault(families, DEFAULT_FAMILY, weight, italic);
    }

    @Deprecated
    @UnsupportedAppUsage(trackingBug=123768928L)
    private static Typeface createFromFamiliesWithDefault(FontFamily[] families, String fallbackName, int weight, int italic) {
        int i;
        android.graphics.fonts.FontFamily[] fallback = SystemFonts.getSystemFallback(fallbackName);
        long[] ptrArray = new long[families.length + fallback.length];
        for (i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        for (i = 0; i < fallback.length; ++i) {
            ptrArray[i + families.length] = fallback[i].getNativePtr();
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, weight, italic));
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private Typeface(long ni) {
        if (ni == 0L) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
        sRegistry.registerNativeAllocation(this, this.native_instance);
        this.mStyle = Typeface.nativeGetStyle(ni);
        this.mWeight = Typeface.nativeGetWeight(ni);
    }

    private static Typeface getSystemDefaultTypeface(String familyName) {
        Typeface tf = sSystemFontMap.get(familyName);
        return tf == null ? DEFAULT : tf;
    }

    @VisibleForTesting
    public static void initSystemDefaultTypefaces(Map<String, Typeface> systemFontMap, Map<String, android.graphics.fonts.FontFamily[]> fallbacks, FontConfig.Alias[] aliases) {
        for (Map.Entry<String, android.graphics.fonts.FontFamily[]> entry : fallbacks.entrySet()) {
            systemFontMap.put(entry.getKey(), Typeface.createFromFamilies(entry.getValue()));
        }
        for (FontConfig.Alias alias : aliases) {
            Typeface base;
            if (systemFontMap.containsKey(alias.getName()) || (base = systemFontMap.get(alias.getToName())) == null) continue;
            int weight = alias.getWeight();
            Typeface newFace = weight == 400 ? base : new Typeface(Typeface.nativeCreateWeightAlias(base.native_instance, weight));
            systemFontMap.put(alias.getName(), newFace);
        }
    }

    private static void registerGenericFamilyNative(String familyName, Typeface typeface) {
        if (typeface != null) {
            Typeface.nativeRegisterGenericFamily(familyName, typeface.native_instance);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Typeface typeface = (Typeface)o;
        return this.mStyle == typeface.mStyle && this.native_instance == typeface.native_instance;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.native_instance ^ this.native_instance >>> 32);
        result = 31 * result + this.mStyle;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupportedAxes(int axis) {
        if (this.mSupportedAxes == null) {
            Typeface typeface = this;
            synchronized (typeface) {
                if (this.mSupportedAxes == null) {
                    this.mSupportedAxes = Typeface.nativeGetSupportedAxes(this.native_instance);
                    if (this.mSupportedAxes == null) {
                        this.mSupportedAxes = EMPTY_AXES;
                    }
                }
            }
        }
        return Arrays.binarySearch(this.mSupportedAxes, axis) >= 0;
    }

    @LayoutlibDelegate
    private static long nativeCreateFromTypeface(long l, int n) {
        return Typeface_Delegate.nativeCreateFromTypeface(l, n);
    }

    @LayoutlibDelegate
    private static long nativeCreateFromTypefaceWithExactStyle(long l, int n, boolean bl) {
        return Typeface_Delegate.nativeCreateFromTypefaceWithExactStyle(l, n, bl);
    }

    @LayoutlibDelegate
    private static long nativeCreateFromTypefaceWithVariation(long l, List<FontVariationAxis> list) {
        return Typeface_Delegate.nativeCreateFromTypefaceWithVariation(l, list);
    }

    @LayoutlibDelegate
    @UnsupportedAppUsage
    private static long nativeCreateWeightAlias(long l, int n) {
        return Typeface_Delegate.nativeCreateWeightAlias(l, n);
    }

    @LayoutlibDelegate
    @UnsupportedAppUsage
    private static long nativeCreateFromArray(long[] lArray, int n, int n2) {
        return Typeface_Delegate.nativeCreateFromArray(lArray, n, n2);
    }

    @LayoutlibDelegate
    private static int[] nativeGetSupportedAxes(long l) {
        return Typeface_Delegate.nativeGetSupportedAxes(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nativeSetDefault(long l) {
        Typeface_Delegate.nativeSetDefault(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nativeGetStyle(long l) {
        return Typeface_Delegate.nativeGetStyle(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nativeGetWeight(long l) {
        return Typeface_Delegate.nativeGetWeight(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static long nativeGetReleaseFunc() {
        return Typeface_Delegate.nativeGetReleaseFunc();
    }

    @LayoutlibDelegate
    private static void nativeRegisterGenericFamily(String string2, long l) {
        Typeface_Delegate.nativeRegisterGenericFamily(string2, l);
    }

    static {
        String[] genericFamilies;
        TAG = "Typeface";
        sRegistry = NativeAllocationRegistry.createMalloced(Typeface.class.getClassLoader(), Typeface.nativeGetReleaseFunc());
        sStyledTypefaceCache = new LongSparseArray(3);
        sStyledCacheLock = new Object();
        sWeightTypefaceCache = new LongSparseArray(3);
        sWeightCacheLock = new Object();
        sDynamicTypefaceCache = new LruCache(16);
        sDynamicCacheLock = new Object();
        sSystemFallbackMap = Collections.emptyMap();
        EMPTY_AXES = new int[0];
        HashMap<String, Typeface> systemFontMap = new HashMap<String, Typeface>();
        Typeface.initSystemDefaultTypefaces(systemFontMap, SystemFonts.getRawSystemFallbackMap(), SystemFonts.getAliases());
        sSystemFontMap = Collections.unmodifiableMap(systemFontMap);
        if (sSystemFontMap.containsKey(DEFAULT_FAMILY)) {
            Typeface.setDefault(sSystemFontMap.get(DEFAULT_FAMILY));
        }
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create(DEFAULT_FAMILY, 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
        for (String genericFamily : genericFamilies = new String[]{"serif", DEFAULT_FAMILY, "cursive", "fantasy", "monospace", "system-ui"}) {
            Typeface.registerGenericFamilyNative(genericFamily, systemFontMap.get(genericFamily));
        }
    }

    public static class CustomFallbackBuilder {
        private static final int MAX_CUSTOM_FALLBACK = 64;
        private final ArrayList<android.graphics.fonts.FontFamily> mFamilies = new ArrayList();
        private String mFallbackName = null;
        private FontStyle mStyle;

        public static int getMaxCustomFallbackCount() {
            return 64;
        }

        public CustomFallbackBuilder(android.graphics.fonts.FontFamily family) {
            Preconditions.checkNotNull(family);
            this.mFamilies.add(family);
        }

        public CustomFallbackBuilder setSystemFallback(String familyName) {
            Preconditions.checkNotNull(familyName);
            this.mFallbackName = familyName;
            return this;
        }

        public CustomFallbackBuilder setStyle(FontStyle style2) {
            this.mStyle = style2;
            return this;
        }

        public CustomFallbackBuilder addCustomFallback(android.graphics.fonts.FontFamily family) {
            Preconditions.checkNotNull(family);
            Preconditions.checkArgument(this.mFamilies.size() < CustomFallbackBuilder.getMaxCustomFallbackCount(), "Custom fallback limit exceeded(" + CustomFallbackBuilder.getMaxCustomFallbackCount() + ")");
            this.mFamilies.add(family);
            return this;
        }

        public Typeface build() {
            int i;
            int userFallbackSize = this.mFamilies.size();
            android.graphics.fonts.FontFamily[] fallback = SystemFonts.getSystemFallback(this.mFallbackName);
            long[] ptrArray = new long[fallback.length + userFallbackSize];
            for (i = 0; i < userFallbackSize; ++i) {
                ptrArray[i] = this.mFamilies.get(i).getNativePtr();
            }
            for (i = 0; i < fallback.length; ++i) {
                ptrArray[i + userFallbackSize] = fallback[i].getNativePtr();
            }
            int weight = this.mStyle == null ? 400 : this.mStyle.getWeight();
            int italic = this.mStyle == null || this.mStyle.getSlant() == 0 ? 0 : 1;
            return new Typeface(Typeface.nativeCreateFromArray(ptrArray, weight, italic));
        }
    }

    public static class Builder {
        public static final int NORMAL_WEIGHT = 400;
        public static final int BOLD_WEIGHT = 700;
        private final AssetManager mAssetManager;
        private final String mPath;
        private final Font.Builder mFontBuilder;
        private String mFallbackFamilyName;
        private int mWeight = -1;
        private int mItalic = -1;

        public Builder(File path) {
            this.mFontBuilder = new Font.Builder(path);
            this.mAssetManager = null;
            this.mPath = null;
        }

        public Builder(FileDescriptor fd) {
            Font.Builder builder;
            try {
                builder = new Font.Builder(ParcelFileDescriptor.dup(fd));
            }
            catch (IOException e) {
                builder = null;
            }
            this.mFontBuilder = builder;
            this.mAssetManager = null;
            this.mPath = null;
        }

        public Builder(String path) {
            this.mFontBuilder = new Font.Builder(new File(path));
            this.mAssetManager = null;
            this.mPath = null;
        }

        public Builder(AssetManager assetManager, String path) {
            this(assetManager, path, true, 0);
        }

        public Builder(AssetManager assetManager, String path, boolean isAsset, int cookie) {
            this.mFontBuilder = new Font.Builder(assetManager, path, isAsset, cookie);
            this.mAssetManager = assetManager;
            this.mPath = path;
        }

        public Builder setWeight(int weight) {
            this.mWeight = weight;
            this.mFontBuilder.setWeight(weight);
            return this;
        }

        public Builder setItalic(boolean italic) {
            this.mItalic = italic ? 1 : 0;
            this.mFontBuilder.setSlant(this.mItalic);
            return this;
        }

        public Builder setTtcIndex(int ttcIndex) {
            this.mFontBuilder.setTtcIndex(ttcIndex);
            return this;
        }

        public Builder setFontVariationSettings(String variationSettings) {
            this.mFontBuilder.setFontVariationSettings(variationSettings);
            return this;
        }

        public Builder setFontVariationSettings(FontVariationAxis[] axes) {
            this.mFontBuilder.setFontVariationSettings(axes);
            return this;
        }

        public Builder setFallback(String familyName) {
            this.mFallbackFamilyName = familyName;
            return this;
        }

        static String createAssetUid_Original(AssetManager mgr, String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic, String fallback) {
            SparseArray<String> pkgs = mgr.getAssignedPackageIdentifiers();
            StringBuilder builder = new StringBuilder();
            int size = pkgs.size();
            for (int i = 0; i < size; ++i) {
                builder.append(pkgs.valueAt(i));
                builder.append("-");
            }
            builder.append(path);
            builder.append("-");
            builder.append(Integer.toString(ttcIndex));
            builder.append("-");
            builder.append(Integer.toString(weight));
            builder.append("-");
            builder.append(Integer.toString(italic));
            builder.append("--");
            builder.append(fallback);
            builder.append("--");
            if (axes != null) {
                for (FontVariationAxis axis : axes) {
                    builder.append(axis.getTag());
                    builder.append("-");
                    builder.append(Float.toString(axis.getStyleValue()));
                }
            }
            return builder.toString();
        }

        @LayoutlibDelegate
        private static String createAssetUid(AssetManager assetManager, String string2, int n, FontVariationAxis[] fontVariationAxisArray, int n2, int n3, String string3) {
            return Typeface_Builder_Delegate.createAssetUid(assetManager, string2, n, fontVariationAxisArray, n2, n3, string3);
        }

        private Typeface resolveFallbackTypeface() {
            int weight;
            if (this.mFallbackFamilyName == null) {
                return null;
            }
            Typeface base = Typeface.getSystemDefaultTypeface(this.mFallbackFamilyName);
            if (this.mWeight == -1 && this.mItalic == -1) {
                return base;
            }
            int n = weight = this.mWeight == -1 ? base.mWeight : this.mWeight;
            boolean italic = this.mItalic == -1 ? (base.mStyle & 2) != 0 : this.mItalic == 1;
            return Typeface.createWeightStyle(base, weight, italic);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Typeface build() {
            if (this.mFontBuilder == null) {
                return this.resolveFallbackTypeface();
            }
            try {
                String key;
                Font font = this.mFontBuilder.build();
                String string2 = this.mAssetManager == null ? null : (key = Builder.createAssetUid(this.mAssetManager, this.mPath, font.getTtcIndex(), font.getAxes(), this.mWeight, this.mItalic, this.mFallbackFamilyName == null ? Typeface.DEFAULT_FAMILY : this.mFallbackFamilyName));
                if (key != null) {
                    Object object = sDynamicCacheLock;
                    synchronized (object) {
                        Typeface typeface = (Typeface)sDynamicTypefaceCache.get(key);
                        if (typeface != null) {
                            return typeface;
                        }
                    }
                }
                android.graphics.fonts.FontFamily family = new FontFamily.Builder(font).build();
                int weight = this.mWeight == -1 ? font.getStyle().getWeight() : this.mWeight;
                int slant = this.mItalic == -1 ? font.getStyle().getSlant() : this.mItalic;
                CustomFallbackBuilder builder = new CustomFallbackBuilder(family).setStyle(new FontStyle(weight, slant));
                if (this.mFallbackFamilyName != null) {
                    builder.setSystemFallback(this.mFallbackFamilyName);
                }
                Typeface typeface = builder.build();
                if (key != null) {
                    Object object = sDynamicCacheLock;
                    synchronized (object) {
                        sDynamicTypefaceCache.put(key, typeface);
                    }
                }
                return typeface;
            }
            catch (IOException | IllegalArgumentException e) {
                return this.resolveFallbackTypeface();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Style {
    }
}

