/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.graphics.RenderNode;
import android.util.Pools;
import android.view.DisplayListCanvas;
import android.view.TextureLayer;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;

public class RecordingCanvas
extends DisplayListCanvas {
    private static final int POOL_LIMIT = 25;
    public static final int MAX_BITMAP_SIZE = 0x6400000;
    private static final Pools.SynchronizedPool<RecordingCanvas> sPool = new Pools.SynchronizedPool(25);
    public RenderNode mNode;
    private int mWidth;
    private int mHeight;

    static RecordingCanvas obtain(RenderNode node, int width, int height) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        RecordingCanvas canvas = sPool.acquire();
        if (canvas == null) {
            canvas = new RecordingCanvas(node, width, height);
        } else {
            RecordingCanvas.nResetDisplayListCanvas(canvas.mNativeCanvasWrapper, node.mNativeRenderNode, width, height);
        }
        canvas.mNode = node;
        canvas.mWidth = width;
        canvas.mHeight = height;
        return canvas;
    }

    void recycle() {
        this.mNode = null;
        sPool.release(this);
    }

    long finishRecording() {
        return RecordingCanvas.nFinishRecording(this.mNativeCanvasWrapper);
    }

    @Override
    public boolean isRecordingFor(Object o) {
        return o == this.mNode;
    }

    protected RecordingCanvas(RenderNode node, int width, int height) {
        super(RecordingCanvas.nCreateDisplayListCanvas(node.mNativeRenderNode, width, height));
        this.mDensity = 0;
    }

    @Override
    public void setDensity(int density) {
    }

    @Override
    public boolean isHardwareAccelerated() {
        return true;
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getMaximumBitmapWidth() {
        return RecordingCanvas.nGetMaximumTextureWidth();
    }

    @Override
    public int getMaximumBitmapHeight() {
        return RecordingCanvas.nGetMaximumTextureHeight();
    }

    @Override
    public void enableZ() {
        RecordingCanvas.nInsertReorderBarrier(this.mNativeCanvasWrapper, true);
    }

    @Override
    public void disableZ() {
        RecordingCanvas.nInsertReorderBarrier(this.mNativeCanvasWrapper, false);
    }

    @Deprecated
    public void callDrawGLFunction2(long drawGLFunction) {
        RecordingCanvas.nCallDrawGLFunction(this.mNativeCanvasWrapper, drawGLFunction, null);
    }

    @Deprecated
    public void drawGLFunctor2(long drawGLFunctor, Runnable releasedCallback) {
        RecordingCanvas.nCallDrawGLFunction(this.mNativeCanvasWrapper, drawGLFunctor, releasedCallback);
    }

    public void drawWebViewFunctor(int functor) {
        RecordingCanvas.nDrawWebViewFunctor(this.mNativeCanvasWrapper, functor);
    }

    @Override
    public void drawRenderNode(RenderNode renderNode) {
        RecordingCanvas.nDrawRenderNode(this.mNativeCanvasWrapper, renderNode.mNativeRenderNode);
    }

    public void drawTextureLayer(TextureLayer layer) {
        RecordingCanvas.nDrawTextureLayer(this.mNativeCanvasWrapper, layer.getLayerHandle());
    }

    @Override
    public void drawCircle(CanvasProperty<Float> cx, CanvasProperty<Float> cy, CanvasProperty<Float> radius, CanvasProperty<Paint> paint) {
        RecordingCanvas.nDrawCircle(this.mNativeCanvasWrapper, cx.getNativeContainer(), cy.getNativeContainer(), radius.getNativeContainer(), paint.getNativeContainer());
    }

    @Override
    public void drawRoundRect(CanvasProperty<Float> left, CanvasProperty<Float> top, CanvasProperty<Float> right, CanvasProperty<Float> bottom, CanvasProperty<Float> rx, CanvasProperty<Float> ry, CanvasProperty<Paint> paint) {
        RecordingCanvas.nDrawRoundRect(this.mNativeCanvasWrapper, left.getNativeContainer(), top.getNativeContainer(), right.getNativeContainer(), bottom.getNativeContainer(), rx.getNativeContainer(), ry.getNativeContainer(), paint.getNativeContainer());
    }

    @Override
    protected void throwIfCannotDraw(Bitmap bitmap) {
        super.throwIfCannotDraw(bitmap);
        int bitmapSize = bitmap.getByteCount();
        if (bitmapSize > 0x6400000) {
            throw new RuntimeException("Canvas: trying to draw too large(" + bitmapSize + "bytes) bitmap.");
        }
    }

    @FastNative
    private static void nCallDrawGLFunction(long l, long l2, Runnable runnable) {
        OverrideMethod.invokeV("android.graphics.RecordingCanvas#nCallDrawGLFunction(JJLjava/lang/Runnable;)V", true, null);
    }

    @CriticalNative
    private static long nCreateDisplayListCanvas(long l, int n, int n2) {
        return OverrideMethod.invokeL("android.graphics.RecordingCanvas#nCreateDisplayListCanvas(JII)J", true, null);
    }

    @CriticalNative
    private static void nResetDisplayListCanvas(long l, long l2, int n, int n2) {
        OverrideMethod.invokeV("android.graphics.RecordingCanvas#nResetDisplayListCanvas(JJII)V", true, null);
    }

    @CriticalNative
    private static int nGetMaximumTextureWidth() {
        return OverrideMethod.invokeI("android.graphics.RecordingCanvas#nGetMaximumTextureWidth()I", true, null);
    }

    @CriticalNative
    private static int nGetMaximumTextureHeight() {
        return OverrideMethod.invokeI("android.graphics.RecordingCanvas#nGetMaximumTextureHeight()I", true, null);
    }

    @CriticalNative
    private static void nInsertReorderBarrier(long l, boolean bl) {
        OverrideMethod.invokeV("android.graphics.RecordingCanvas#nInsertReorderBarrier(JZ)V", true, null);
    }

    @CriticalNative
    private static long nFinishRecording(long l) {
        return OverrideMethod.invokeL("android.graphics.RecordingCanvas#nFinishRecording(J)J", true, null);
    }

    @CriticalNative
    private static void nDrawRenderNode(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.RecordingCanvas#nDrawRenderNode(JJ)V", true, null);
    }

    @CriticalNative
    private static void nDrawTextureLayer(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.RecordingCanvas#nDrawTextureLayer(JJ)V", true, null);
    }

    @CriticalNative
    private static void nDrawCircle(long l, long l2, long l3, long l4, long l5) {
        OverrideMethod.invokeV("android.graphics.RecordingCanvas#nDrawCircle(JJJJJ)V", true, null);
    }

    @CriticalNative
    private static void nDrawRoundRect(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        OverrideMethod.invokeV("android.graphics.RecordingCanvas#nDrawRoundRect(JJJJJJJJ)V", true, null);
    }

    @CriticalNative
    private static void nDrawWebViewFunctor(long l, int n) {
        OverrideMethod.invokeV("android.graphics.RecordingCanvas#nDrawWebViewFunctor(JI)V", true, null);
    }
}

