/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.LinearGradient_Delegate;
import android.graphics.Shader;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class LinearGradient
extends Shader {
    @UnsupportedAppUsage
    private float mX0;
    @UnsupportedAppUsage
    private float mY0;
    @UnsupportedAppUsage
    private float mX1;
    @UnsupportedAppUsage
    private float mY1;
    @UnsupportedAppUsage
    private float[] mPositions;
    @UnsupportedAppUsage
    private Shader.TileMode mTileMode;
    @UnsupportedAppUsage
    private int[] mColors;
    @UnsupportedAppUsage
    private int mColor0;
    @UnsupportedAppUsage
    private int mColor1;
    private final long[] mColorLongs;

    public LinearGradient(float x0, float y0, float x1, float y1, int[] colors, float[] positions, Shader.TileMode tile) {
        this(x0, y0, x1, y1, LinearGradient.convertColors(colors), positions, tile, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    public LinearGradient(float x0, float y0, float x1, float y1, long[] colors, float[] positions, Shader.TileMode tile) {
        this(x0, y0, x1, y1, (long[])colors.clone(), positions, tile, LinearGradient.detectColorSpace(colors));
    }

    private LinearGradient(float x0, float y0, float x1, float y1, long[] colors, float[] positions, Shader.TileMode tile, ColorSpace colorSpace) {
        super(colorSpace);
        if (positions != null && colors.length != positions.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mX0 = x0;
        this.mY0 = y0;
        this.mX1 = x1;
        this.mY1 = y1;
        this.mColorLongs = colors;
        this.mPositions = positions != null ? (float[])positions.clone() : null;
        this.mTileMode = tile;
    }

    public LinearGradient(float x0, float y0, float x1, float y1, int color0, int color1, Shader.TileMode tile) {
        this(x0, y0, x1, y1, Color.pack(color0), Color.pack(color1), tile);
    }

    public LinearGradient(float x0, float y0, float x1, float y1, long color0, long color1, Shader.TileMode tile) {
        this(x0, y0, x1, y1, new long[]{color0, color1}, null, tile);
    }

    @Override
    long createNativeInstance(long nativeMatrix) {
        return this.nativeCreate(nativeMatrix, this.mX0, this.mY0, this.mX1, this.mY1, this.mColorLongs, this.mPositions, this.mTileMode.nativeInt, this.colorSpace().getNativeInstance());
    }

    @LayoutlibDelegate
    private long nativeCreate(long l, float f, float f2, float f3, float f4, long[] lArray, float[] fArray, int n, long l2) {
        return LinearGradient_Delegate.nativeCreate(this, l, f, f2, f3, f4, lArray, fArray, n, l2);
    }
}

