/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.app.ActivityManager;
import android.graphics.Bitmap;
import android.graphics.FrameInfo;
import android.graphics.HardwareRendererObserver;
import android.graphics.Picture;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RenderNode;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.view.IGraphicsStats;
import android.view.IGraphicsStatsCallback;
import android.view.NativeVectorDrawableAnimator;
import android.view.Surface;
import android.view.TextureLayer;
import android.view.animation.AnimationUtils;
import com.android.layoutlib.bridge.libcore.util.Cleaner;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileDescriptor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public class HardwareRenderer {
    private static final String LOG_TAG = "HardwareRenderer";
    public static final int SYNC_OK = 0;
    public static final int SYNC_REDRAW_REQUESTED = 1;
    public static final int SYNC_LOST_SURFACE_REWARD_IF_FOUND = 2;
    public static final int SYNC_CONTEXT_IS_STOPPED = 4;
    public static final int SYNC_FRAME_DROPPED = 8;
    public static final int FLAG_DUMP_FRAMESTATS = 1;
    public static final int FLAG_DUMP_RESET = 2;
    public static final int FLAG_DUMP_ALL = 1;
    private static final String CACHE_PATH_SHADERS = "com.android.opengl.shaders_cache";
    private static final String CACHE_PATH_SKIASHADERS = "com.android.skia.shaders_cache";
    private final long mNativeProxy;
    protected RenderNode mRootNode;
    private boolean mOpaque = true;
    private boolean mForceDark = false;
    private boolean mIsWideGamut = false;
    private FrameRenderRequest mRenderRequest = new FrameRenderRequest();

    public HardwareRenderer() {
        this.mRootNode = RenderNode.adopt(HardwareRenderer.nCreateRootRenderNode());
        this.mRootNode.setClipToBounds(false);
        this.mNativeProxy = HardwareRenderer.nCreateProxy(!this.mOpaque, this.mIsWideGamut, this.mRootNode.mNativeRenderNode);
        if (this.mNativeProxy == 0L) {
            throw new OutOfMemoryError("Unable to create hardware renderer");
        }
        Cleaner.create(this, new DestroyContextRunnable(this.mNativeProxy));
        ProcessInitializer.sInstance.init(this.mNativeProxy);
    }

    public void destroy() {
        HardwareRenderer.nDestroy(this.mNativeProxy, this.mRootNode.mNativeRenderNode);
    }

    public void setName(String name) {
        HardwareRenderer.nSetName(this.mNativeProxy, name);
    }

    public void setLightSourceGeometry(float lightX, float lightY, float lightZ, float lightRadius) {
        HardwareRenderer.validateFinite(lightX, "lightX");
        HardwareRenderer.validateFinite(lightY, "lightY");
        HardwareRenderer.validatePositive(lightZ, "lightZ");
        HardwareRenderer.validatePositive(lightRadius, "lightRadius");
        HardwareRenderer.nSetLightGeometry(this.mNativeProxy, lightX, lightY, lightZ, lightRadius);
    }

    public void setLightSourceAlpha(float ambientShadowAlpha, float spotShadowAlpha) {
        HardwareRenderer.validateAlpha(ambientShadowAlpha, "ambientShadowAlpha");
        HardwareRenderer.validateAlpha(spotShadowAlpha, "spotShadowAlpha");
        HardwareRenderer.nSetLightAlpha(this.mNativeProxy, ambientShadowAlpha, spotShadowAlpha);
    }

    public void setContentRoot(RenderNode content) {
        RecordingCanvas canvas = this.mRootNode.beginRecording();
        if (content != null) {
            canvas.drawRenderNode(content);
        }
        this.mRootNode.endRecording();
    }

    public void setSurface(Surface surface) {
        this.setSurface(surface, false);
    }

    public void setSurface(Surface surface, boolean discardBuffer) {
        if (surface != null && !surface.isValid()) {
            throw new IllegalArgumentException("Surface is invalid. surface.isValid() == false.");
        }
        HardwareRenderer.nSetSurface(this.mNativeProxy, surface, discardBuffer);
    }

    public FrameRenderRequest createRenderRequest() {
        this.mRenderRequest.reset();
        return this.mRenderRequest;
    }

    public int syncAndDrawFrame(FrameInfo frameInfo) {
        return HardwareRenderer.nSyncAndDrawFrame(this.mNativeProxy, frameInfo.frameInfo, frameInfo.frameInfo.length);
    }

    public boolean pause() {
        return HardwareRenderer.nPause(this.mNativeProxy);
    }

    public void setStopped(boolean stopped) {
        HardwareRenderer.nSetStopped(this.mNativeProxy, stopped);
    }

    public void stop() {
        HardwareRenderer.nSetStopped(this.mNativeProxy, true);
    }

    public void start() {
        HardwareRenderer.nSetStopped(this.mNativeProxy, false);
    }

    public void clearContent() {
        HardwareRenderer.nDestroyHardwareResources(this.mNativeProxy);
    }

    public boolean setForceDark(boolean enable) {
        if (this.mForceDark != enable) {
            this.mForceDark = enable;
            HardwareRenderer.nSetForceDark(this.mNativeProxy, enable);
            return true;
        }
        return false;
    }

    public void allocateBuffers() {
        HardwareRenderer.nAllocateBuffers(this.mNativeProxy);
    }

    public void notifyFramePending() {
        HardwareRenderer.nNotifyFramePending(this.mNativeProxy);
    }

    public void setOpaque(boolean opaque) {
        if (this.mOpaque != opaque) {
            this.mOpaque = opaque;
            HardwareRenderer.nSetOpaque(this.mNativeProxy, this.mOpaque);
        }
    }

    public boolean isOpaque() {
        return this.mOpaque;
    }

    public void setFrameCompleteCallback(FrameCompleteCallback callback) {
        HardwareRenderer.nSetFrameCompleteCallback(this.mNativeProxy, callback);
    }

    public void addObserver(HardwareRendererObserver observer) {
        HardwareRenderer.nAddObserver(this.mNativeProxy, observer.getNativeInstance());
    }

    public void removeObserver(HardwareRendererObserver observer) {
        HardwareRenderer.nRemoveObserver(this.mNativeProxy, observer.getNativeInstance());
    }

    public void setWideGamut(boolean wideGamut) {
        this.mIsWideGamut = wideGamut;
        HardwareRenderer.nSetWideGamut(this.mNativeProxy, wideGamut);
    }

    public void fence() {
        HardwareRenderer.nFence(this.mNativeProxy);
    }

    public void registerAnimatingRenderNode(RenderNode animator2) {
        HardwareRenderer.nRegisterAnimatingRenderNode(this.mRootNode.mNativeRenderNode, animator2.mNativeRenderNode);
    }

    public void registerVectorDrawableAnimator(NativeVectorDrawableAnimator animator2) {
        HardwareRenderer.nRegisterVectorDrawableAnimator(this.mRootNode.mNativeRenderNode, animator2.getAnimatorNativePtr());
    }

    public void stopDrawing() {
        HardwareRenderer.nStopDrawing(this.mNativeProxy);
    }

    public TextureLayer createTextureLayer() {
        long layer = HardwareRenderer.nCreateTextureLayer(this.mNativeProxy);
        return TextureLayer.adoptTextureLayer(this, layer);
    }

    public void detachSurfaceTexture(long hardwareLayer) {
        HardwareRenderer.nDetachSurfaceTexture(this.mNativeProxy, hardwareLayer);
    }

    public void buildLayer(RenderNode node) {
        if (node.hasDisplayList()) {
            HardwareRenderer.nBuildLayer(this.mNativeProxy, node.mNativeRenderNode);
        }
    }

    public boolean copyLayerInto(TextureLayer layer, Bitmap bitmap) {
        return HardwareRenderer.nCopyLayerInto(this.mNativeProxy, layer.getDeferredLayerUpdater(), bitmap.getNativeInstance());
    }

    public void pushLayerUpdate(TextureLayer layer) {
        HardwareRenderer.nPushLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    public void onLayerDestroyed(TextureLayer layer) {
        HardwareRenderer.nCancelLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    public void setFrameCallback(FrameDrawingCallback callback) {
        HardwareRenderer.nSetFrameCallback(this.mNativeProxy, callback);
    }

    public void addRenderNode(RenderNode node, boolean placeFront) {
        HardwareRenderer.nAddRenderNode(this.mNativeProxy, node.mNativeRenderNode, placeFront);
    }

    public void removeRenderNode(RenderNode node) {
        HardwareRenderer.nRemoveRenderNode(this.mNativeProxy, node.mNativeRenderNode);
    }

    public void drawRenderNode(RenderNode node) {
        HardwareRenderer.nDrawRenderNode(this.mNativeProxy, node.mNativeRenderNode);
    }

    public boolean loadSystemProperties() {
        return HardwareRenderer.nLoadSystemProperties(this.mNativeProxy);
    }

    public void dumpProfileInfo(FileDescriptor fd, int dumpFlags) {
        HardwareRenderer.nDumpProfileInfo(this.mNativeProxy, fd, dumpFlags);
    }

    public void setContentDrawBounds(int left, int top, int right, int bottom) {
        HardwareRenderer.nSetContentDrawBounds(this.mNativeProxy, left, top, right, bottom);
    }

    public void setPictureCaptureCallback(PictureCapturedCallback callback) {
        HardwareRenderer.nSetPictureCaptureCallback(this.mNativeProxy, callback);
    }

    public boolean isWideGamut() {
        return this.mIsWideGamut;
    }

    static void invokePictureCapturedCallback(long picturePtr, PictureCapturedCallback callback) {
        Picture picture = new Picture(picturePtr);
        callback.onPictureCaptured(picture);
    }

    private static void validateAlpha(float alpha, String argumentName) {
        if (!(alpha >= 0.0f) || !(alpha <= 1.0f)) {
            throw new IllegalArgumentException(argumentName + " must be a valid alpha, " + alpha + " is not in the range of 0.0f to 1.0f");
        }
    }

    private static void validatePositive(float f, String argumentName) {
        if (!Float.isFinite(f) || !(f >= 0.0f)) {
            throw new IllegalArgumentException(argumentName + " must be a finite positive, given=" + f);
        }
    }

    private static void validateFinite(float f, String argumentName) {
        if (!Float.isFinite(f)) {
            throw new IllegalArgumentException(argumentName + " must be finite, given=" + f);
        }
    }

    public static void invokeFunctor(long functor, boolean waitForCompletion) {
        HardwareRenderer.nInvokeFunctor(functor, waitForCompletion);
    }

    public static void setFPSDivisor(int divisor) {
        HardwareRenderer.nHackySetRTAnimationsEnabled(divisor <= 1);
    }

    public static void setContextPriority(int priority) {
        HardwareRenderer.nSetContextPriority(priority);
    }

    public static void setHighContrastText(boolean highContrastText) {
        HardwareRenderer.nSetHighContrastText(highContrastText);
    }

    public static void setIsolatedProcess(boolean isIsolated) {
        HardwareRenderer.nSetIsolatedProcess(isIsolated);
    }

    public static void setDebuggingEnabled(boolean enable) {
        HardwareRenderer.nSetDebuggingEnabled(enable);
    }

    public static int copySurfaceInto(Surface surface, Rect srcRect, Bitmap bitmap) {
        if (srcRect == null) {
            return HardwareRenderer.nCopySurfaceInto(surface, 0, 0, 0, 0, bitmap.getNativeInstance());
        }
        return HardwareRenderer.nCopySurfaceInto(surface, srcRect.left, srcRect.top, srcRect.right, srcRect.bottom, bitmap.getNativeInstance());
    }

    public static Bitmap createHardwareBitmap(RenderNode node, int width, int height) {
        return HardwareRenderer.nCreateHardwareBitmap(node.mNativeRenderNode, width, height);
    }

    public static void trimMemory(int level) {
        HardwareRenderer.nTrimMemory(level);
    }

    public static void overrideProperty(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name and value must be non-null");
        }
        HardwareRenderer.nOverrideProperty(name, value);
    }

    public static void setupDiskCache(File cacheDir) {
        HardwareRenderer.setupShadersDiskCache(new File(cacheDir, CACHE_PATH_SHADERS).getAbsolutePath(), new File(cacheDir, CACHE_PATH_SKIASHADERS).getAbsolutePath());
    }

    public static void setPackageName(String packageName) {
        ProcessInitializer.sInstance.setPackageName(packageName);
    }

    public static void disableVsync() {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#disableVsync()V", true, null);
    }

    public static void preload() {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#preload()V", true, null);
    }

    protected static void setupShadersDiskCache(String string2, String string3) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#setupShadersDiskCache(Ljava/lang/String;Ljava/lang/String;)V", true, null);
    }

    private static void nRotateProcessStatsBuffer() {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nRotateProcessStatsBuffer()V", true, null);
    }

    private static void nSetProcessStatsBuffer(int n) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetProcessStatsBuffer(I)V", true, null);
    }

    private static int nGetRenderThreadTid(long l) {
        return OverrideMethod.invokeI("android.graphics.HardwareRenderer#nGetRenderThreadTid(J)I", true, null);
    }

    private static long nCreateRootRenderNode() {
        return OverrideMethod.invokeL("android.graphics.HardwareRenderer#nCreateRootRenderNode()J", true, null);
    }

    private static long nCreateProxy(boolean bl, boolean bl2, long l) {
        return OverrideMethod.invokeL("android.graphics.HardwareRenderer#nCreateProxy(ZZJ)J", true, null);
    }

    private static void nDeleteProxy(long l) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nDeleteProxy(J)V", true, null);
    }

    private static boolean nLoadSystemProperties(long l) {
        return OverrideMethod.invokeI("android.graphics.HardwareRenderer#nLoadSystemProperties(J)Z", true, null) != 0;
    }

    private static void nSetName(long l, String string2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetName(JLjava/lang/String;)V", true, null);
    }

    private static void nSetSurface(long l, Surface surface, boolean bl) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetSurface(JLandroid/view/Surface;Z)V", true, null);
    }

    private static boolean nPause(long l) {
        return OverrideMethod.invokeI("android.graphics.HardwareRenderer#nPause(J)Z", true, null) != 0;
    }

    private static void nSetStopped(long l, boolean bl) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetStopped(JZ)V", true, null);
    }

    private static void nSetLightGeometry(long l, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetLightGeometry(JFFFF)V", true, null);
    }

    private static void nSetLightAlpha(long l, float f, float f2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetLightAlpha(JFF)V", true, null);
    }

    private static void nSetOpaque(long l, boolean bl) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetOpaque(JZ)V", true, null);
    }

    private static void nSetWideGamut(long l, boolean bl) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetWideGamut(JZ)V", true, null);
    }

    private static int nSyncAndDrawFrame(long l, long[] lArray, int n) {
        return OverrideMethod.invokeI("android.graphics.HardwareRenderer#nSyncAndDrawFrame(J[JI)I", true, null);
    }

    private static void nDestroy(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nDestroy(JJ)V", true, null);
    }

    private static void nRegisterAnimatingRenderNode(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nRegisterAnimatingRenderNode(JJ)V", true, null);
    }

    private static void nRegisterVectorDrawableAnimator(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nRegisterVectorDrawableAnimator(JJ)V", true, null);
    }

    private static void nInvokeFunctor(long l, boolean bl) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nInvokeFunctor(JZ)V", true, null);
    }

    private static long nCreateTextureLayer(long l) {
        return OverrideMethod.invokeL("android.graphics.HardwareRenderer#nCreateTextureLayer(J)J", true, null);
    }

    private static void nBuildLayer(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nBuildLayer(JJ)V", true, null);
    }

    private static boolean nCopyLayerInto(long l, long l2, long l3) {
        return OverrideMethod.invokeI("android.graphics.HardwareRenderer#nCopyLayerInto(JJJ)Z", true, null) != 0;
    }

    private static void nPushLayerUpdate(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nPushLayerUpdate(JJ)V", true, null);
    }

    private static void nCancelLayerUpdate(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nCancelLayerUpdate(JJ)V", true, null);
    }

    private static void nDetachSurfaceTexture(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nDetachSurfaceTexture(JJ)V", true, null);
    }

    private static void nDestroyHardwareResources(long l) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nDestroyHardwareResources(J)V", true, null);
    }

    private static void nTrimMemory(int n) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nTrimMemory(I)V", true, null);
    }

    private static void nOverrideProperty(String string2, String string3) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nOverrideProperty(Ljava/lang/String;Ljava/lang/String;)V", true, null);
    }

    private static void nFence(long l) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nFence(J)V", true, null);
    }

    private static void nStopDrawing(long l) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nStopDrawing(J)V", true, null);
    }

    private static void nNotifyFramePending(long l) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nNotifyFramePending(J)V", true, null);
    }

    private static void nDumpProfileInfo(long l, FileDescriptor fileDescriptor, int n) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nDumpProfileInfo(JLjava/io/FileDescriptor;I)V", true, null);
    }

    private static void nAddRenderNode(long l, long l2, boolean bl) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nAddRenderNode(JJZ)V", true, null);
    }

    private static void nRemoveRenderNode(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nRemoveRenderNode(JJ)V", true, null);
    }

    private static void nDrawRenderNode(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nDrawRenderNode(JJ)V", true, null);
    }

    private static void nSetContentDrawBounds(long l, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetContentDrawBounds(JIIII)V", true, null);
    }

    private static void nSetPictureCaptureCallback(long l, PictureCapturedCallback pictureCapturedCallback) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetPictureCaptureCallback(JLandroid/graphics/HardwareRenderer$PictureCapturedCallback;)V", true, null);
    }

    private static void nSetFrameCallback(long l, FrameDrawingCallback frameDrawingCallback) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetFrameCallback(JLandroid/graphics/HardwareRenderer$FrameDrawingCallback;)V", true, null);
    }

    private static void nSetFrameCompleteCallback(long l, FrameCompleteCallback frameCompleteCallback) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetFrameCompleteCallback(JLandroid/graphics/HardwareRenderer$FrameCompleteCallback;)V", true, null);
    }

    private static void nAddObserver(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nAddObserver(JJ)V", true, null);
    }

    private static void nRemoveObserver(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nRemoveObserver(JJ)V", true, null);
    }

    private static int nCopySurfaceInto(Surface surface, int n, int n2, int n3, int n4, long l) {
        return OverrideMethod.invokeI("android.graphics.HardwareRenderer#nCopySurfaceInto(Landroid/view/Surface;IIIIJ)I", true, null);
    }

    private static Bitmap nCreateHardwareBitmap(long l, int n, int n2) {
        return (Bitmap)OverrideMethod.invokeA("android.graphics.HardwareRenderer#nCreateHardwareBitmap(JII)Landroid/graphics/Bitmap;", true, null);
    }

    private static void nSetHighContrastText(boolean bl) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetHighContrastText(Z)V", true, null);
    }

    private static void nHackySetRTAnimationsEnabled(boolean bl) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nHackySetRTAnimationsEnabled(Z)V", true, null);
    }

    private static void nSetDebuggingEnabled(boolean bl) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetDebuggingEnabled(Z)V", true, null);
    }

    private static void nSetIsolatedProcess(boolean bl) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetIsolatedProcess(Z)V", true, null);
    }

    private static void nSetContextPriority(int n) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetContextPriority(I)V", true, null);
    }

    private static void nAllocateBuffers(long l) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nAllocateBuffers(J)V", true, null);
    }

    private static void nSetForceDark(long l, boolean bl) {
        OverrideMethod.invokeV("android.graphics.HardwareRenderer#nSetForceDark(JZ)V", true, null);
    }

    private static class ProcessInitializer {
        static ProcessInitializer sInstance = new ProcessInitializer();
        private boolean mInitialized = false;
        private String mPackageName;
        private IGraphicsStats mGraphicsStatsService;
        private IGraphicsStatsCallback mGraphicsStatsCallback = new IGraphicsStatsCallback.Stub(){

            @Override
            public void onRotateGraphicsStatsBuffer() throws RemoteException {
                this.rotateBuffer();
            }
        };

        private ProcessInitializer() {
        }

        synchronized void setPackageName(String name) {
            if (this.mInitialized) {
                return;
            }
            this.mPackageName = name;
        }

        synchronized void init(long renderProxy) {
            if (this.mInitialized) {
                return;
            }
            this.mInitialized = true;
            this.initSched(renderProxy);
            this.initGraphicsStats();
        }

        private void initSched(long renderProxy) {
            try {
                int tid = HardwareRenderer.nGetRenderThreadTid(renderProxy);
                ActivityManager.getService().setRenderThread(tid);
            }
            catch (Throwable t) {
                Log.w(HardwareRenderer.LOG_TAG, "Failed to set scheduler for RenderThread", t);
            }
        }

        private void initGraphicsStats() {
            if (this.mPackageName == null) {
                return;
            }
            try {
                IBinder binder = ServiceManager.getService("graphicsstats");
                if (binder == null) {
                    return;
                }
                this.mGraphicsStatsService = IGraphicsStats.Stub.asInterface(binder);
                this.requestBuffer();
            }
            catch (Throwable t) {
                Log.w(HardwareRenderer.LOG_TAG, "Could not acquire gfx stats buffer", t);
            }
        }

        private void rotateBuffer() {
            HardwareRenderer.nRotateProcessStatsBuffer();
            this.requestBuffer();
        }

        private void requestBuffer() {
            try {
                ParcelFileDescriptor pfd = this.mGraphicsStatsService.requestBufferForProcess(this.mPackageName, this.mGraphicsStatsCallback);
                HardwareRenderer.nSetProcessStatsBuffer(pfd.getFd());
                pfd.close();
            }
            catch (Throwable t) {
                Log.w(HardwareRenderer.LOG_TAG, "Could not acquire gfx stats buffer", t);
            }
        }
    }

    private static class DestroyContextRunnable
    implements Runnable {
        private final long mNativeInstance;

        DestroyContextRunnable(long nativeInstance) {
            this.mNativeInstance = nativeInstance;
        }

        @Override
        public void run() {
            HardwareRenderer.nDeleteProxy(this.mNativeInstance);
        }
    }

    public static interface PictureCapturedCallback {
        public void onPictureCaptured(Picture var1);
    }

    public static interface FrameCompleteCallback {
        public void onFrameComplete(long var1);
    }

    public static interface FrameDrawingCallback {
        public void onFrameDraw(long var1);
    }

    public class FrameRenderRequest {
        private FrameInfo mFrameInfo = new FrameInfo();
        private boolean mWaitForPresent;

        private FrameRenderRequest() {
        }

        private void reset() {
            this.mWaitForPresent = false;
            HardwareRenderer.this.mRenderRequest.setVsyncTime(AnimationUtils.currentAnimationTimeMillis() * 1000000L);
        }

        public void setFrameInfo(FrameInfo info) {
            System.arraycopy(info.frameInfo, 0, this.mFrameInfo.frameInfo, 0, info.frameInfo.length);
        }

        public FrameRenderRequest setVsyncTime(long vsyncTime) {
            this.mFrameInfo.setVsync(vsyncTime, vsyncTime);
            this.mFrameInfo.addFlags(4L);
            return this;
        }

        public FrameRenderRequest setFrameCommitCallback(Executor executor, Runnable frameCommitCallback) {
            HardwareRenderer.this.setFrameCompleteCallback(frameNr -> executor.execute(frameCommitCallback));
            return this;
        }

        public FrameRenderRequest setWaitForPresent(boolean shouldWait) {
            this.mWaitForPresent = shouldWait;
            return this;
        }

        public int syncAndDraw() {
            int syncResult = HardwareRenderer.this.syncAndDrawFrame(this.mFrameInfo);
            if (this.mWaitForPresent && (syncResult & 8) == 0) {
                HardwareRenderer.this.fence();
            }
            return syncResult;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DumpFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SyncAndDrawResult {
    }
}

