/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.Paint_Delegate;
import android.hardware.HardwareBuffer;
import android.os.Parcel;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import javax.imageio.ImageIO;
import libcore.util.NativeAllocationRegistry_Delegate;

public final class Bitmap_Delegate {
    private static final DelegateManager<Bitmap_Delegate> sManager = new DelegateManager<Bitmap_Delegate>(Bitmap_Delegate.class);
    private static long sFinalizer = -1L;
    private final Bitmap.Config mConfig;
    private final BufferedImage mImage;
    private boolean mHasAlpha = true;
    private boolean mHasMipMap = false;
    private boolean mIsPremultiplied = true;
    private int mGenerationId = 0;
    private boolean mIsMutable;

    public static Bitmap_Delegate getDelegate(long native_bitmap) {
        return sManager.getDelegate(native_bitmap);
    }

    public static Bitmap createBitmap(InputStream input, boolean isMutable, Density density) throws IOException {
        return Bitmap_Delegate.createBitmap(input, Bitmap_Delegate.getPremultipliedBitmapCreateFlags(isMutable), density);
    }

    static Bitmap createBitmap(InputStream input, Set<BitmapCreateFlags> createFlags, Density density) throws IOException {
        BridgeContext currentContext;
        BufferedImage image;
        BufferedImage bufferedImage = image = input == null ? null : ImageIO.read(input);
        if (image == null && (currentContext = RenderAction.getCurrentContext()) != null) {
            RenderResources resources = currentContext.getRenderResources();
            ResourceValue broken = resources.getResolvedResource(BridgeContext.createFrameworkResourceReference(ResourceType.DRAWABLE, "ic_menu_report_image"));
            AssetRepository assetRepository = currentContext.getAssets().getAssetRepository();
            try (InputStream stream = assetRepository.openNonAsset(0, broken.getValue(), 2);){
                if (stream != null) {
                    image = ImageIO.read(stream);
                }
            }
        }
        Bitmap_Delegate delegate = new Bitmap_Delegate(image, Bitmap.Config.ARGB_8888);
        delegate.mIsMutable = createFlags.contains((Object)BitmapCreateFlags.MUTABLE);
        return Bitmap_Delegate.createBitmap(delegate, createFlags, density.getDpiValue());
    }

    public static Bitmap createBitmap(BufferedImage image, boolean isMutable, Density density) {
        return Bitmap_Delegate.createBitmap(image, Bitmap_Delegate.getPremultipliedBitmapCreateFlags(isMutable), density);
    }

    public static Bitmap createBitmap(BufferedImage image, Set<BitmapCreateFlags> createFlags, Density density) {
        Bitmap_Delegate delegate = new Bitmap_Delegate(image, Bitmap.Config.ARGB_8888);
        delegate.mIsMutable = createFlags.contains((Object)BitmapCreateFlags.MUTABLE);
        return Bitmap_Delegate.createBitmap(delegate, createFlags, density.getDpiValue());
    }

    private static int getBufferedImageType() {
        return 2;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public Bitmap.Config getConfig() {
        return this.mConfig;
    }

    public boolean hasAlpha() {
        return this.mHasAlpha && this.mConfig != Bitmap.Config.RGB_565;
    }

    public void change() {
        ++this.mGenerationId;
    }

    @LayoutlibDelegate
    static Bitmap nativeCreate(int[] colors, int offset, int stride, int width, int height, int nativeConfig, boolean isMutable, long nativeColorSpace) {
        int imageType = Bitmap_Delegate.getBufferedImageType();
        BufferedImage image = new BufferedImage(width, height, imageType);
        if (colors != null) {
            image.setRGB(0, 0, width, height, colors, offset, stride);
        }
        Bitmap_Delegate delegate = new Bitmap_Delegate(image, Bitmap.Config.nativeToConfig(nativeConfig));
        delegate.mIsMutable = isMutable;
        return Bitmap_Delegate.createBitmap(delegate, Bitmap_Delegate.getPremultipliedBitmapCreateFlags(isMutable), Bitmap.getDefaultDensity());
    }

    @LayoutlibDelegate
    static Bitmap nativeCopy(long srcBitmap, int nativeConfig, boolean isMutable) {
        Bitmap_Delegate srcBmpDelegate = sManager.getDelegate(srcBitmap);
        if (srcBmpDelegate == null) {
            return null;
        }
        BufferedImage srcImage = srcBmpDelegate.getImage();
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        int imageType = Bitmap_Delegate.getBufferedImageType();
        BufferedImage image = new BufferedImage(width, height, imageType);
        int[] argb = new int[width * height];
        srcImage.getRGB(0, 0, width, height, argb, 0, width);
        image.setRGB(0, 0, width, height, argb, 0, width);
        Bitmap_Delegate delegate = new Bitmap_Delegate(image, Bitmap.Config.nativeToConfig(nativeConfig));
        delegate.mIsMutable = isMutable;
        return Bitmap_Delegate.createBitmap(delegate, Bitmap_Delegate.getPremultipliedBitmapCreateFlags(isMutable), Bitmap.getDefaultDensity());
    }

    @LayoutlibDelegate
    static Bitmap nativeCopyAshmem(long nativeSrcBitmap) {
        assert (false);
        return null;
    }

    @LayoutlibDelegate
    static Bitmap nativeCopyAshmemConfig(long nativeSrcBitmap, int nativeConfig) {
        assert (false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nativeGetNativeFinalizer() {
        Class<Bitmap_Delegate> clazz = Bitmap_Delegate.class;
        synchronized (Bitmap_Delegate.class) {
            if (sFinalizer == -1L) {
                sFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFinalizer;
        }
    }

    @LayoutlibDelegate
    static void nativeRecycle(long nativeBitmap) {
    }

    @LayoutlibDelegate
    static void nativeReconfigure(long nativeBitmap, int width, int height, int config, boolean isPremultiplied) {
        Bridge.getLog().error("unsupported", "Bitmap.reconfigure() is not supported", null, null);
    }

    @LayoutlibDelegate
    static boolean nativeCompress(long nativeBitmap, int format, int quality, OutputStream stream, byte[] tempStorage) {
        Bridge.getLog().error("unsupported", "Bitmap.compress() is not supported", null, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static void nativeErase(long nativeBitmap, int color2) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        if (delegate == null) {
            return;
        }
        BufferedImage image = delegate.mImage;
        Graphics2D g = image.createGraphics();
        try {
            g.setColor(new java.awt.Color(color2, true));
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        finally {
            g.dispose();
        }
    }

    @LayoutlibDelegate
    static void nativeErase(long nativeBitmap, long colorSpacePtr, long color2) {
        Bitmap_Delegate.nativeErase(nativeBitmap, Color.toArgb(color2));
    }

    @LayoutlibDelegate
    static int nativeRowBytes(long nativeBitmap) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        if (delegate == null) {
            return 0;
        }
        return delegate.mImage.getWidth();
    }

    @LayoutlibDelegate
    static int nativeConfig(long nativeBitmap) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        if (delegate == null) {
            return 0;
        }
        return delegate.mConfig.nativeInt;
    }

    @LayoutlibDelegate
    static boolean nativeHasAlpha(long nativeBitmap) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        return delegate == null || delegate.mHasAlpha;
    }

    @LayoutlibDelegate
    static boolean nativeHasMipMap(long nativeBitmap) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        return delegate == null || delegate.mHasMipMap;
    }

    @LayoutlibDelegate
    static int nativeGetPixel(long nativeBitmap, int x, int y) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        if (delegate == null) {
            return 0;
        }
        return delegate.mImage.getRGB(x, y);
    }

    @LayoutlibDelegate
    static long nativeGetColor(long nativeBitmap, int x, int y) {
        return Bitmap_Delegate.nativeGetPixel(nativeBitmap, x, y);
    }

    @LayoutlibDelegate
    static void nativeGetPixels(long nativeBitmap, int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        if (delegate == null) {
            return;
        }
        delegate.getImage().getRGB(x, y, width, height, pixels, offset, stride);
    }

    @LayoutlibDelegate
    static void nativeSetPixel(long nativeBitmap, int x, int y, int color2) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        if (delegate == null) {
            return;
        }
        delegate.getImage().setRGB(x, y, color2);
    }

    @LayoutlibDelegate
    static void nativeSetPixels(long nativeBitmap, int[] colors, int offset, int stride, int x, int y, int width, int height) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        if (delegate == null) {
            return;
        }
        delegate.getImage().setRGB(x, y, width, height, colors, offset, stride);
    }

    @LayoutlibDelegate
    static void nativeCopyPixelsToBuffer(long nativeBitmap, Buffer dst) {
        Bridge.getLog().fidelityWarning("unsupported", "Bitmap.copyPixelsToBuffer is not supported.", null, null, null);
    }

    @LayoutlibDelegate
    static void nativeCopyPixelsFromBuffer(long nb, Buffer src) {
        Bridge.getLog().fidelityWarning("unsupported", "Bitmap.copyPixelsFromBuffer is not supported.", null, null, null);
    }

    @LayoutlibDelegate
    static int nativeGenerationId(long nativeBitmap) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        if (delegate == null) {
            return 0;
        }
        return delegate.mGenerationId;
    }

    @LayoutlibDelegate
    static Bitmap nativeCreateFromParcel(Parcel p) {
        Bridge.getLog().error("unsupported", "AIDL is not suppored, and therefore Bitmaps cannot be created from parcels.", null, null);
        return null;
    }

    @LayoutlibDelegate
    static boolean nativeWriteToParcel(long nativeBitmap, int density, Parcel p) {
        Bridge.getLog().error("unsupported", "AIDL is not suppored, and therefore Bitmaps cannot be written to parcels.", null, null);
        return false;
    }

    @LayoutlibDelegate
    static Bitmap nativeExtractAlpha(long nativeBitmap, long nativePaint, int[] offsetXY) {
        Bitmap_Delegate bitmap = sManager.getDelegate(nativeBitmap);
        if (bitmap == null) {
            return null;
        }
        Paint_Delegate paint = Paint_Delegate.getDelegate(nativePaint);
        if (paint != null && paint.getMaskFilter() != null) {
            Bridge.getLog().fidelityWarning("maskfilter", "MaskFilter not supported in Bitmap.extractAlpha", null, null, null);
        }
        int alpha = paint != null ? paint.getAlpha() : 255;
        BufferedImage image = Bitmap_Delegate.createCopy(bitmap.getImage(), 2, alpha);
        Bitmap_Delegate delegate = new Bitmap_Delegate(image, Bitmap.Config.ALPHA_8);
        delegate.mIsMutable = true;
        return Bitmap_Delegate.createBitmap(delegate, EnumSet.of(BitmapCreateFlags.MUTABLE), Density.DEFAULT_DENSITY);
    }

    @LayoutlibDelegate
    static boolean nativeIsPremultiplied(long nativeBitmap) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        return delegate != null && delegate.mIsPremultiplied;
    }

    @LayoutlibDelegate
    static void nativeSetPremultiplied(long nativeBitmap, boolean isPremul) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        if (delegate == null) {
            return;
        }
        delegate.mIsPremultiplied = isPremul;
    }

    @LayoutlibDelegate
    static void nativeSetHasAlpha(long nativeBitmap, boolean hasAlpha, boolean isPremul) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        if (delegate == null) {
            return;
        }
        delegate.mHasAlpha = hasAlpha;
    }

    @LayoutlibDelegate
    static void nativeSetHasMipMap(long nativeBitmap, boolean hasMipMap) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        if (delegate == null) {
            return;
        }
        delegate.mHasMipMap = hasMipMap;
    }

    @LayoutlibDelegate
    static boolean nativeSameAs(long nb0, long nb1) {
        Bitmap_Delegate delegate1 = sManager.getDelegate(nb0);
        if (delegate1 == null) {
            return false;
        }
        Bitmap_Delegate delegate2 = sManager.getDelegate(nb1);
        if (delegate2 == null) {
            return false;
        }
        BufferedImage image1 = delegate1.getImage();
        BufferedImage image2 = delegate2.getImage();
        if (delegate1.mConfig != delegate2.mConfig || image1.getWidth() != image2.getWidth() || image1.getHeight() != image2.getHeight()) {
            return false;
        }
        int w = image1.getWidth();
        int h = image2.getHeight();
        int[] argb1 = new int[w * h];
        int[] argb2 = new int[w * h];
        image1.getRGB(0, 0, w, h, argb1, 0, w);
        image2.getRGB(0, 0, w, h, argb2, 0, w);
        if (delegate1.mConfig == Bitmap.Config.ALPHA_8) {
            int length = w * h;
            for (int i = 0; i < length; ++i) {
                if ((argb1[i] & 0xFF000000) == (argb2[i] & 0xFF000000)) continue;
                return false;
            }
            return true;
        }
        return Arrays.equals(argb1, argb2);
    }

    @LayoutlibDelegate
    static int nativeGetAllocationByteCount(long nativeBitmap) {
        Bitmap_Delegate delegate = sManager.getDelegate(nativeBitmap);
        if (delegate == null) {
            return 0;
        }
        int size = Bitmap_Delegate.nativeRowBytes(nativeBitmap) * delegate.mImage.getHeight();
        return size < 0 ? Integer.MAX_VALUE : size;
    }

    @LayoutlibDelegate
    static void nativePrepareToDraw(long nativeBitmap) {
    }

    @LayoutlibDelegate
    static Bitmap nativeCopyPreserveInternalConfig(long nativeBitmap) {
        Bitmap_Delegate srcBmpDelegate = sManager.getDelegate(nativeBitmap);
        if (srcBmpDelegate == null) {
            return null;
        }
        BufferedImage srcImage = srcBmpDelegate.getImage();
        BufferedImage image = new BufferedImage(srcImage.getColorModel(), srcImage.copyData(null), srcImage.isAlphaPremultiplied(), null);
        Bitmap_Delegate delegate = new Bitmap_Delegate(image, srcBmpDelegate.getConfig());
        delegate.mIsMutable = srcBmpDelegate.mIsMutable;
        return Bitmap_Delegate.createBitmap(delegate, EnumSet.of(BitmapCreateFlags.NONE), Bitmap.getDefaultDensity());
    }

    @LayoutlibDelegate
    static Bitmap nativeWrapHardwareBufferBitmap(HardwareBuffer buffer, long nativeColorSpace) {
        Bridge.getLog().error("unsupported", "Bitmap.nativeWrapHardwareBufferBitmap() is not supported", null, null, null);
        return null;
    }

    @LayoutlibDelegate
    static boolean nativeIsSRGB(long nativeBitmap) {
        Bridge.getLog().error("unsupported", "Color spaces are not supported", null, null);
        return false;
    }

    @LayoutlibDelegate
    static ColorSpace nativeComputeColorSpace(long nativePtr) {
        Bridge.getLog().error("unsupported", "Color spaces are not supported", null, null);
        return null;
    }

    @LayoutlibDelegate
    static void nativeSetColorSpace(long nativePtr, long nativeColorSpace) {
        Bridge.getLog().error("unsupported", "Color spaces are not supported", null, null);
    }

    @LayoutlibDelegate
    static boolean nativeIsSRGBLinear(long nativePtr) {
        Bridge.getLog().error("unsupported", "Color spaces are not supported", null, null);
        return false;
    }

    @LayoutlibDelegate
    static void nativeSetImmutable(long nativePtr) {
        Bitmap_Delegate bmpDelegate = sManager.getDelegate(nativePtr);
        if (bmpDelegate == null) {
            return;
        }
        bmpDelegate.mIsMutable = false;
    }

    @LayoutlibDelegate
    static boolean nativeIsImmutable(long nativePtr) {
        Bitmap_Delegate bmpDelegate = sManager.getDelegate(nativePtr);
        if (bmpDelegate == null) {
            return false;
        }
        return !bmpDelegate.mIsMutable;
    }

    @LayoutlibDelegate
    static HardwareBuffer nativeGetHardwareBuffer(long nativeBitmap) {
        Bridge.getLog().error("unsupported", "HardwareBuffer is not supported", null, null);
        return null;
    }

    private Bitmap_Delegate(BufferedImage image, Bitmap.Config config) {
        this.mImage = image;
        this.mConfig = config;
    }

    private static Bitmap createBitmap(Bitmap_Delegate delegate, Set<BitmapCreateFlags> createFlags, int density) {
        long nativeInt = sManager.addNewDelegate(delegate);
        int width = delegate.mImage.getWidth();
        int height = delegate.mImage.getHeight();
        boolean isPremultiplied = createFlags.contains((Object)BitmapCreateFlags.PREMULTIPLIED);
        return new Bitmap(nativeInt, width, height, density, isPremultiplied, null, null, true);
    }

    private static Set<BitmapCreateFlags> getPremultipliedBitmapCreateFlags(boolean isMutable) {
        EnumSet<BitmapCreateFlags> createFlags = EnumSet.of(BitmapCreateFlags.PREMULTIPLIED);
        if (isMutable) {
            createFlags.add(BitmapCreateFlags.MUTABLE);
        }
        return createFlags;
    }

    static BufferedImage createCopy(BufferedImage image, int imageType, int alpha) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage result = new BufferedImage(w, h, imageType);
        int[] argb = new int[w * h];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), argb, 0, image.getWidth());
        if (alpha != 255) {
            int length = argb.length;
            for (int i = 0; i < length; ++i) {
                int a = (argb[i] >>> 24 * alpha) / 255;
                argb[i] = a << 24 | argb[i] & 0xFFFFFF;
            }
        }
        result.setRGB(0, 0, w, h, argb, 0, w);
        return result;
    }

    public static enum BitmapCreateFlags {
        NONE,
        PREMULTIPLIED,
        MUTABLE;

    }
}

