/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.ddm.DdmHandleAppName;
import android.os.Debug;
import android.os.Process;
import android.os.UserHandle;
import dalvik.system.VMRuntime;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleHello
extends ChunkHandler {
    public static final int CHUNK_HELO = DdmHandleHello.type("HELO");
    public static final int CHUNK_WAIT = DdmHandleHello.type("WAIT");
    public static final int CHUNK_FEAT = DdmHandleHello.type("FEAT");
    private static final int CLIENT_PROTOCOL_VERSION = 1;
    private static DdmHandleHello mInstance = new DdmHandleHello();
    private static final String[] FRAMEWORK_FEATURES = new String[]{"opengl-tracing", "view-hierarchy"};

    private DdmHandleHello() {
    }

    public static void register() {
        DdmServer.registerHandler(CHUNK_HELO, mInstance);
        DdmServer.registerHandler(CHUNK_FEAT, mInstance);
    }

    @Override
    public void connected() {
    }

    @Override
    public void disconnected() {
    }

    @Override
    public Chunk handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_HELO) {
            return this.handleHELO(request);
        }
        if (type == CHUNK_FEAT) {
            return this.handleFEAT(request);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name(type));
    }

    private Chunk handleHELO(Chunk request) {
        ByteBuffer in = DdmHandleHello.wrapChunk(request);
        int serverProtoVers = in.getInt();
        String vmName = System.getProperty("java.vm.name", "?");
        String vmVersion = System.getProperty("java.vm.version", "?");
        String vmIdent = vmName + " v" + vmVersion;
        DdmHandleAppName.Names names = DdmHandleAppName.getNames();
        String appName = names.getAppName();
        String pkgName = names.getPkgName();
        VMRuntime vmRuntime = VMRuntime.getRuntime();
        String instructionSetDescription = vmRuntime.is64Bit() ? "64-bit" : "32-bit";
        String vmInstructionSet = vmRuntime.vmInstructionSet();
        if (vmInstructionSet != null && vmInstructionSet.length() > 0) {
            instructionSetDescription = instructionSetDescription + " (" + vmInstructionSet + ")";
        }
        String vmFlags = "CheckJNI=" + (vmRuntime.isCheckJniEnabled() ? "true" : "false");
        boolean isNativeDebuggable = vmRuntime.isNativeDebuggable();
        ByteBuffer out = ByteBuffer.allocate(32 + vmIdent.length() * 2 + appName.length() * 2 + instructionSetDescription.length() * 2 + vmFlags.length() * 2 + 1 + pkgName.length() * 2);
        out.order(ChunkHandler.CHUNK_ORDER);
        out.putInt(1);
        out.putInt(Process.myPid());
        out.putInt(vmIdent.length());
        out.putInt(appName.length());
        DdmHandleHello.putString(out, vmIdent);
        DdmHandleHello.putString(out, appName);
        out.putInt(UserHandle.myUserId());
        out.putInt(instructionSetDescription.length());
        DdmHandleHello.putString(out, instructionSetDescription);
        out.putInt(vmFlags.length());
        DdmHandleHello.putString(out, vmFlags);
        out.put((byte)(isNativeDebuggable ? 1 : 0));
        out.putInt(pkgName.length());
        DdmHandleHello.putString(out, pkgName);
        Chunk reply = new Chunk(CHUNK_HELO, out);
        if (Debug.waitingForDebugger()) {
            DdmHandleHello.sendWAIT(0);
        }
        return reply;
    }

    private Chunk handleFEAT(Chunk request) {
        int i;
        int i2;
        String[] vmFeatures = Debug.getVmFeatureList();
        int size = 4 + 4 * (vmFeatures.length + FRAMEWORK_FEATURES.length);
        for (i2 = vmFeatures.length - 1; i2 >= 0; --i2) {
            size += vmFeatures[i2].length() * 2;
        }
        for (i2 = FRAMEWORK_FEATURES.length - 1; i2 >= 0; --i2) {
            size += FRAMEWORK_FEATURES[i2].length() * 2;
        }
        ByteBuffer out = ByteBuffer.allocate(size);
        out.order(ChunkHandler.CHUNK_ORDER);
        out.putInt(vmFeatures.length + FRAMEWORK_FEATURES.length);
        for (i = vmFeatures.length - 1; i >= 0; --i) {
            out.putInt(vmFeatures[i].length());
            DdmHandleHello.putString(out, vmFeatures[i]);
        }
        for (i = FRAMEWORK_FEATURES.length - 1; i >= 0; --i) {
            out.putInt(FRAMEWORK_FEATURES[i].length());
            DdmHandleHello.putString(out, FRAMEWORK_FEATURES[i]);
        }
        return new Chunk(CHUNK_FEAT, out);
    }

    public static void sendWAIT(int reason) {
        byte[] data = new byte[]{(byte)reason};
        Chunk waitChunk = new Chunk(CHUNK_WAIT, data, 0, 1);
        DdmServer.sendChunk(waitChunk);
    }
}

