/*
 * Decompiled with CFR 0.152.
 */
package android.content.integrity;

import android.annotation.SystemApi;
import android.content.integrity.IntegrityFormula;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@VisibleForTesting
public class Rule
implements Parcelable {
    public static final int DENY = 0;
    public static final int FORCE_ALLOW = 1;
    private final IntegrityFormula mFormula;
    private final int mEffect;
    public static final Parcelable.Creator<Rule> CREATOR = new Parcelable.Creator<Rule>(){

        @Override
        public Rule createFromParcel(Parcel in) {
            return new Rule(in);
        }

        public Rule[] newArray(int size) {
            return new Rule[size];
        }
    };

    public Rule(IntegrityFormula formula, int effect) {
        Preconditions.checkArgument(Rule.isValidEffect(effect), String.format("Unknown effect: %d", effect));
        this.mFormula = Objects.requireNonNull(formula);
        this.mEffect = effect;
    }

    Rule(Parcel in) {
        this.mFormula = IntegrityFormula.readFromParcel(in);
        this.mEffect = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        IntegrityFormula.writeToParcel(this.mFormula, dest, flags);
        dest.writeInt(this.mEffect);
    }

    public IntegrityFormula getFormula() {
        return this.mFormula;
    }

    public int getEffect() {
        return this.mEffect;
    }

    public String toString() {
        return String.format("Rule: %s, %s", this.mFormula, Rule.effectToString(this.mEffect));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule that = (Rule)o;
        return this.mEffect == that.mEffect && Objects.equals(this.mFormula, that.mFormula);
    }

    public int hashCode() {
        return Objects.hash(this.mFormula, this.mEffect);
    }

    private static String effectToString(int effect) {
        switch (effect) {
            case 0: {
                return "DENY";
            }
            case 1: {
                return "FORCE_ALLOW";
            }
        }
        throw new IllegalArgumentException("Unknown effect " + effect);
    }

    private static boolean isValidEffect(int effect) {
        return effect == 0 || effect == 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Effect {
    }
}

