/*
 * Decompiled with CFR 0.152.
 */
package android.content.integrity;

import com.android.internal.util.Preconditions;

public class IntegrityUtils {
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

    public static byte[] getBytesFromHexDigest(String hexDigest) {
        Preconditions.checkArgument(hexDigest.length() % 2 == 0, "Invalid hex encoding " + hexDigest + ": must have even length");
        byte[] rawBytes = new byte[hexDigest.length() / 2];
        for (int i = 0; i < rawBytes.length; ++i) {
            char upperNibble = hexDigest.charAt(2 * i);
            char lowerNibble = hexDigest.charAt(2 * i + 1);
            rawBytes[i] = (byte)(IntegrityUtils.hexToDec(upperNibble) << 4 | IntegrityUtils.hexToDec(lowerNibble));
        }
        return rawBytes;
    }

    public static String getHexDigest(byte[] rawBytes) {
        char[] hexChars = new char[rawBytes.length * 2];
        for (int i = 0; i < rawBytes.length; ++i) {
            int upperNibble = rawBytes[i] >>> 4 & 0xF;
            int lowerNibble = rawBytes[i] & 0xF;
            hexChars[i * 2] = IntegrityUtils.decToHex(upperNibble);
            hexChars[i * 2 + 1] = IntegrityUtils.decToHex(lowerNibble);
        }
        return new String(hexChars);
    }

    private static int hexToDec(int hexChar) {
        if (hexChar >= 48 && hexChar <= 57) {
            return hexChar - 48;
        }
        if (hexChar >= 97 && hexChar <= 102) {
            return hexChar - 97 + 10;
        }
        if (hexChar >= 65 && hexChar <= 70) {
            return hexChar - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex char " + hexChar);
    }

    private static char decToHex(int dec) {
        if (dec >= 0 && dec < HEX_CHARS.length) {
            return HEX_CHARS[dec];
        }
        throw new IllegalArgumentException("Invalid dec value to be converted to hex digit " + dec);
    }
}

