/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattIncludedService;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BluetoothGattService
implements Parcelable {
    public static final int SERVICE_TYPE_PRIMARY = 0;
    public static final int SERVICE_TYPE_SECONDARY = 1;
    @UnsupportedAppUsage
    protected BluetoothDevice mDevice;
    protected UUID mUuid;
    protected int mInstanceId;
    protected int mHandles = 0;
    protected int mServiceType;
    protected List<BluetoothGattCharacteristic> mCharacteristics;
    protected List<BluetoothGattService> mIncludedServices;
    private boolean mAdvertisePreferred;
    public static final Parcelable.Creator<BluetoothGattService> CREATOR = new Parcelable.Creator<BluetoothGattService>(){

        @Override
        public BluetoothGattService createFromParcel(Parcel in) {
            return new BluetoothGattService(in);
        }

        public BluetoothGattService[] newArray(int size) {
            return new BluetoothGattService[size];
        }
    };

    public BluetoothGattService(UUID uuid, int serviceType) {
        this.mDevice = null;
        this.mUuid = uuid;
        this.mInstanceId = 0;
        this.mServiceType = serviceType;
        this.mCharacteristics = new ArrayList<BluetoothGattCharacteristic>();
        this.mIncludedServices = new ArrayList<BluetoothGattService>();
    }

    BluetoothGattService(BluetoothDevice device, UUID uuid, int instanceId, int serviceType) {
        this.mDevice = device;
        this.mUuid = uuid;
        this.mInstanceId = instanceId;
        this.mServiceType = serviceType;
        this.mCharacteristics = new ArrayList<BluetoothGattCharacteristic>();
        this.mIncludedServices = new ArrayList<BluetoothGattService>();
    }

    public BluetoothGattService(UUID uuid, int instanceId, int serviceType) {
        this.mDevice = null;
        this.mUuid = uuid;
        this.mInstanceId = instanceId;
        this.mServiceType = serviceType;
        this.mCharacteristics = new ArrayList<BluetoothGattCharacteristic>();
        this.mIncludedServices = new ArrayList<BluetoothGattService>();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(new ParcelUuid(this.mUuid), 0);
        out.writeInt(this.mInstanceId);
        out.writeInt(this.mServiceType);
        out.writeTypedList(this.mCharacteristics);
        ArrayList<BluetoothGattIncludedService> includedServices = new ArrayList<BluetoothGattIncludedService>(this.mIncludedServices.size());
        for (BluetoothGattService s : this.mIncludedServices) {
            includedServices.add(new BluetoothGattIncludedService(s.getUuid(), s.getInstanceId(), s.getType()));
        }
        out.writeTypedList(includedServices);
    }

    private BluetoothGattService(Parcel in) {
        this.mUuid = ((ParcelUuid)in.readParcelable(null)).getUuid();
        this.mInstanceId = in.readInt();
        this.mServiceType = in.readInt();
        this.mCharacteristics = new ArrayList<BluetoothGattCharacteristic>();
        ArrayList<BluetoothGattCharacteristic> chrcs = in.createTypedArrayList(BluetoothGattCharacteristic.CREATOR);
        if (chrcs != null) {
            for (BluetoothGattCharacteristic chrc : chrcs) {
                chrc.setService(this);
                this.mCharacteristics.add(chrc);
            }
        }
        this.mIncludedServices = new ArrayList<BluetoothGattService>();
        ArrayList<BluetoothGattIncludedService> inclSvcs = in.createTypedArrayList(BluetoothGattIncludedService.CREATOR);
        if (chrcs != null) {
            for (BluetoothGattIncludedService isvc : inclSvcs) {
                this.mIncludedServices.add(new BluetoothGattService(null, isvc.getUuid(), isvc.getInstanceId(), isvc.getType()));
            }
        }
    }

    BluetoothDevice getDevice() {
        return this.mDevice;
    }

    void setDevice(BluetoothDevice device) {
        this.mDevice = device;
    }

    public boolean addService(BluetoothGattService service) {
        this.mIncludedServices.add(service);
        return true;
    }

    public boolean addCharacteristic(BluetoothGattCharacteristic characteristic) {
        this.mCharacteristics.add(characteristic);
        characteristic.setService(this);
        return true;
    }

    BluetoothGattCharacteristic getCharacteristic(UUID uuid, int instanceId) {
        for (BluetoothGattCharacteristic characteristic : this.mCharacteristics) {
            if (!uuid.equals(characteristic.getUuid()) || characteristic.getInstanceId() != instanceId) continue;
            return characteristic;
        }
        return null;
    }

    @UnsupportedAppUsage
    public void setInstanceId(int instanceId) {
        this.mInstanceId = instanceId;
    }

    int getHandles() {
        return this.mHandles;
    }

    public void setHandles(int handles) {
        this.mHandles = handles;
    }

    public void addIncludedService(BluetoothGattService includedService) {
        this.mIncludedServices.add(includedService);
    }

    public UUID getUuid() {
        return this.mUuid;
    }

    public int getInstanceId() {
        return this.mInstanceId;
    }

    public int getType() {
        return this.mServiceType;
    }

    public List<BluetoothGattService> getIncludedServices() {
        return this.mIncludedServices;
    }

    public List<BluetoothGattCharacteristic> getCharacteristics() {
        return this.mCharacteristics;
    }

    public BluetoothGattCharacteristic getCharacteristic(UUID uuid) {
        for (BluetoothGattCharacteristic characteristic : this.mCharacteristics) {
            if (!uuid.equals(characteristic.getUuid())) continue;
            return characteristic;
        }
        return null;
    }

    public boolean isAdvertisePreferred() {
        return this.mAdvertisePreferred;
    }

    @UnsupportedAppUsage
    public void setAdvertisePreferred(boolean advertisePreferred) {
        this.mAdvertisePreferred = advertisePreferred;
    }
}

