/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.app.IActivityManager;
import android.app.INotificationManager;
import android.app.admin.DevicePolicyManager;
import android.app.admin.PasswordMetrics;
import android.app.trust.ITrustManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.service.persistentdata.IPersistentDataBlockService;
import android.util.Log;
import android.view.IOnKeyguardExitResult;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockPatternView;
import com.android.internal.widget.LockscreenCredential;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public class KeyguardManager {
    private static final String TAG = "KeyguardManager";
    private final Context mContext;
    private final IWindowManager mWM;
    private final IActivityManager mAm;
    private final ITrustManager mTrustManager;
    private final INotificationManager mNotificationManager;
    public static final String ACTION_CONFIRM_DEVICE_CREDENTIAL = "android.app.action.CONFIRM_DEVICE_CREDENTIAL";
    public static final String ACTION_CONFIRM_DEVICE_CREDENTIAL_WITH_USER = "android.app.action.CONFIRM_DEVICE_CREDENTIAL_WITH_USER";
    public static final String ACTION_CONFIRM_FRP_CREDENTIAL = "android.app.action.CONFIRM_FRP_CREDENTIAL";
    public static final String EXTRA_TITLE = "android.app.extra.TITLE";
    public static final String EXTRA_DESCRIPTION = "android.app.extra.DESCRIPTION";
    public static final String EXTRA_ALTERNATE_BUTTON_LABEL = "android.app.extra.ALTERNATE_BUTTON_LABEL";
    public static final int RESULT_ALTERNATE = 1;
    public static final String EXTRA_DISALLOW_BIOMETRICS_IF_POLICY_EXISTS = "check_dpm";

    @Deprecated
    public Intent createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description) {
        if (!this.isDeviceSecure()) {
            return null;
        }
        Intent intent = new Intent(ACTION_CONFIRM_DEVICE_CREDENTIAL);
        intent.putExtra(EXTRA_TITLE, title);
        intent.putExtra(EXTRA_DESCRIPTION, description);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    public Intent createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description, int userId) {
        if (!this.isDeviceSecure(userId)) {
            return null;
        }
        Intent intent = new Intent(ACTION_CONFIRM_DEVICE_CREDENTIAL_WITH_USER);
        intent.putExtra(EXTRA_TITLE, title);
        intent.putExtra(EXTRA_DESCRIPTION, description);
        intent.putExtra("android.intent.extra.USER_ID", userId);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    public Intent createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description, int userId, boolean disallowBiometricsIfPolicyExists) {
        Intent intent = this.createConfirmDeviceCredentialIntent(title, description, userId);
        intent.putExtra(EXTRA_DISALLOW_BIOMETRICS_IF_POLICY_EXISTS, disallowBiometricsIfPolicyExists);
        return intent;
    }

    @SystemApi
    public Intent createConfirmFactoryResetCredentialIntent(CharSequence title, CharSequence description, CharSequence alternateButtonLabel) {
        if (!LockPatternUtils.frpCredentialEnabled(this.mContext)) {
            Log.w(TAG, "Factory reset credentials not supported.");
            throw new UnsupportedOperationException("not supported on this device");
        }
        if (Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0) != 0) {
            Log.e(TAG, "Factory reset credential cannot be verified after provisioning.");
            throw new IllegalStateException("must not be provisioned yet");
        }
        try {
            IPersistentDataBlockService pdb = IPersistentDataBlockService.Stub.asInterface(ServiceManager.getService("persistent_data_block"));
            if (pdb == null) {
                Log.e(TAG, "No persistent data block service");
                throw new UnsupportedOperationException("not supported on this device");
            }
            if (!pdb.hasFrpCredentialHandle()) {
                Log.i(TAG, "The persistent data block does not have a factory reset credential.");
                return null;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        Intent intent = new Intent(ACTION_CONFIRM_FRP_CREDENTIAL);
        intent.putExtra(EXTRA_TITLE, title);
        intent.putExtra(EXTRA_DESCRIPTION, description);
        intent.putExtra(EXTRA_ALTERNATE_BUTTON_LABEL, alternateButtonLabel);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    @SystemApi
    public void setPrivateNotificationsAllowed(boolean allow) {
        try {
            this.mNotificationManager.setPrivateNotificationsAllowed(allow);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean getPrivateNotificationsAllowed() {
        try {
            return this.mNotificationManager.getPrivateNotificationsAllowed();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private String getSettingsPackageForIntent(Intent intent) {
        int i = 0;
        List<ResolveInfo> resolveInfos = this.mContext.getPackageManager().queryIntentActivities(intent, 0x100000);
        if (i < resolveInfos.size()) {
            return resolveInfos.get((int)i).activityInfo.packageName;
        }
        return "com.android.settings";
    }

    KeyguardManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mWM = WindowManagerGlobal.getWindowManagerService();
        this.mAm = ActivityManager.getService();
        this.mTrustManager = ITrustManager.Stub.asInterface(ServiceManager.getServiceOrThrow("trust"));
        this.mNotificationManager = INotificationManager.Stub.asInterface(ServiceManager.getServiceOrThrow("notification"));
    }

    @Deprecated
    public KeyguardLock newKeyguardLock(String tag) {
        return new KeyguardLock(tag);
    }

    public boolean isKeyguardLocked() {
        try {
            return this.mWM.isKeyguardLocked();
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean isKeyguardSecure() {
        try {
            return this.mWM.isKeyguardSecure(this.mContext.getUserId());
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean inKeyguardRestrictedInputMode() {
        return this.isKeyguardLocked();
    }

    public boolean isDeviceLocked() {
        return this.isDeviceLocked(this.mContext.getUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public boolean isDeviceLocked(int userId) {
        try {
            return this.mTrustManager.isDeviceLocked(userId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean isDeviceSecure() {
        return this.isDeviceSecure(this.mContext.getUserId());
    }

    @UnsupportedAppUsage
    public boolean isDeviceSecure(int userId) {
        try {
            return this.mTrustManager.isDeviceSecure(userId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void requestDismissKeyguard(Activity activity, KeyguardDismissCallback callback) {
        this.requestDismissKeyguard(activity, null, callback);
    }

    @SystemApi
    public void requestDismissKeyguard(final Activity activity, CharSequence message, final KeyguardDismissCallback callback) {
        try {
            ActivityTaskManager.getService().dismissKeyguard(activity.getActivityToken(), new IKeyguardDismissCallback.Stub(){

                @Override
                public void onDismissError() throws RemoteException {
                    if (callback != null && !activity.isDestroyed()) {
                        activity.mHandler.post(callback::onDismissError);
                    }
                }

                @Override
                public void onDismissSucceeded() throws RemoteException {
                    if (callback != null && !activity.isDestroyed()) {
                        activity.mHandler.post(callback::onDismissSucceeded);
                    }
                }

                @Override
                public void onDismissCancelled() throws RemoteException {
                    if (callback != null && !activity.isDestroyed()) {
                        activity.mHandler.post(callback::onDismissCancelled);
                    }
                }
            }, message);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void exitKeyguardSecurely(final OnKeyguardExitResult callback) {
        try {
            this.mWM.exitKeyguardSecurely(new IOnKeyguardExitResult.Stub(){

                @Override
                public void onKeyguardExitResult(boolean success) throws RemoteException {
                    if (callback != null) {
                        callback.onKeyguardExitResult(success);
                    }
                }
            });
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private boolean checkInitialLockMethodUsage() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_INITIAL_LOCK") != 0) {
            throw new SecurityException("Requires SET_INITIAL_LOCK permission.");
        }
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.automotive");
    }

    @SystemApi
    public boolean isValidLockPasswordComplexity(@LockTypes int lockType, byte[] password, int complexity) {
        if (!this.checkInitialLockMethodUsage()) {
            return false;
        }
        complexity = PasswordMetrics.sanitizeComplexityLevel(complexity);
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        PasswordMetrics adminMetrics = devicePolicyManager.getPasswordMinimumMetrics(this.mContext.getUserId());
        boolean isPinOrPattern = lockType != 0;
        return PasswordMetrics.validatePassword(adminMetrics, complexity, isPinOrPattern, password).size() == 0;
    }

    @SystemApi
    public int getMinLockLength(boolean isPin, int complexity) {
        if (!this.checkInitialLockMethodUsage()) {
            return -1;
        }
        complexity = PasswordMetrics.sanitizeComplexityLevel(complexity);
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        PasswordMetrics adminMetrics = devicePolicyManager.getPasswordMinimumMetrics(this.mContext.getUserId());
        PasswordMetrics minMetrics = PasswordMetrics.applyComplexity(adminMetrics, isPin, complexity);
        return minMetrics.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SystemApi
    public boolean setLock(@LockTypes int lockType, byte[] password, int complexity) {
        if (!this.checkInitialLockMethodUsage()) {
            return false;
        }
        LockPatternUtils lockPatternUtils = new LockPatternUtils(this.mContext);
        int userId = this.mContext.getUserId();
        if (this.isDeviceSecure(userId)) {
            Log.e(TAG, "Password already set, rejecting call to setLock");
            return false;
        }
        if (!this.isValidLockPasswordComplexity(lockType, password, complexity)) {
            Log.e(TAG, "Password is not valid, rejecting call to setLock");
            return false;
        }
        boolean success = false;
        try {
            switch (lockType) {
                case 0: {
                    String passwordStr = new String(password, Charset.forName("UTF-8"));
                    lockPatternUtils.setLockCredential(LockscreenCredential.createPassword(passwordStr), LockscreenCredential.createNone(), userId);
                    success = true;
                    return success;
                }
                case 1: {
                    String pinStr = new String(password);
                    lockPatternUtils.setLockCredential(LockscreenCredential.createPin(pinStr), LockscreenCredential.createNone(), userId);
                    success = true;
                    return success;
                }
                case 2: {
                    List<LockPatternView.Cell> pattern = LockPatternUtils.byteArrayToPattern(password);
                    lockPatternUtils.setLockCredential(LockscreenCredential.createPattern(pattern), LockscreenCredential.createNone(), userId);
                    pattern.clear();
                    success = true;
                    return success;
                }
                default: {
                    Log.e(TAG, "Unknown lock type, returning a failure");
                    return success;
                }
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Save lock exception", e);
            success = false;
            return success;
        }
        finally {
            Arrays.fill(password, (byte)0);
        }
    }

    static @interface LockTypes {
        public static final int PASSWORD = 0;
        public static final int PIN = 1;
        public static final int PATTERN = 2;
    }

    public static abstract class KeyguardDismissCallback {
        public void onDismissError() {
        }

        public void onDismissSucceeded() {
        }

        public void onDismissCancelled() {
        }
    }

    @Deprecated
    public static interface OnKeyguardExitResult {
        public void onKeyguardExitResult(boolean var1);
    }

    @Deprecated
    public class KeyguardLock {
        private final IBinder mToken = new Binder();
        private final String mTag;

        KeyguardLock(String tag) {
            this.mTag = tag;
        }

        public void disableKeyguard() {
            try {
                KeyguardManager.this.mWM.disableKeyguard(this.mToken, this.mTag, KeyguardManager.this.mContext.getUserId());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void reenableKeyguard() {
            try {
                KeyguardManager.this.mWM.reenableKeyguard(this.mToken, KeyguardManager.this.mContext.getUserId());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

