/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.AppLinksAnalyticsProvider;
import com.google.urlassistant.DeepLinks;
import com.google.urlassistant.UrlAssistIcons;
import com.google.urlassistant.editor.UrlAssistantWindowBase;
import com.google.urlassistant.logcat.AppLinksLogLineListener;
import com.google.urlassistant.util.DeepLinkUtils;
import com.google.urlassistant.util.UrlAssistUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.UIManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppLinkTestingWindow
implements UrlAssistantWindowBase {
    private final Project myProject;
    private DeepLinks myDeepLinksData;
    private Module myModule = null;
    private JPanel myRootPanel;
    private JButton myLaunchTestButton;
    private JBTextField myUrlField;
    private JLabel myShortResultLabel;
    private JComboBox<Module> myModuleBox;
    private DefaultComboBoxModel<Module> myComboBoxModel;
    private JBLabel myTitleLabel;
    private JTextPane myDescriptionTextPane;
    private JBLabel mySmallTitleLabel;
    private static final JBColor GRAY_TEXT_COLOR = new JBColor((Color)Gray._80, (Color)Gray._156);
    private static AppLinksLogLineListener myLogLineListener;
    private boolean myIsWindowActivated;
    private ActivityData myActivityData;

    public JComponent getPanel() {
        return this.myRootPanel;
    }

    public AppLinkTestingWindow(@NotNull Project project) {
        this.$$$setupUI$$$();
        this.myComboBoxModel = new DefaultComboBoxModel();
        this.myIsWindowActivated = false;
        this.myProject = project;
        Color backgroundColor = this.myRootPanel.getBackground();
        this.myDescriptionTextPane.setText(UrlAssistantBundle.message("test.url.launch.url.description.text", new Object[0]));
        this.myDescriptionTextPane.setBackground(backgroundColor);
        this.myShortResultLabel.setBackground(backgroundColor);
        this.myShortResultLabel.setVisible(false);
        this.mySmallTitleLabel.setForeground((Color)GRAY_TEXT_COLOR);
        this.myUrlField.getEmptyText().setText(UrlAssistantBundle.message("test.url.launch.url.field.hint", new Object[0]));
        this.myModuleBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.myModule = (Module)this.myModuleBox.getSelectedItem();
            }
        });
        this.myModuleBox.setModel(this.myComboBoxModel);
        this.myModuleBox.setEditable(false);
        if (myLogLineListener != null) {
            myLogLineListener.stopListening();
        } else {
            myLogLineListener = new AppLinksLogLineListener(this);
        }
        this.addActionHandler();
        this.myRootPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    private void reloadDeepLinksData() {
        Module[] modules;
        this.myComboBoxModel.removeAllElements();
        Module lastSelectedModule = this.myModule;
        this.myDeepLinksData = new DeepLinks();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ApplicationManager.getApplication().invokeAndWait(() -> DeepLinkUtils.loadDeepLinks(module, this.myDeepLinksData, null), ModalityState.any());
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            if (facet == null || !((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()) continue;
            this.myComboBoxModel.addElement(module);
        }
        ImmutableList<DeepLinks.DeepLink> deepLinkList = this.myDeepLinksData.getDeepLinkList();
        if (!deepLinkList.isEmpty()) {
            this.myUrlField.setText(((DeepLinks.DeepLink)deepLinkList.get(0)).getUrl().toString());
        }
        this.setupModuleComboBox(lastSelectedModule);
    }

    private void setupModuleComboBox(@Nullable Module lastSelectedModule) {
        int appModuleCnt = this.myComboBoxModel.getSize();
        this.myModuleBox.setVisible(false);
        if (appModuleCnt == 0) {
            this.setShortResultLabel(UrlAssistantBundle.message("test.url.no.app.module.found", new Object[0]), false);
            this.myModule = null;
        } else if (appModuleCnt == 1) {
            this.myModule = this.myComboBoxModel.getElementAt(0);
        } else {
            this.myModuleBox.setVisible(true);
            AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.APP_LINKS_TEST_PANEL_MODULE_SELECTION, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
            if (lastSelectedModule != null) {
                this.myModuleBox.setSelectedItem(lastSelectedModule);
            }
        }
    }

    private void addActionHandler() {
        this.myLaunchTestButton.addActionListener(e -> this.launchAppViaAppLinks(this.myUrlField.getText()));
        this.myUrlField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AppLinkTestingWindow.this.myLaunchTestButton.doClick();
                } else {
                    AppLinkTestingWindow.this.myShortResultLabel.setVisible(false);
                }
            }
        });
    }

    @VisibleForTesting
    boolean isQualifiedAppLinkUrl(@Nullable String url) {
        if (StringUtil.isEmpty((String)url)) {
            this.setShortResultLabel(UrlAssistantBundle.message("test.url.launch.url.empty.url.error.message", new Object[0]), false);
            return false;
        }
        if (this.myModuleBox.isVisible()) {
            this.myModule = (Module)this.myModuleBox.getSelectedItem();
        }
        if (this.myModule == null) {
            this.setShortResultLabel(UrlAssistantBundle.message("test.url.launch.url.null.module.error.message", new Object[0]), false);
            return false;
        }
        try {
            this.myActivityData = UrlAssistUtils.findAssociatedActivity(this.myDeepLinksData.getDeepLinkList(), url);
            if (this.myActivityData == null) {
                this.setShortResultLabel(UrlAssistantBundle.message("check.url.mapping.fail", new Object[0]), false);
                return false;
            }
            this.setShortResultLabel(UrlAssistantBundle.message("test.url.check.url.mapping.result", this.myActivityData.getActivityAndModuleName()), true);
        }
        catch (MalformedURLException e) {
            this.setShortResultLabel(UrlAssistantBundle.message("test.url.malformed.url.error", new Object[0]), false);
            return false;
        }
        return true;
    }

    void launchAppViaAppLinks(@Nullable String url) {
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.APP_LINKS_TEST_PANEL_RUN_TEST_BUTTON, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
        if (!this.isQualifiedAppLinkUrl(url)) {
            AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.APP_LINKS_TEST_PANEL_RUN_TEST_BUTTON, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
            return;
        }
        myLogLineListener.startListening(this.myModule, this.myActivityData.getActivityName());
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration("URL " + url, AndroidRunConfigurationType.getInstance().getFactory());
        AndroidRunConfiguration configuration = (AndroidRunConfiguration)settings.getConfiguration();
        configuration.setLaunchUrl(url);
        configuration.setModule(this.myModule);
        runManager.addConfiguration(settings, false);
        ProgramRunnerUtil.executeConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)settings, (Executor)DefaultRunExecutor.getRunExecutorInstance());
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.APP_LINKS_TEST_PANEL_RUN_TEST_BUTTON, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
    }

    public void setShortResultLabel(@NotNull String message, boolean success) {
        this.myShortResultLabel.setText(message);
        this.myShortResultLabel.setIcon(success ? UrlAssistIcons.SUCCESS_ICON : UrlAssistIcons.FAIL_ICON);
        this.myShortResultLabel.setVisible(true);
    }

    @Nullable
    Module getCurrentModule() {
        return this.myModule;
    }

    @Nullable
    Module getUserSelectedModule() {
        return (Module)this.myComboBoxModel.getSelectedItem();
    }

    @Nullable
    Module getModuleAt(int index) {
        return this.myComboBoxModel.getElementAt(index);
    }

    void setUserSelectedModule(@NotNull Module module) {
        this.myComboBoxModel.setSelectedItem(module);
    }

    int getModulesCount() {
        return this.myComboBoxModel.getSize();
    }

    @Override
    public void selectNotify() {
        if (!this.myIsWindowActivated) {
            this.reloadDeepLinksData();
            this.myIsWindowActivated = true;
        }
    }

    @Override
    public void deselectNotify() {
        this.myIsWindowActivated = false;
    }

    @Override
    @NotNull
    public JComponent asPanel() {
        return this.getPanel();
    }

    @Nullable
    public static AppLinksLogLineListener getListener() {
        return myLogLineListener;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JTextPane jTextPane;
        JLabel jLabel;
        JBTextField jBTextField;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 3, new Insets(20, 30, 0, 30), -1, -1, false, false));
        jPanel.setFocusCycleRoot(true);
        jPanel.setMinimumSize(new Dimension(-1, 297));
        jPanel.setPreferredSize(new Dimension(-1, 297));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setFocusable(false);
        Font font = this.$$$getFont$$$(null, -1, 14, jBLabel3.getFont());
        if (font != null) {
            jBLabel3.setFont(font);
        }
        jBLabel3.setText("URL");
        jPanel.add((Component)jBLabel3, new GridConstraints(7, 0, 1, 2, 10, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10)));
        this.myUrlField = jBTextField = new JBTextField();
        jBTextField.setToolTipText("");
        jPanel.add((Component)jBTextField, new GridConstraints(8, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myShortResultLabel = jLabel = new JLabel();
        jLabel.setFocusable(false);
        jPanel.add((Component)jLabel, new GridConstraints(9, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(10, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(6, 0, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10)));
        this.myDescriptionTextPane = jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setEditable(false);
        ((Component)jTextPane).setEnabled(true);
        jTextPane.setFocusCycleRoot(false);
        jTextPane.setFocusable(false);
        Font font2 = UIManager.getFont("Label.font");
        if (font2 != null) {
            jTextPane.setFont(font2);
        }
        jTextPane.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        jTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel.add((Component)jTextPane, new GridConstraints(3, 0, 1, 3, 0, 1, 1, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10)));
        this.mySmallTitleLabel = jBLabel2 = new JBLabel();
        jBLabel2.setFocusable(false);
        Font font3 = this.$$$getFont$$$(null, -1, 12, jBLabel2.getFont());
        if (font3 != null) {
            jBLabel2.setFont(font3);
        }
        jBLabel2.setText("App Links Assistant");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 10, 0, 0, 0, null, null, null));
        this.myTitleLabel = jBLabel = new JBLabel();
        jBLabel.setFocusable(false);
        Font font4 = this.$$$getFont$$$(null, 0, 22, jBLabel.getFont());
        if (font4 != null) {
            jBLabel.setFont(font4);
        }
        jBLabel.setText("Test on Device or Emulator");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 4, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setFocusable(false);
        jBLabel4.setIcon(new ImageIcon(this.getClass().getResource("/url_assistant/step_four.png")));
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 2, 1, 0, 0, 0, 0, null, null, null));
        this.myLaunchTestButton = jButton = new JButton();
        jButton.setText("Run Test");
        jPanel.add((Component)jButton, new GridConstraints(8, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myModuleBox = jComboBox;
        ((Component)jComboBox).setEnabled(true);
        jPanel.add(jComboBox, new GridConstraints(5, 0, 1, 3, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

