/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.CompoundStreamProvider;
import com.intellij.configurationStore.DataStateChanged;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.DirectoryBasedStorage;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.FileBasedStorageConfiguration;
import com.intellij.configurationStore.FileBasedStorageConfigurationKt;
import com.intellij.configurationStore.ProjectStoreBaseKt;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StorageCreator;
import com.intellij.configurationStore.StorageVirtualFileTracker;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.UnknownMacroException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 {2\u00020\u0001:\u0004{|}~B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0012H\u0016J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020/H\u0014J*\u00100\u001a\u00020)2\f\u00101\u001a\b\u0012\u0004\u0012\u00020/0\u001d2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000303H\u0014J\u0006\u00104\u001a\u00020)J\u000e\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003J2\u00107\u001a\u00020\u00032\u000e\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020#092\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\b\u0010<\u001a\u0004\u0018\u00010=H\u0002J \u0010>\u001a\u00020#2\u0006\u00106\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u0010?\u001a\u00020@H\u0014J*\u0010A\u001a\u00020#2\u0006\u00106\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u0010B\u001a\u00020C2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0014JB\u0010D\u001a\u00020#2\u000e\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020#092\u0006\u0010;\u001a\u00020\u00032\u0006\u0010B\u001a\u00020C2\u000e\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020@092\b\b\u0002\u0010F\u001a\u00020\u0012H\u0014J\u000e\u0010G\u001a\u00020\u00032\u0006\u0010H\u001a\u00020\u0003J\u0010\u0010I\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003H\u0016J\u0010\u0010J\u001a\u0004\u0018\u00010#2\u0006\u0010K\u001a\u00020\u0003J\f\u0010L\u001a\b\u0012\u0004\u0012\u00020#0MJ2\u0010L\u001a\b\u0012\u0004\u0012\u00020O0N2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00030N2\u0016\b\u0002\u0010Q\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010RJR\u0010L\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020O0N\u0012\n\u0012\b\u0012\u0004\u0012\u00020O0N0S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00030N2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00030N2\u0016\b\u0002\u0010Q\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010RJ\u0010\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\u0003H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010X\u001a\u00020\u0003H\u0014J \u0010Y\u001a\u0004\u0018\u00010#2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010]\u001a\u00020^J\"\u0010_\u001a\u0004\u0018\u00010\u00032\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010]\u001a\u00020^H\u0014Jo\u0010`\u001a\u00020#2\u0006\u0010;\u001a\u00020\u00032\b\b\u0002\u0010B\u001a\u00020C2\u0010\b\u0002\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020#092\u0010\b\u0002\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020@092\b\b\u0002\u0010F\u001a\u00020\u00122\u001b\b\u0002\u0010a\u001a\u0015\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020)\u0018\u00010R\u00a2\u0006\u0002\bb2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010=J\u000e\u0010c\u001a\u00020#2\u0006\u0010d\u001a\u00020eJ\b\u0010f\u001a\u0004\u0018\u00010\tJ\u0010\u0010g\u001a\u00020\u00032\u0006\u0010X\u001a\u00020\u0003H\u0014J\"\u0010h\u001a\u00020)2\u0006\u0010i\u001a\u00020\u00032\u0006\u0010j\u001a\u00020\u00032\b\u0010k\u001a\u0004\u0018\u00010lH\u0016J\"\u0010m\u001a\u00020)2\u0006\u0010n\u001a\u00020O2\b\u0010o\u001a\u0004\u0018\u00010p2\u0006\u0010q\u001a\u00020rH\u0014J\u0018\u0010s\u001a\u00020)2\u000e\u0010t\u001a\n\u0012\u0006\b\u0001\u0012\u00020+09H\u0016J\u0016\u0010u\u001a\u00020)2\u0006\u00106\u001a\u00020\u00032\u0006\u0010v\u001a\u00020\u0003J\u0010\u0010w\u001a\u00020x2\u0006\u00106\u001a\u00020\u0003H\u0014J\u0016\u0010y\u001a\u00020)2\u0006\u0010z\u001a\u00020\u00032\u0006\u0010j\u001a\u00020\u0003R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#0\"j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#`$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u007f"}, d2={"Lcom/intellij/configurationStore/StateStorageManagerImpl;", "Lcom/intellij/configurationStore/StateStorageManager;", "rootTagName", "", "macroSubstitutor", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "virtualFileTracker", "Lcom/intellij/configurationStore/StorageVirtualFileTracker;", "(Ljava/lang/String;Lcom/intellij/openapi/components/PathMacroSubstitutor;Lcom/intellij/openapi/components/ComponentManager;Lcom/intellij/configurationStore/StorageVirtualFileTracker;)V", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "compoundStreamProvider", "Lcom/intellij/configurationStore/CompoundStreamProvider;", "getCompoundStreamProvider", "()Lcom/intellij/configurationStore/CompoundStreamProvider;", "isExternalSystemStorageEnabled", "", "()Z", "isStreamProviderPreventExportAction", "isUseVfsListener", "Lcom/intellij/util/ThreeState;", "isUseVfsListener$annotations", "()V", "isUseXmlProlog", "getMacroSubstitutor", "()Lcom/intellij/openapi/components/PathMacroSubstitutor;", "macros", "", "Lcom/intellij/configurationStore/StateStorageManagerImpl$Macro;", "storageLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "storages", "Ljava/util/HashMap;", "Lcom/intellij/openapi/components/StateStorage;", "Lkotlin/collections/HashMap;", "addMacro", "key", "expansion", "addStreamProvider", "", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "first", "beforeElementLoaded", "element", "Lorg/jdom/Element;", "beforeElementSaved", "elements", "rootAttributes", "", "clearStorages", "collapseMacros", "path", "computeStorageKey", "storageClass", "Ljava/lang/Class;", "normalizedCollapsedPath", "collapsedPath", "storageCreator", "Lcom/intellij/configurationStore/StorageCreator;", "createDirectoryBasedStorage", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "createFileBasedStorage", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "createStateStorage", "stateSplitter", "exclusive", "expandMacro", "macro", "expandMacros", "findCachedFileStorage", "name", "getCachedFileStorages", "", "", "Lcom/intellij/configurationStore/FileBasedStorage;", "fileSpecs", "pathNormalizer", "Lkotlin/Function1;", "Lkotlin/Pair;", "changed", "deleted", "getFileBasedStorageConfiguration", "Lcom/intellij/configurationStore/FileBasedStorageConfiguration;", "fileSpec", "getOldStorage", "component", "", "componentName", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "getOldStorageSpec", "getOrCreateStorage", "storageCustomizer", "Lkotlin/ExtensionFunctionType;", "getStateStorage", "storageSpec", "Lcom/intellij/openapi/components/Storage;", "getVirtualFileTracker", "normalizeFileSpec", "pathRenamed", "oldPath", "newPath", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "providerDataStateChanged", "storage", "writer", "Lcom/intellij/configurationStore/DataWriter;", "type", "Lcom/intellij/configurationStore/DataStateChanged;", "removeStreamProvider", "clazz", "rename", "newName", "resolvePath", "Ljava/nio/file/Path;", "updatePath", "spec", "Companion", "Macro", "MyDirectoryStorage", "MyFileStorage", "intellij.platform.configurationStore.impl"})
public class StateStorageManagerImpl
implements StateStorageManager {
    private final List<Macro> macros;
    private final ReentrantReadWriteLock storageLock;
    private final HashMap<String, StateStorage> storages;
    @NotNull
    private final CompoundStreamProvider compoundStreamProvider;
    private ThreeState isUseVfsListener;
    private final String rootTagName;
    @Nullable
    private final PathMacroSubstitutor macroSubstitutor;
    @Nullable
    private final ComponentManager componentManager;
    private final StorageVirtualFileTracker virtualFileTracker;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CompoundStreamProvider getCompoundStreamProvider() {
        return this.compoundStreamProvider;
    }

    public final boolean isStreamProviderPreventExportAction() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)this.compoundStreamProvider.getProviders();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StreamProvider it = (StreamProvider)element$iv;
                    boolean bl2 = false;
                    if (!it.isDisableExportAction()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void addStreamProvider(@NotNull StreamProvider provider, boolean first) {
        if (first) {
            this.compoundStreamProvider.getProviders().add(0, (Object)provider);
        } else {
            this.compoundStreamProvider.getProviders().add((Object)provider);
        }
    }

    public void removeStreamProvider(@NotNull Class<? extends StreamProvider> clazz) {
        CollectionsKt.removeAll((List)((List)this.compoundStreamProvider.getProviders()), (Function1)((Function1)new Function1<StreamProvider, Boolean>(clazz){
            final /* synthetic */ Class $clazz;

            public final boolean invoke(StreamProvider it) {
                return this.$clazz.isInstance(it);
            }
            {
                this.$clazz = clazz;
                super(1);
            }
        }));
    }

    private static /* synthetic */ void isUseVfsListener$annotations() {
    }

    @NotNull
    public FileBasedStorageConfiguration getFileBasedStorageConfiguration(@NotNull String fileSpec) {
        return FileBasedStorageConfigurationKt.getDefaultFileBasedStorageConfiguration();
    }

    protected boolean isUseXmlProlog() {
        return true;
    }

    @Nullable
    public final StorageVirtualFileTracker getVirtualFileTracker() {
        return this.virtualFileTracker;
    }

    public final boolean addMacro(@NotNull String key, @NotNull String expansion) {
        CharSequence charSequence = key;
        boolean bl = false;
        ComponentStoreImplKt.getLOG().assertTrue(charSequence.length() > 0);
        String value2 = null;
        if (StringsKt.contains$default((CharSequence)expansion, (char)'\\', (boolean)false, (int)2, null)) {
            ComponentStoreImplKt.getLOG().error("Macro " + key + " set to system-dependent expansion " + expansion);
            value2 = FileUtilRt.toSystemIndependentName((String)expansion);
        } else {
            value2 = expansion;
        }
        for (Macro macro : this.macros) {
            if (!Intrinsics.areEqual((Object)key, (Object)macro.getKey())) continue;
            macro.setValue(value2);
            return false;
        }
        this.macros.add(new Macro(key, value2));
        return true;
    }

    public void pathRenamed(@NotNull String oldPath, @NotNull String newPath, @Nullable VFileEvent event) {
        for (Macro macro : this.macros) {
            if (!Intrinsics.areEqual((Object)oldPath, (Object)macro.getValue())) continue;
            macro.setValue(newPath);
        }
    }

    @NotNull
    public final StateStorage getStateStorage(@NotNull Storage storageSpec) {
        String string = StateStorageManagerImplKt.getPath(storageSpec);
        RoamingType roamingType = storageSpec.roamingType();
        Class clazz = storageSpec.storageClass();
        Class clazz2 = storageSpec.stateSplitter();
        boolean bl = storageSpec.exclusive();
        Storage storage2 = storageSpec;
        if (!(storage2 instanceof StorageCreator)) {
            storage2 = null;
        }
        return StateStorageManagerImpl.getOrCreateStorage$default(this, string, roamingType, clazz, clazz2, bl, null, (StorageCreator)storage2, 32, null);
    }

    @NotNull
    protected String normalizeFileSpec(@NotNull String fileSpec) {
        String string;
        String path = FileUtilRt.toSystemIndependentName((String)fileSpec);
        if (StringsKt.endsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null)) {
            String string2 = path;
            int n = 0;
            int n2 = path.length() - 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = path;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final StateStorage getOrCreateStorage(@NotNull String collapsedPath, @NotNull RoamingType roamingType, @NotNull Class<? extends StateStorage> storageClass, @NotNull Class<? extends StateSplitter> stateSplitter, boolean exclusive, @Nullable Function1<? super StateStorage, Unit> storageCustomizer, @Nullable StorageCreator storageCreator) {
        StateStorage storage2;
        block14: {
            StateStorage stateStorage;
            String normalizedCollapsedPath = this.normalizeFileSpec(collapsedPath);
            String key = this.computeStorageKey(storageClass, normalizedCollapsedPath, collapsedPath, (StorageCreator)storageCreator);
            Function1<? super StateStorage, Unit> function1 = this.storageLock;
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = function1.readLock();
            readLock.lock();
            try {
                boolean $i$a$-read-StateStorageManagerImpl$getOrCreateStorage$storage$22 = false;
                StateStorage $i$a$-read-StateStorageManagerImpl$getOrCreateStorage$storage$22 = this.storages.get(key);
                stateStorage = $i$a$-read-StateStorageManagerImpl$getOrCreateStorage$storage$22;
            }
            finally {
                readLock.unlock();
            }
            if (stateStorage == null) {
                StateStorage stateStorage2;
                int n;
                int n2;
                function1 = this.storageLock;
                bl = false;
                boolean bl3 = false;
                ReentrantReadWriteLock.ReadLock readLock2 = function1.readLock();
                int $i$a$-read-StateStorageManagerImpl$getOrCreateStorage$storage$22 = function1.getWriteHoldCount() == 0 ? function1.getReadHoldCount() : 0;
                boolean bl4 = false;
                int n3 = 0;
                n3 = 0;
                int n4 = $i$a$-read-StateStorageManagerImpl$getOrCreateStorage$storage$22;
                while (n3 < n4) {
                    n2 = n3++;
                    n = 0;
                    readLock2.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = function1.writeLock();
                writeLock.lock();
                try {
                    Object object;
                    void $this$getOrPut$iv;
                    boolean bl5 = false;
                    Map map = this.storages;
                    String key$iv = key;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl6 = false;
                        Function1<? super StateStorage, Unit> function12 = storageCreator;
                        StateStorage storage3 = function12 == null ? this.createStateStorage(storageClass, normalizedCollapsedPath, roamingType, stateSplitter, exclusive) : storageCreator.create((StateStorageManager)this);
                        Function1<? super StateStorage, Unit> function13 = storageCustomizer;
                        if (function13 != null) {
                            function12 = function13;
                            boolean bl7 = false;
                            boolean bl8 = false;
                            Function1<? super StateStorage, Unit> it = function12;
                            boolean bl9 = false;
                            it.invoke((Object)storage3);
                        }
                        StateStorage answer$iv = storage3;
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    stateStorage2 = (StateStorage)object;
                }
                finally {
                    n4 = 0;
                    n2 = 0;
                    n2 = 0;
                    n = $i$a$-read-StateStorageManagerImpl$getOrCreateStorage$storage$22;
                    while (n2 < n) {
                        int n5 = n2++;
                        boolean bl10 = false;
                        readLock2.lock();
                    }
                    writeLock.unlock();
                }
                return stateStorage2;
            }
            storage2 = stateStorage;
            Function1<? super StateStorage, Unit> function14 = storageCustomizer;
            if (function14 == null) break block14;
            function1 = function14;
            bl = false;
            boolean bl11 = false;
            Function1<? super StateStorage, Unit> it = function1;
            boolean bl12 = false;
            it.invoke((Object)storage2);
        }
        return storage2;
    }

    public static /* synthetic */ StateStorage getOrCreateStorage$default(StateStorageManagerImpl stateStorageManagerImpl, String string, RoamingType roamingType, Class clazz, Class clazz2, boolean bl, Function1 function1, StorageCreator storageCreator, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getOrCreateStorage");
        }
        if ((n & 2) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 4) != 0) {
            clazz = StateStorage.class;
        }
        if ((n & 8) != 0) {
            clazz2 = StateSplitterEx.class;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        if ((n & 0x40) != 0) {
            storageCreator = null;
        }
        return stateStorageManagerImpl.getOrCreateStorage(string, roamingType, clazz, clazz2, bl, (Function1<? super StateStorage, Unit>)function1, storageCreator);
    }

    private final String computeStorageKey(Class<? extends StateStorage> storageClass, String normalizedCollapsedPath, String collapsedPath, StorageCreator storageCreator) {
        if (Intrinsics.areEqual(storageClass, StateStorage.class) ^ true) {
            return storageClass.getName();
        }
        CharSequence charSequence = normalizedCollapsedPath;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new Exception("Normalized path is empty, raw path '" + collapsedPath + '\'');
        }
        Object object = storageCreator;
        if (object == null || (object = object.getKey()) == null) {
            object = normalizedCollapsedPath;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<StateStorage> getCachedFileStorages() {
        Set set;
        ReentrantReadWriteLock reentrantReadWriteLock = this.storageLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            set = CollectionsKt.toSet((Iterable)this.storages.values());
        }
        finally {
            readLock.unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final StateStorage findCachedFileStorage(@NotNull String name) {
        StateStorage stateStorage;
        ReentrantReadWriteLock reentrantReadWriteLock = this.storageLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            stateStorage = this.storages.get(name);
        }
        finally {
            readLock.unlock();
        }
        return stateStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<Collection<FileBasedStorage>, Collection<FileBasedStorage>> getCachedFileStorages(@NotNull Collection<String> changed, @NotNull Collection<String> deleted, @Nullable Function1<? super String, String> pathNormalizer) {
        Pair pair;
        ReentrantReadWriteLock reentrantReadWriteLock = this.storageLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            pair = new Pair(this.getCachedFileStorages(changed, pathNormalizer), this.getCachedFileStorages(deleted, pathNormalizer));
        }
        finally {
            readLock.unlock();
        }
        return pair;
    }

    public static /* synthetic */ Pair getCachedFileStorages$default(StateStorageManagerImpl stateStorageManagerImpl, Collection collection, Collection collection2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCachedFileStorages");
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        return stateStorageManagerImpl.getCachedFileStorages(collection, collection2, (Function1<? super String, String>)function1);
    }

    public final void updatePath(@NotNull String spec, @NotNull String newPath) {
        FileBasedStorage fileBasedStorage = (FileBasedStorage)((Object)CollectionsKt.firstOrNull((Iterable)StateStorageManagerImpl.getCachedFileStorages$default(this, CollectionsKt.listOf((Object)spec), null, 2, null)));
        if (fileBasedStorage == null) {
            return;
        }
        FileBasedStorage storage2 = fileBasedStorage;
        if (storage2 instanceof StorageVirtualFileTracker.TrackedStorage) {
            StorageVirtualFileTracker storageVirtualFileTracker = this.virtualFileTracker;
            if (storageVirtualFileTracker != null) {
                StorageVirtualFileTracker storageVirtualFileTracker2 = storageVirtualFileTracker;
                boolean bl = false;
                boolean bl2 = false;
                StorageVirtualFileTracker tracker = storageVirtualFileTracker2;
                boolean bl3 = false;
                tracker.remove(PathKt.getSystemIndependentPath((Path)storage2.getFile()));
                tracker.put(newPath, (StorageVirtualFileTracker.TrackedStorage)((Object)storage2));
            }
        }
        storage2.setFile(null, this.resolvePath(newPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Collection<FileBasedStorage> getCachedFileStorages(@NotNull Collection<String> fileSpecs, @Nullable Function1<? super String, String> pathNormalizer) {
        if (fileSpecs.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.storageLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            List result = null;
            for (String fileSpec : fileSpecs) {
                String path;
                StateStorage storage2;
                Object object = pathNormalizer;
                if (object == null || (object = (String)object.invoke((Object)fileSpec)) == null) {
                    object = fileSpec;
                }
                if (!((storage2 = this.storages.get(path = this.normalizeFileSpec((String)object))) instanceof FileBasedStorage)) continue;
                if (result == null) {
                    result = (List)new SmartList();
                }
                result.add(storage2);
            }
            List list = result;
            Collection collection = list != null ? (Collection)list : (Collection)CollectionsKt.emptyList();
            return collection;
        }
        finally {
            readLock.unlock();
        }
    }

    public static /* synthetic */ Collection getCachedFileStorages$default(StateStorageManagerImpl stateStorageManagerImpl, Collection collection, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCachedFileStorages");
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        return stateStorageManagerImpl.getCachedFileStorages(collection, (Function1<? super String, String>)function1);
    }

    @NotNull
    protected StateStorage createStateStorage(@NotNull Class<? extends StateStorage> storageClass, @NotNull String collapsedPath, @NotNull RoamingType roamingType, @NotNull Class<? extends StateSplitter> stateSplitter, boolean exclusive) {
        StateStorage storage2;
        block15: {
            if (Intrinsics.areEqual(storageClass, StateStorage.class) ^ true) {
                Constructor<?> element$iv;
                block14: {
                    Constructor<?>[] $this$first$iv = storageClass.getConstructors();
                    boolean $i$f$first = false;
                    Constructor<?>[] constructorArray = $this$first$iv;
                    int n = constructorArray.length;
                    for (int i = 0; i < n; ++i) {
                        Constructor<?> it = element$iv = constructorArray[i];
                        boolean bl = false;
                        if (!(it.getParameterCount() <= 3)) {
                            continue;
                        }
                        break block14;
                    }
                    throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
                }
                Constructor<?> constructor = element$iv;
                constructor.setAccessible(true);
                if (constructor.getParameterCount() == 2) {
                    Object[] objectArray = new Object[2];
                    ComponentManager componentManager = this.getComponentManager();
                    if (componentManager == null) {
                        Intrinsics.throwNpe();
                    }
                    objectArray[0] = componentManager;
                    objectArray[1] = this;
                    Object obj = constructor.newInstance(objectArray);
                    if (obj == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.StateStorage");
                    }
                    return (StateStorage)obj;
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = collapsedPath;
                ComponentManager componentManager = this.getComponentManager();
                if (componentManager == null) {
                    Intrinsics.throwNpe();
                }
                objectArray[1] = componentManager;
                objectArray[2] = this;
                Object obj = constructor.newInstance(objectArray);
                if (obj == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.StateStorage");
                }
                return (StateStorage)obj;
            }
            RoamingType effectiveRoamingType = StateStorageManagerImplKt.getEffectiveRoamingType(roamingType, collapsedPath);
            if (this.isUseVfsListener == ThreeState.UNSURE) {
                this.isUseVfsListener = ThreeState.fromBoolean((!this.compoundStreamProvider.isApplicable(collapsedPath, effectiveRoamingType) ? 1 : 0) != 0);
            }
            String filePath = this.expandMacros(collapsedPath);
            if (Intrinsics.areEqual(stateSplitter, StateSplitter.class) ^ true && Intrinsics.areEqual(stateSplitter, StateSplitterEx.class) ^ true) {
                StateStorage storage3 = this.createDirectoryBasedStorage(filePath, collapsedPath, (StateSplitter)ReflectionUtil.newInstance(stateSplitter));
                if (storage3 instanceof StorageVirtualFileTracker.TrackedStorage) {
                    StorageVirtualFileTracker storageVirtualFileTracker = this.virtualFileTracker;
                    if (storageVirtualFileTracker != null) {
                        storageVirtualFileTracker.put(filePath, (StorageVirtualFileTracker.TrackedStorage)storage3);
                    }
                }
                return storage3;
            }
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isHeadlessEnvironment() && StringsKt.lastIndexOf$default((CharSequence)PathUtilRt.getFileName((String)filePath), (char)'.', (int)0, (boolean)false, (int)6, null) < 0) {
                throw (Throwable)new IllegalArgumentException("Extension is missing for storage file: " + filePath);
            }
            storage2 = this.createFileBasedStorage(filePath, collapsedPath, effectiveRoamingType, exclusive ? null : this.rootTagName);
            if (this.isUseVfsListener != ThreeState.YES || !(storage2 instanceof StorageVirtualFileTracker.TrackedStorage)) break block15;
            StorageVirtualFileTracker storageVirtualFileTracker = this.virtualFileTracker;
            if (storageVirtualFileTracker != null) {
                storageVirtualFileTracker.put(filePath, (StorageVirtualFileTracker.TrackedStorage)storage2);
            }
        }
        return storage2;
    }

    public static /* synthetic */ StateStorage createStateStorage$default(StateStorageManagerImpl stateStorageManagerImpl, Class clazz, String string, RoamingType roamingType, Class clazz2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createStateStorage");
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return stateStorageManagerImpl.createStateStorage(clazz, string, roamingType, clazz2, bl);
    }

    @NotNull
    protected StateStorage createFileBasedStorage(@NotNull String path, @NotNull String collapsedPath, @NotNull RoamingType roamingType, @Nullable String rootTagName) {
        CompoundStreamProvider compoundStreamProvider;
        if (roamingType == RoamingType.DISABLED) {
            this.compoundStreamProvider.delete(collapsedPath, roamingType);
            compoundStreamProvider = null;
        } else {
            compoundStreamProvider = this.compoundStreamProvider;
        }
        CompoundStreamProvider provider = compoundStreamProvider;
        return new MyFileStorage(this, this.resolvePath(path), collapsedPath, rootTagName, roamingType, this.getMacroSubstitutor(collapsedPath), provider);
    }

    @NotNull
    protected StateStorage createDirectoryBasedStorage(@NotNull String path, @NotNull String collapsedPath, @NotNull StateSplitter splitter) {
        return new MyDirectoryStorage(this, this.resolvePath(path), splitter);
    }

    public boolean isExternalSystemStorageEnabled() {
        return false;
    }

    protected void beforeElementSaved(@NotNull List<Element> elements, @NotNull Map<String, String> rootAttributes) {
    }

    protected void providerDataStateChanged(@NotNull FileBasedStorage storage2, @Nullable DataWriter writer, @NotNull DataStateChanged type) {
    }

    protected void beforeElementLoaded(@NotNull Element element) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rename(@NotNull String path, @NotNull String newName) {
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.storageLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            StateStorage stateStorage = StateStorageManagerImpl.getOrCreateStorage$default(this, this.collapseMacros(path), RoamingType.DEFAULT, null, null, false, null, null, 124, null);
            if (stateStorage == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.FileBasedStorage");
            }
            FileBasedStorage storage2 = (FileBasedStorage)stateStorage;
            VirtualFile file = storage2.getVirtualFile(StateStorageOperation.WRITE);
            try {
                if (file != null) {
                    file.rename((Object)storage2, newName);
                } else if (Intrinsics.areEqual((Object)((Object)storage2.getFile().getFileName()).toString(), (Object)newName) ^ true) {
                    String expandedPath = this.expandMacros(path);
                    String parentPath = PathUtilRt.getParentPath((String)expandedPath);
                    storage2.setFile(null, this.resolvePath(parentPath).resolve(newName));
                    this.pathRenamed(expandedPath, parentPath + '/' + newName, null);
                }
            }
            catch (IOException e) {
                ComponentStoreImplKt.getLOG().debug((Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearStorages() {
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.storageLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            try {
                if (this.virtualFileTracker != null) {
                    for (String collapsedPath : this.storages.keySet()) {
                        this.virtualFileTracker.remove(this.expandMacros(collapsedPath));
                    }
                }
            }
            finally {
                this.storages.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Nullable
    protected PathMacroSubstitutor getMacroSubstitutor(@NotNull String fileSpec) {
        return this.macroSubstitutor;
    }

    @NotNull
    public String expandMacros(@NotNull String path) {
        String key;
        Matcher matcher = StateStorageManagerImplKt.access$getMACRO_PATTERN$p().matcher(path);
        block0: while (matcher.find()) {
            String m = matcher.group(1);
            for (Macro macro : this.macros) {
                key = macro.component1();
                if (!Intrinsics.areEqual((Object)key, (Object)m)) continue;
                continue block0;
            }
            throw (Throwable)new UnknownMacroException("Unknown macro: " + m + " in storage file spec: " + path);
        }
        String expanded = path;
        for (Macro macro : this.macros) {
            key = macro.component1();
            String value2 = macro.component2();
            expanded = StringUtil.replace((String)expanded, (String)key, (String)value2);
        }
        return expanded;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String expandMacro(@NotNull String macro) {
        for (Macro macro2 : this.macros) {
            void key;
            String string = macro2.component1();
            String value2 = macro2.component2();
            if (!Intrinsics.areEqual((Object)key, (Object)macro)) continue;
            return value2;
        }
        throw (Throwable)new UnknownMacroException("Unknown macro " + macro);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String collapseMacros(@NotNull String path) {
        String result = path;
        for (Macro macro : this.macros) {
            void key;
            String string = macro.component1();
            String value2 = macro.component2();
            result = StringsKt.replace$default((String)result, (String)value2, (String)key, (boolean)false, (int)4, null);
        }
        return this.normalizeFileSpec(result);
    }

    @Nullable
    public final StateStorage getOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        String string = this.getOldStorageSpec(component, componentName, operation);
        if (string == null) {
            return null;
        }
        String oldStorageSpec = string;
        return StateStorageManagerImpl.getOrCreateStorage$default(this, oldStorageSpec, RoamingType.DEFAULT, null, null, false, null, null, 124, null);
    }

    @Nullable
    protected String getOldStorageSpec(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        return null;
    }

    @NotNull
    protected Path resolvePath(@NotNull String path) {
        return Paths.get(path, new String[0]);
    }

    @Nullable
    public final PathMacroSubstitutor getMacroSubstitutor() {
        return this.macroSubstitutor;
    }

    @Nullable
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public StateStorageManagerImpl(@NotNull String rootTagName, @Nullable PathMacroSubstitutor macroSubstitutor, @Nullable ComponentManager componentManager, @Nullable StorageVirtualFileTracker virtualFileTracker) {
        this.rootTagName = rootTagName;
        this.macroSubstitutor = macroSubstitutor;
        this.componentManager = componentManager;
        this.virtualFileTracker = virtualFileTracker;
        this.macros = ContainerUtil.createLockFreeCopyOnWriteList();
        this.storageLock = new ReentrantReadWriteLock();
        this.storages = new HashMap();
        this.compoundStreamProvider = new CompoundStreamProvider();
        ComponentManager componentManager2 = this.getComponentManager();
        this.isUseVfsListener = componentManager2 == null || componentManager2 instanceof Application ? ThreeState.NO : ThreeState.UNSURE;
    }

    public /* synthetic */ StateStorageManagerImpl(String string, PathMacroSubstitutor pathMacroSubstitutor, ComponentManager componentManager, StorageVirtualFileTracker storageVirtualFileTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pathMacroSubstitutor = null;
        }
        if ((n & 4) != 0) {
            componentManager = null;
        }
        if ((n & 8) != 0) {
            storageVirtualFileTracker = StateStorageManagerImpl.Companion.createDefaultVirtualTracker(componentManager);
        }
        this(string, pathMacroSubstitutor, componentManager, storageVirtualFileTracker);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0007\"\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/configurationStore/StateStorageManagerImpl$Macro;", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "getValue", "setValue", "(Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.configurationStore.impl"})
    private static final class Macro {
        @NotNull
        private final String key;
        @NotNull
        private String value;

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public final void setValue(@NotNull String string) {
            this.value = string;
        }

        public Macro(@NotNull String key, @NotNull String value2) {
            this.key = key;
            this.value = value2;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final Macro copy(@NotNull String key, @NotNull String value2) {
            return new Macro(key, value2);
        }

        public static /* synthetic */ Macro copy$default(Macro macro, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = macro.key;
            }
            if ((n & 2) != 0) {
                string2 = macro.value;
            }
            return macro.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Macro(key=" + this.key + ", value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.key;
            String string2 = this.value;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Macro)) break block3;
                    Macro macro = (Macro)object;
                    if (!Intrinsics.areEqual((Object)this.key, (Object)macro.key) || !Intrinsics.areEqual((Object)this.value, (Object)macro.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/configurationStore/StateStorageManagerImpl$MyDirectoryStorage;", "Lcom/intellij/configurationStore/DirectoryBasedStorage;", "Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "file", "Ljava/nio/file/Path;", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "(Lcom/intellij/configurationStore/StateStorageManagerImpl;Ljava/nio/file/Path;Lcom/intellij/openapi/components/StateSplitter;)V", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "intellij.platform.configurationStore.impl"})
    private static final class MyDirectoryStorage
    extends DirectoryBasedStorage
    implements StorageVirtualFileTracker.TrackedStorage {
        @NotNull
        private final StateStorageManagerImpl storageManager;

        @Override
        @NotNull
        public StateStorageManagerImpl getStorageManager() {
            return this.storageManager;
        }

        public MyDirectoryStorage(@NotNull StateStorageManagerImpl storageManager2, @NotNull Path file, @NotNull StateSplitter splitter) {
            super(file, splitter, storageManager2.getMacroSubstitutor());
            this.storageManager = storageManager2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\u00020\u00012\u00020\u0002BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J*\u0010\u001e\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\"H\u0014J\u001c\u0010#\u001a\u00020$2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010'\u001a\u00020(H\u0016J\u001a\u0010)\u001a\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0014R\u0014\u0010\u0011\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006."}, d2={"Lcom/intellij/configurationStore/StateStorageManagerImpl$MyFileStorage;", "Lcom/intellij/configurationStore/FileBasedStorage;", "Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "file", "Ljava/nio/file/Path;", "fileSpec", "", "rootElementName", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Lcom/intellij/configurationStore/StateStorageManagerImpl;Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/openapi/components/PathMacroSubstitutor;Lcom/intellij/configurationStore/StreamProvider;)V", "configuration", "Lcom/intellij/configurationStore/FileBasedStorageConfiguration;", "getConfiguration", "()Lcom/intellij/configurationStore/FileBasedStorageConfiguration;", "isUseXmlProlog", "", "()Z", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "beforeElementLoaded", "", "element", "Lorg/jdom/Element;", "beforeElementSaved", "elements", "", "rootAttributes", "", "getResolution", "Lcom/intellij/openapi/components/StateStorageChooserEx$Resolution;", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "providerDataStateChanged", "writer", "Lcom/intellij/configurationStore/DataWriter;", "type", "Lcom/intellij/configurationStore/DataStateChanged;", "intellij.platform.configurationStore.impl"})
    protected static class MyFileStorage
    extends FileBasedStorage
    implements StorageVirtualFileTracker.TrackedStorage {
        @NotNull
        private final StateStorageManagerImpl storageManager;

        @Override
        protected boolean isUseXmlProlog() {
            return this.getRootElementName() != null && this.getStorageManager().isUseXmlProlog() && !ProjectStoreBaseKt.isSpecialStorage(this.getFileSpec());
        }

        @Override
        @NotNull
        protected FileBasedStorageConfiguration getConfiguration() {
            return this.getStorageManager().getFileBasedStorageConfiguration(this.getFileSpec());
        }

        @Override
        protected void beforeElementSaved(@NotNull List<Element> elements, @NotNull Map<String, String> rootAttributes) {
            if (this.getRootElementName() != null) {
                this.getStorageManager().beforeElementSaved(elements, rootAttributes);
            }
            super.beforeElementSaved(elements, rootAttributes);
        }

        @Override
        protected void beforeElementLoaded(@NotNull Element element) {
            this.getStorageManager().beforeElementLoaded(element);
            super.beforeElementLoaded(element);
        }

        @Override
        protected void providerDataStateChanged(@Nullable DataWriter writer, @NotNull DataStateChanged type) {
            this.getStorageManager().providerDataStateChanged(this, writer, type);
            super.providerDataStateChanged(writer, type);
        }

        @NotNull
        public StateStorageChooserEx.Resolution getResolution(@NotNull PersistentStateComponent<?> component, @NotNull StateStorageOperation operation) {
            if (operation == StateStorageOperation.WRITE && component instanceof ProjectModelElement && this.getStorageManager().isExternalSystemStorageEnabled() && ((ProjectModelElement)component).getExternalSource() != null) {
                return StateStorageChooserEx.Resolution.CLEAR;
            }
            return StateStorageChooserEx.Resolution.DO;
        }

        @Override
        @NotNull
        public StateStorageManagerImpl getStorageManager() {
            return this.storageManager;
        }

        public MyFileStorage(@NotNull StateStorageManagerImpl storageManager2, @NotNull Path file, @NotNull String fileSpec, @Nullable String rootElementName, @NotNull RoamingType roamingType, @Nullable PathMacroSubstitutor pathMacroManager, @Nullable StreamProvider provider) {
            super(file, fileSpec, rootElementName, pathMacroManager, roamingType, provider);
            this.storageManager = storageManager2;
        }

        public /* synthetic */ MyFileStorage(StateStorageManagerImpl stateStorageManagerImpl, Path path, String string, String string2, RoamingType roamingType, PathMacroSubstitutor pathMacroSubstitutor, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                pathMacroSubstitutor = null;
            }
            if ((n & 0x40) != 0) {
                streamProvider = null;
            }
            this(stateStorageManagerImpl, path, string, string2, roamingType, pathMacroSubstitutor, streamProvider);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/configurationStore/StateStorageManagerImpl$Companion;", "", "()V", "createDefaultVirtualTracker", "Lcom/intellij/configurationStore/StorageVirtualFileTracker;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "intellij.platform.configurationStore.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final StorageVirtualFileTracker createDefaultVirtualTracker(ComponentManager componentManager) {
            StorageVirtualFileTracker storageVirtualFileTracker;
            ComponentManager componentManager2 = componentManager;
            if (componentManager2 == null) {
                storageVirtualFileTracker = null;
            } else if (componentManager2 instanceof Application) {
                storageVirtualFileTracker = new StorageVirtualFileTracker(((Application)componentManager).getMessageBus());
            } else {
                void var3_3;
                Object object;
                StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)ApplicationManager.getApplication())).getStorageManager();
                if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
                    stateStorageManager = null;
                }
                if ((object = (StateStorageManagerImpl)stateStorageManager) == null || (object = ((StateStorageManagerImpl)object).virtualFileTracker) == null) {
                    return null;
                }
                Object tracker = object;
                Disposer.register((Disposable)((Disposable)componentManager), (Disposable)new Disposable((StorageVirtualFileTracker)tracker, componentManager){
                    final /* synthetic */ StorageVirtualFileTracker $tracker;
                    final /* synthetic */ ComponentManager $componentManager;

                    public final void dispose() {
                        this.$tracker.remove((Function1<? super StorageVirtualFileTracker.TrackedStorage, Boolean>)((Function1)new Function1<StorageVirtualFileTracker.TrackedStorage, Boolean>(this){
                            final /* synthetic */ createDefaultVirtualTracker.1 this$0;

                            public final boolean invoke(@NotNull StorageVirtualFileTracker.TrackedStorage it) {
                                return Intrinsics.areEqual((Object)it.getStorageManager().getComponentManager(), (Object)this.this$0.$componentManager);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                    }
                    {
                        this.$tracker = storageVirtualFileTracker;
                        this.$componentManager = componentManager;
                    }
                });
                storageVirtualFileTracker = var3_3;
            }
            return storageVirtualFileTracker;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

