/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentInfo;
import com.intellij.configurationStore.ComponentInfoImpl;
import com.intellij.configurationStore.ComponentInfoKt;
import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DefaultStateSerializerKt;
import com.intellij.configurationStore.EdtPoolDispatcherKt;
import com.intellij.configurationStore.ExternalStorageWithInternalPart;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.PersistenceStateAdapter;
import com.intellij.configurationStore.SaveResult;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.SaveSessionProducerManager;
import com.intellij.configurationStore.StateAnnotation;
import com.intellij.configurationStore.StateGetter;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StorageBaseExKt;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEvents;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBus;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J+\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0010\u00a2\u0006\u0002\b J+\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u0016H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'J\b\u0010(\u001a\u00020\u0016H\u0016J,\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J<\u00101\u001a\b\u0012\u0004\u0012\u00020,022\u0006\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u0002052\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00052\f\u00106\u001a\b\u0012\u0004\u0012\u00020,07H\u0014J6\u00108\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00062\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,092\u000e\u0010:\u001a\n\u0012\u0004\u0012\u000205\u0018\u00010;2\u0006\u00103\u001a\u00020<H\u0002J#\u0010=\u001a\u00020\u00142\u0006\u0010>\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001aH\u00a0@\u00f8\u0001\u0000\u00a2\u0006\u0004\b?\u0010@J\u0019\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060BH\u0000\u00a2\u0006\u0002\bCJ7\u0010D\u001a\u0004\u0018\u0001HE\"\b\b\u0000\u0010E*\u00020,2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u00052\f\u00106\u001a\b\u0012\u0004\u0012\u0002HE07H\u0002\u00a2\u0006\u0002\u0010FJ\u001a\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00050H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00050HJ\n\u0010J\u001a\u0004\u0018\u00010KH\u0014J.\u0010L\u001a\u0004\u0018\u0001052\f\u0010M\u001a\b\u0012\u0004\u0012\u00020,072\f\u00106\u001a\b\u0012\u0004\u0012\u00020,072\u0006\u0010N\u001a\u00020\u0005H\u0014J2\u0010O\u001a\b\u0012\u0004\u0012\u00020Q0P\"\u0004\b\u0000\u0010E2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002HE092\u0006\u0010-\u001a\u00020.2\u0006\u0010R\u001a\u00020SH\u0014J(\u0010T\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00062\u000e\u0010:\u001a\n\u0012\u0004\u0012\u000205\u0018\u00010;2\u0006\u00103\u001a\u00020<H\u0002J$\u0010T\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\b\u0010/\u001a\u0004\u0018\u0001002\b\u0010U\u001a\u0004\u0018\u00010VH\u0016J\u001e\u0010W\u001a\u00020\u001a2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,092\u0006\u0010N\u001a\u00020\u0005H\u0004J\u001a\u0010X\u001a\u0004\u0018\u00010\u00052\u0006\u0010+\u001a\u00020Y2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0016\u0010Z\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0006\u0010[\u001a\u00020\u0005J&\u0010\\\u001a\u00020\u00052\n\u0010+\u001a\u0006\u0012\u0002\b\u0003092\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u0010\u0010]\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0014\u0010^\u001a\u00020\u001a2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00050;J\u0010\u0010_\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.H\u0014J\u001e\u0010`\u001a\u00020\u001a2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002050;2\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010a\u001a\u00020\u001a2\u0006\u00104\u001a\u000205H\u0014J4\u0010b\u001a\u00020\u00142\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00050;2\u000e\b\u0002\u0010:\u001a\b\u0012\u0004\u0012\u0002050;2\u000e\b\u0002\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00050HJ\b\u0010d\u001a\u00020\u0014H\u0016J\u001e\u0010e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010H2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002050;H\u0016J\u001a\u0010f\u001a\u00020\u00142\u0012\u0010M\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030907J\u001e\u0010f\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00052\f\u0010:\u001a\b\u0012\u0004\u0012\u0002050;H\u0002J\u001c\u0010g\u001a\u00020\u00142\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00050;2\u0006\u0010h\u001a\u00020iJ\u0010\u0010j\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0005H\u0016J\u0019\u0010k\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lJ\u0014\u0010m\u001a\u00020\u00142\n\u0010+\u001a\u0006\u0012\u0002\b\u000309H\u0016J*\u0010n\u001a\u00020\u00142\b\u0010o\u001a\u0004\u0018\u00010,2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010p\u001a\u00020\u00052\u0006\u0010q\u001a\u00020rH\u0014J\b\u0010s\u001a\u00020\u0005H\u0016J\u0010\u0010t\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0016J9\u0010u\u001a\u0002HE\"\u0004\b\u0000\u0010E2\u001e\b\u0004\u0010v\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002HE0x\u0012\u0006\u0012\u0004\u0018\u00010,0wH\u0080H\u00f8\u0001\u0000\u00a2\u0006\u0004\by\u0010zR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006{"}, d2={"Lcom/intellij/configurationStore/ComponentStoreImpl;", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "()V", "components", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/configurationStore/ComponentInfo;", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManager;", "commitComponent", "", "session", "Lcom/intellij/configurationStore/SaveSessionProducerManager;", "info", "componentName", "modificationCountChanged", "", "commitComponents", "isForce", "errors", "", "", "commitComponents$intellij_platform_configurationStore_impl", "commitComponentsOnEdt", "saveResult", "Lcom/intellij/configurationStore/SaveResult;", "forceSavingAllSettings", "saveSessionProducerManager", "commitComponentsOnEdt$intellij_platform_configurationStore_impl", "(Lcom/intellij/configurationStore/SaveResult;ZLcom/intellij/configurationStore/SaveSessionProducerManager;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createSaveSessionProducerManager", "doAddComponent", "name", "component", "", "stateSpec", "Lcom/intellij/openapi/components/State;", "serviceDescriptor", "Lcom/intellij/openapi/components/ServiceDescriptor;", "doCreateStateGetter", "Lcom/intellij/configurationStore/StateGetter;", "reloadData", "storage", "Lcom/intellij/openapi/components/StateStorage;", "stateClass", "Ljava/lang/Class;", "doInitComponent", "Lcom/intellij/openapi/components/PersistentStateComponent;", "changedStorages", "", "Lcom/intellij/util/ThreeState;", "doSave", "result", "doSave$intellij_platform_configurationStore_impl", "(Lcom/intellij/configurationStore/SaveResult;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getComponents", "", "getComponents$intellij_platform_configurationStore_impl", "getDefaultState", "T", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getNotReloadableComponents", "", "componentNames", "getPathMacroManagerForDefaults", "Lcom/intellij/openapi/components/PathMacroManager;", "getReadOnlyStorage", "componentClass", "configurationSchemaKey", "getStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "initComponent", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "initComponentWithoutStateSpec", "initJdomExternalizable", "Lcom/intellij/openapi/util/JDOMExternalizable;", "initPersistencePlainComponent", "key", "initPersistenceStateComponent", "isNotReloadable", "isReloadPossible", "isReportStatisticAllowed", "isStorageChanged", "isUseLoadedStateAsExisting", "reinitComponents", "notReloadableComponents", "release", "reload", "reloadState", "reloadStates", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "removeComponent", "save", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveComponent", "setStateToSaveSessionProducer", "state", "effectiveComponentName", "sessionProducer", "Lcom/intellij/configurationStore/SaveSessionProducer;", "toString", "unloadComponent", "withEdtContext", "task", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "withEdtContext$intellij_platform_configurationStore_impl", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
public abstract class ComponentStoreImpl
implements IComponentStore {
    private final ConcurrentHashMap<String, ComponentInfo> components = new ConcurrentHashMap();

    @Nullable
    public Project getProject() {
        return null;
    }

    @NotNull
    public StateLoadPolicy getLoadPolicy() {
        return StateLoadPolicy.LOAD;
    }

    @NotNull
    public abstract StateStorageManager getStorageManager();

    @NotNull
    public final Map<String, ComponentInfo> getComponents$intellij_platform_configurationStore_impl() {
        return this.components;
    }

    public void initComponent(@NotNull Object component, @Nullable ServiceDescriptor serviceDescriptor, @Nullable PluginId pluginId) {
        String componentName = "";
        try {
            if (component instanceof PersistentStateComponent) {
                State stateSpec = StoreUtilKt.getStateSpec(((PersistentStateComponent)component).getClass());
                if (stateSpec == null) {
                    ComponentInfo info = ComponentInfoKt.createComponentInfo(component, stateSpec, serviceDescriptor);
                    this.initComponent(info, null, ThreeState.NO);
                } else {
                    componentName = this.initPersistenceStateComponent((PersistentStateComponent)component, stateSpec, serviceDescriptor);
                }
                ((PersistentStateComponent)component).initializeComponent();
            } else if (component instanceof JDOMExternalizable) {
                componentName = ComponentStoreImplKt.access$getComponentName(component);
                this.initJdomExternalizable((JDOMExternalizable)component, componentName);
            }
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            ComponentStoreImplKt.getLOG().error((Throwable)new PluginException("Cannot init component state (componentName=" + componentName + ", componentClass=" + component.getClass().getSimpleName() + ')', (Throwable)e, pluginId));
        }
    }

    public void unloadComponent(@NotNull Object component) {
        Object object;
        Object object2 = component;
        if (object2 instanceof PersistentStateComponent) {
            object = StoreUtilKt.getStateSpec(((PersistentStateComponent)component).getClass());
            if (object == null || (object = object.name()) == null) {
                return;
            }
        } else if (object2 instanceof JDOMExternalizable) {
            object = ComponentStoreImplKt.access$getComponentName(component);
        } else {
            return;
        }
        Object name = object;
        this.removeComponent((String)name);
    }

    public final void initPersistencePlainComponent(@NotNull Object component, @NotNull String key) {
        this.initPersistenceStateComponent(new PersistenceStateAdapter(component), new StateAnnotation(key, new FileStorageAnnotation("$WORKSPACE_FILE$", false)), null);
    }

    private final String initPersistenceStateComponent(PersistentStateComponent<?> component, State stateSpec, ServiceDescriptor serviceDescriptor) {
        String componentName;
        block2: {
            componentName = stateSpec.name();
            ComponentInfo info = this.doAddComponent(componentName, component, stateSpec, serviceDescriptor);
            if (!this.initComponent(info, null, ThreeState.NO) || serviceDescriptor == null) break block2;
            Project project = this.getProject();
            if (project != null) {
                Project project2 = project;
                boolean bl = false;
                boolean bl2 = false;
                Project it = project2;
                boolean bl3 = false;
                Application app = ApplicationManager.getApplication();
                if (!app.isHeadlessEnvironment() && !app.isUnitTestMode() && it.isInitialized()) {
                    ComponentStoreImplKt.access$notifyUnknownMacros(this, it, componentName);
                }
            }
        }
        return componentName;
    }

    @Nullable
    public Object save(boolean bl, @NotNull Continuation<? super Unit> $completion) {
        return ComponentStoreImpl.save$suspendImpl(this, bl, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object save$suspendImpl(ComponentStoreImpl this, boolean forceSavingAllSettings, Continuation $completion) {
        if (!($completion instanceof save.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ComponentStoreImpl this$0;
                Object L$0;
                Object L$1;
                boolean Z$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ComponentStoreImpl.save$suspendImpl(this.this$0, false, (Continuation)this);
                }
                {
                    this.this$0 = componentStoreImpl;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                result = new SaveResult();
                $continuation.L$0 = this;
                $continuation.Z$0 = forceSavingAllSettings;
                $continuation.L$1 = result;
                $continuation.label = 1;
                v0 = this.doSave$intellij_platform_configurationStore_impl(result, forceSavingAllSettings, (Continuation<? super Unit>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                result = (SaveResult)$continuation.L$1;
                forceSavingAllSettings = $continuation.Z$0;
                this = (ComponentStoreImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                result.throwIfErrored();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public abstract Object doSave$intellij_platform_configurationStore_impl(@NotNull SaveResult var1, boolean var2, @NotNull Continuation<? super Unit> var3);

    @Nullable
    public final <T> Object withEdtContext$intellij_platform_configurationStore_impl(@NotNull Function1<? super Continuation<? super T>, ? extends Object> task2, @NotNull Continuation<? super T> $completion) {
        int $i$f$withEdtContext$intellij_platform_configurationStore_impl = 0;
        ComponentManager disposable$iv = this.getStorageManager().getComponentManager();
        boolean $i$f$withEdtContext = false;
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)EdtPoolDispatcherKt.getStoreEdtCoroutineDispatcher()), (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(disposable$iv, task2, null){
            private CoroutineScope p$;
            Object L$0;
            int label;
            final /* synthetic */ ComponentManager $disposable;
            final /* synthetic */ Function1 $task;
            {
                this.$disposable = componentManager;
                this.$task = function1;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$withContext = this.p$;
                        ComponentManager componentManager = this.$disposable;
                        if (componentManager != null ? componentManager.isDisposed() : false) {
                            throw (Throwable)new CancellationException();
                        }
                        this.L$0 = $this$withContext;
                        this.label = 1;
                        Object object2 = this.$task.invoke((Object)((Object)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invokeSuspend$$forInline(@NotNull Object $result) {
                CoroutineScope $this$withContext = this.p$;
                ComponentManager componentManager = this.$disposable;
                if (componentManager != null ? componentManager.isDisposed() : false) {
                    throw (Throwable)new CancellationException();
                }
                InlineMarker.mark((int)0);
                Object object = this.$task.invoke((Object)((Object)this));
                InlineMarker.mark((int)1);
                return object;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> completion) {
                Function2<CoroutineScope, Continuation<? super T>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope cfr_ignored_0 = (CoroutineScope)value2;
                function2.p$ = (CoroutineScope)value2;
                Function2<CoroutineScope, Continuation<? super T>, Object> function22 = function2;
                return function22;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    private final Object withEdtContext$intellij_platform_configurationStore_impl$$forInline(@NotNull Function1 task2, @NotNull Continuation continuation) {
        int $i$f$withEdtContext$intellij_platform_configurationStore_impl = 0;
        ComponentManager disposable$iv = this.getStorageManager().getComponentManager();
        boolean $i$f$withEdtContext = false;
        CoroutineContext coroutineContext = (CoroutineContext)EdtPoolDispatcherKt.getStoreEdtCoroutineDispatcher();
        Function2 function2 = new /* invalid duplicate definition of identical inner class */;
        InlineMarker.mark((int)0);
        Object object = BuildersKt.withContext((CoroutineContext)coroutineContext, (Function2)function2, (Continuation)continuation);
        InlineMarker.mark((int)1);
        return object;
    }

    @Nullable
    public final Object commitComponentsOnEdt$intellij_platform_configurationStore_impl(@NotNull SaveResult saveResult, boolean forceSavingAllSettings, @NotNull SaveSessionProducerManager saveSessionProducerManager, @NotNull Continuation<? super Unit> $completion) {
        ComponentStoreImpl this_$iv = this;
        boolean $i$f$withEdtContext$intellij_platform_configurationStore_impl = false;
        ComponentManager disposable$iv$iv = this_$iv.getStorageManager().getComponentManager();
        boolean $i$f$withEdtContext = false;
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)EdtPoolDispatcherKt.getStoreEdtCoroutineDispatcher()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SaveSessionProducerManager>, Object>(disposable$iv$iv, null, this, forceSavingAllSettings, saveSessionProducerManager, saveResult){
            private CoroutineScope p$;
            Object L$0;
            int label;
            final /* synthetic */ ComponentManager $disposable;
            final /* synthetic */ ComponentStoreImpl this$0;
            final /* synthetic */ boolean $forceSavingAllSettings$inlined;
            final /* synthetic */ SaveSessionProducerManager $saveSessionProducerManager$inlined;
            final /* synthetic */ SaveResult $saveResult$inlined;
            {
                this.$disposable = componentManager;
                this.this$0 = componentStoreImpl;
                this.$forceSavingAllSettings$inlined = bl;
                this.$saveSessionProducerManager$inlined = saveSessionProducerManager;
                this.$saveResult$inlined = saveResult;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$withContext = this.p$;
                        ComponentManager componentManager = this.$disposable;
                        if (componentManager != null ? componentManager.isDisposed() : false) {
                            throw (Throwable)new CancellationException();
                        }
                        this.L$0 = $this$withContext;
                        this.label = 1;
                        Continuation continuation = (Continuation)this;
                        boolean bl = false;
                        SmartList errors = new SmartList();
                        this.this$0.commitComponents$intellij_platform_configurationStore_impl(this.$forceSavingAllSettings$inlined, this.$saveSessionProducerManager$inlined, (List)errors);
                        this.$saveResult$inlined.addErrors((List)errors);
                        SaveSessionProducerManager saveSessionProducerManager = this.$saveSessionProducerManager$inlined;
                        Object object2 = saveSessionProducerManager;
                        if (saveSessionProducerManager != object) return object2;
                        return object;
                    }
                    case 1: {
                        CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> completion) {
                Function2<CoroutineScope, Continuation<? super SaveSessionProducerManager>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope cfr_ignored_0 = (CoroutineScope)value2;
                function2.p$ = (CoroutineScope)value2;
                Function2<CoroutineScope, Continuation<? super SaveSessionProducerManager>, Object> function22 = function2;
                return function22;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void commitComponents$intellij_platform_configurationStore_impl(boolean isForce, @NotNull SaveSessionProducerManager session, @NotNull List<Throwable> errors) {
        if (this.components.isEmpty()) {
            return;
        }
        boolean isUseModificationCount = Registry.is((String)"store.save.use.modificationCount", (boolean)true);
        Object[] names = ArrayUtilRt.toStringArray((Collection)this.components.keySet());
        Arrays.sort(names);
        StringBuilder timeLog = null;
        int nowInSeconds = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        boolean isSaveModLogEnabled = ComponentStoreImplKt.access$getSAVE_MOD_LOG$p().isDebugEnabled() && !ApplicationManager.getApplication().isUnitTestMode();
        for (Object name : names) {
            long start = System.currentTimeMillis();
            try {
                ComponentInfo info;
                if (this.components.get(name) == null) {
                    Intrinsics.throwNpe();
                }
                long currentModificationCount = -1L;
                if (info.getLastSaved() != -1) {
                    if (isForce || nowInSeconds - info.getLastSaved() > ComponentStoreImplKt.access$getNOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD$p()) {
                        info.setLastSaved(nowInSeconds);
                    } else {
                        if (!isSaveModLogEnabled) continue;
                        ComponentStoreImplKt.access$getSAVE_MOD_LOG$p().debug("Skip " + (String)name + ": was already saved in last " + TimeUnit.SECONDS.toMinutes(ComponentStoreImplKt.access$getNOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT$p()) + " minutes" + " (lastSaved " + info.getLastSaved() + ", now: " + nowInSeconds + ')');
                        continue;
                    }
                }
                boolean modificationCountChanged = false;
                if (info.isModificationTrackingSupported()) {
                    currentModificationCount = info.getCurrentModificationCount();
                    if (currentModificationCount == info.getLastModificationCount()) {
                        Logger $this$debug$iv = ComponentStoreImplKt.access$getSAVE_MOD_LOG$p();
                        Exception e$iv = null;
                        boolean $i$f$debug = false;
                        if ($this$debug$iv.isDebugEnabled()) {
                            Logger logger = $this$debug$iv;
                            boolean bl = false;
                            String string = (isUseModificationCount ? "Skip " : "") + (String)name + ": modificationCount " + currentModificationCount + " equals to last saved";
                            logger.debug(string, (Throwable)e$iv);
                        }
                        if (isUseModificationCount) {
                            continue;
                        }
                    } else {
                        modificationCountChanged = true;
                    }
                }
                this.commitComponent(session, info, (String)name, modificationCountChanged);
                info.updateModificationCount(currentModificationCount);
            }
            catch (Throwable e) {
                errors.add(new Exception("Cannot get " + (String)name + " component state", e));
            }
            long duration = System.currentTimeMillis() - start;
            if (duration <= (long)10) continue;
            if (timeLog == null) {
                timeLog = new StringBuilder("Saving " + this.toString());
            } else {
                timeLog.append(", ");
            }
            timeLog.append((String)name).append(" took ").append(duration).append(" ms");
        }
        if (timeLog != null) {
            ComponentStoreImplKt.getLOG().info(timeLog.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveComponent(@NotNull PersistentStateComponent<?> component) {
        State stateSpec = StoreUtilKt.getStateSpec(component);
        Logger $this$debug$iv = ComponentStoreImplKt.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "saveComponent is called for " + stateSpec.name();
            logger.debug(string, (Throwable)e$iv);
        }
        SaveSessionProducerManager saveManager = this.createSaveSessionProducerManager();
        this.commitComponent(saveManager, new ComponentInfoImpl(component, stateSpec), null, false);
        String absolutePath = ((Object)Paths.get(this.getStorageManager().expandMacros(StateStorageManagerImplKt.getPath(ComponentStoreImplKt.access$findNonDeprecated(this.getStorageSpecs(component, stateSpec, StateStorageOperation.WRITE)))), new String[0]).toAbsolutePath()).toString();
        Disposable $this$use$iv = Disposer.newDisposable();
        boolean $i$f$use = false;
        try {
            Disposable it = $this$use$iv;
            boolean bl = false;
            VfsRootAccess.allowRootAccess((Disposable)it, (String[])new String[]{absolutePath});
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, absolutePath, saveManager, stateSpec){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ String $absolutePath$inlined;
                final /* synthetic */ SaveSessionProducerManager $saveManager$inlined;
                final /* synthetic */ State $stateSpec$inlined;
                {
                    this.$absolutePath$inlined = string;
                    this.$saveManager$inlined = saveSessionProducerManager;
                    this.$stateSpec$inlined = state;
                    super(2, continuation);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$runBlocking = this.p$;
                            this.L$0 = $this$runBlocking;
                            this.label = 1;
                            v0 = this.$saveManager$inlined.save((Continuation<? super SaveResult>)this);
                            if (v0 == var2_2) {
                                var4_5 = var2_2;
                                return var4_5;
                            }
                            ** GOTO lbl17
                        }
                        case 1: {
                            $this$runBlocking = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            saveResult = (SaveResult)v0;
                            saveResult.throwIfErrored();
                            if (!saveResult.isChanged()) {
                                ComponentStoreImplKt.getLOG().info("saveApplicationComponent is called for " + this.$stateSpec$inlined.name() + " but nothing to save");
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope cfr_ignored_0 = (CoroutineScope)value2;
                    function2.p$ = (CoroutineScope)value2;
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                    return function22;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if ($this$use$iv != null) {
                Disposer.dispose((Disposable)$this$use$iv);
            }
        }
    }

    @NotNull
    public SaveSessionProducerManager createSaveSessionProducerManager() {
        return new SaveSessionProducerManager();
    }

    private final void commitComponent(SaveSessionProducerManager session, ComponentInfo info, String componentName, boolean modificationCountChanged) {
        Object object;
        String effectiveComponentName;
        Object component = info.getComponent();
        if (component instanceof JDOMExternalizable) {
            String string = componentName;
            if (string == null) {
                string = ComponentStoreImplKt.access$getComponentName(component);
            }
            String effectiveComponentName2 = string;
            StateStorage stateStorage = this.getStorageManager().getOldStorage(component, effectiveComponentName2, StateStorageOperation.WRITE);
            if (stateStorage != null) {
                StateStorage stateStorage2 = stateStorage;
                boolean bl = false;
                boolean bl2 = false;
                StateStorage it = stateStorage2;
                boolean bl3 = false;
                SaveSessionProducer saveSessionProducer = session.getProducer(it);
                if (saveSessionProducer != null) {
                    saveSessionProducer.setState(component, effectiveComponentName2, component);
                }
            }
            return;
        }
        Object state = null;
        boolean stateRequested = false;
        State state2 = info.getStateSpec();
        if (state2 == null) {
            Intrinsics.throwNpe();
        }
        State stateSpec = state2;
        String string = componentName;
        if (string == null) {
            string = effectiveComponentName = stateSpec.name();
        }
        if (!((object = component) instanceof StateStorageChooserEx)) {
            object = null;
        }
        StateStorageChooserEx stateStorageChooser = (StateStorageChooserEx)object;
        Object object2 = component;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.PersistentStateComponent<kotlin.Any>");
        }
        List<Storage> storageSpecs = this.getStorageSpecs((PersistentStateComponent)object2, stateSpec, StateStorageOperation.WRITE);
        for (Storage storageSpec : storageSpecs) {
            SaveSessionProducer sessionProducer;
            StateStorageChooserEx.Resolution resolution;
            StateStorageChooserEx.Resolution resolution2 = resolution = stateStorageChooser == null ? StateStorageChooserEx.Resolution.DO : stateStorageChooser.getResolution(storageSpec, StateStorageOperation.WRITE);
            if (resolution == StateStorageChooserEx.Resolution.SKIP) continue;
            StateStorage storage2 = this.getStorageManager().getStateStorage(storageSpec);
            if (resolution == StateStorageChooserEx.Resolution.DO && (resolution = storage2.getResolution((PersistentStateComponent)component, StateStorageOperation.WRITE)) == StateStorageChooserEx.Resolution.SKIP) continue;
            if (session.getProducer(storage2) == null) {
                continue;
            }
            if (storageSpec.deprecated() || resolution == StateStorageChooserEx.Resolution.CLEAR) {
                sessionProducer.setState(component, effectiveComponentName, null);
                continue;
            }
            if (!stateRequested) {
                stateRequested = true;
                Object object3 = info.getComponent();
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.PersistentStateComponent<*>");
                }
                state = ((PersistentStateComponent)object3).getState();
            }
            if (modificationCountChanged && state != null && this.isReportStatisticAllowed(stateSpec)) {
                Logger $this$runAndLogException$iv = ComponentStoreImplKt.getLOG();
                boolean $i$f$runAndLogException = false;
                try {
                    boolean bl = false;
                    FeatureUsageSettingsEvents.INSTANCE.logConfigurationChanged(effectiveComponentName, state, this.getProject());
                }
                catch (ProcessCanceledException e$iv) {
                    throw (Throwable)e$iv;
                }
                catch (CancellationException e$iv) {
                    throw (Throwable)e$iv;
                }
                catch (Throwable e$iv) {
                    $this$runAndLogException$iv.error(e$iv);
                }
            }
            this.setStateToSaveSessionProducer(state, info, effectiveComponentName, sessionProducer);
        }
    }

    protected void setStateToSaveSessionProducer(@Nullable Object state, @NotNull ComponentInfo info, @NotNull String effectiveComponentName, @NotNull SaveSessionProducer sessionProducer) {
        sessionProducer.setState(info.getComponent(), effectiveComponentName, state);
    }

    private final String initJdomExternalizable(JDOMExternalizable component, String componentName) {
        StateStorage stateStorage;
        this.doAddComponent(componentName, component, null, null);
        if (this.getLoadPolicy() != StateLoadPolicy.LOAD) {
            return null;
        }
        try {
            Element element = this.getDefaultState(component, componentName, Element.class);
            if (element != null) {
                Element element2 = element;
                boolean bl = false;
                boolean bl2 = false;
                Element it = element2;
                boolean bl3 = false;
                component.readExternal(it);
            }
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error(e);
        }
        if ((stateStorage = this.getStorageManager().getOldStorage((Object)component, componentName, StateStorageOperation.READ)) == null || (stateStorage = (Element)stateStorage.getState((Object)component, componentName, Element.class, null, false)) == null) {
            return null;
        }
        StateStorage element = stateStorage;
        try {
            component.readExternal((Element)element);
        }
        catch (InvalidDataException e) {
            ComponentStoreImplKt.getLOG().error((Throwable)e);
            return null;
        }
        return componentName;
    }

    private final ComponentInfo doAddComponent(String name, Object component, State stateSpec, ServiceDescriptor serviceDescriptor) {
        ComponentInfo newInfo = ComponentInfoKt.createComponentInfo(component, stateSpec, serviceDescriptor);
        ComponentInfo existing = this.components.put(name, newInfo);
        if (existing != null && existing.getComponent() != component) {
            this.components.put(name, existing);
            ComponentStoreImplKt.getLOG().error("Conflicting component name '" + name + "': " + existing.getComponent().getClass() + " and " + component.getClass() + " (componentManager=" + this.getStorageManager().getComponentManager() + ')');
            return existing;
        }
        return newInfo;
    }

    private final boolean initComponent(ComponentInfo info, Set<? extends StateStorage> changedStorages, ThreeState reloadData) {
        Object object = info.getComponent();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.PersistentStateComponent<kotlin.Any>");
        }
        PersistentStateComponent component = (PersistentStateComponent)object;
        if (this.getLoadPolicy() == StateLoadPolicy.NOT_LOAD) {
            State state = info.getStateSpec();
            if (state != null) {
                if (!state.allowLoadInTests()) {
                    component.noStateLoaded();
                    return false;
                }
            }
        }
        if (info.getStateSpec() == null) {
            String string = info.getConfigurationSchemaKey();
            if (string == null) {
                throw (Throwable)new UnsupportedOperationException("configurationSchemaKey must be specified for " + component.getClass().getName());
            }
            String configurationSchemaKey = string;
            return this.initComponentWithoutStateSpec((PersistentStateComponent<Object>)component, configurationSchemaKey);
        }
        return this.doInitComponent(info, (PersistentStateComponent<Object>)component, changedStorages, reloadData);
    }

    protected final boolean initComponentWithoutStateSpec(@NotNull PersistentStateComponent<Object> component, @NotNull String configurationSchemaKey) {
        Object state;
        StateStorage storage2;
        if (this.getLoadPolicy() != StateLoadPolicy.LOAD) {
            component.noStateLoaded();
            return false;
        }
        Class stateClass = ComponentSerializationUtil.getStateClass(component.getClass());
        StateStorage stateStorage = storage2 = this.getReadOnlyStorage(component.getClass(), stateClass, configurationSchemaKey);
        Object object = state = stateStorage != null ? stateStorage.getState(component, "", stateClass, null, false) : null;
        if (state == null) {
            component.noStateLoaded();
        } else {
            component.loadState(state);
        }
        return true;
    }

    @Nullable
    protected StateStorage getReadOnlyStorage(@NotNull Class<Object> componentClass, @NotNull Class<Object> stateClass, @NotNull String configurationSchemaKey) {
        return null;
    }

    private final boolean doInitComponent(ComponentInfo info, PersistentStateComponent<Object> component, Set<? extends StateStorage> changedStorages, ThreeState reloadData) {
        Object defaultState;
        block23: {
            PersistentStateComponent<Object> persistentStateComponent;
            String name;
            State stateSpec;
            Class<Object> stateClass;
            block22: {
                Class<Object> clazz;
                PersistentStateComponent<Object> persistentStateComponent2 = component;
                if (persistentStateComponent2 instanceof PersistenceStateAdapter) {
                    clazz = ((PersistenceStateAdapter)component).getComponent().getClass();
                    if (clazz == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Any>");
                    }
                } else {
                    clazz = ComponentSerializationUtil.getStateClass(component.getClass());
                }
                stateClass = clazz;
                State state = info.getStateSpec();
                if (state == null) {
                    Intrinsics.throwNpe();
                }
                stateSpec = state;
                name = stateSpec.name();
                Object s = defaultState = stateSpec.defaultStateAsResource() ? (Object)this.getDefaultState(component, name, stateClass) : null;
                if (this.getLoadPolicy() == StateLoadPolicy.LOAD) break block22;
                State state2 = info.getStateSpec();
                if (state2 == null) break block23;
                if (!state2.allowLoadInTests()) break block23;
            }
            if (!((persistentStateComponent = component) instanceof StateStorageChooserEx)) {
                persistentStateComponent = null;
            }
            StateStorageChooserEx storageChooser = (StateStorageChooserEx)persistentStateComponent;
            for (Storage storageSpec : this.getStorageSpecs(component, stateSpec, StateStorageOperation.READ)) {
                boolean bl;
                StateStorageChooserEx stateStorageChooserEx = storageChooser;
                if ((stateStorageChooserEx != null ? stateStorageChooserEx.getResolution(storageSpec, StateStorageOperation.READ) : null) == StateStorageChooserEx.Resolution.SKIP) continue;
                StateStorage storage2 = this.getStorageManager().getStateStorage(storageSpec);
                if (reloadData == ThreeState.UNSURE) {
                    Set<? extends StateStorage> set = changedStorages;
                    if (set == null) {
                        Intrinsics.throwNpe();
                    }
                    bl = this.isStorageChanged(set, storage2);
                } else {
                    bl = reloadData.toBoolean();
                }
                boolean isReloadDataForStorage = bl;
                StateGetter<Object> stateGetter = this.doCreateStateGetter(isReloadDataForStorage, storage2, info, name, stateClass);
                Object state = stateGetter.getState(defaultState);
                if (state == null) {
                    if (changedStorages != null && this.isStorageChanged(changedStorages, storage2)) {
                        Object object = DefaultStateSerializerKt.deserializeState((Element)new Element("state"), stateClass, null);
                        if (object == null) {
                            Intrinsics.throwNpe();
                        }
                        state = object;
                    } else {
                        if (!this.isReportStatisticAllowed(stateSpec) || storageSpec.deprecated()) continue;
                        FeatureUsageSettingsEvents.INSTANCE.logDefaultConfigurationState(name, stateClass, this.getProject());
                        continue;
                    }
                }
                component.loadState(state);
                Object stateAfterLoad = stateGetter.archiveState();
                if (this.isReportStatisticAllowed(stateSpec)) {
                    Logger $this$runAndLogException$iv = ComponentStoreImplKt.getLOG();
                    boolean $i$f$runAndLogException = false;
                    try {
                        boolean bl2 = false;
                        Object object = stateAfterLoad;
                        if (object == null) {
                            object = state;
                        }
                        FeatureUsageSettingsEvents.INSTANCE.logConfigurationState(name, object, this.getProject());
                    }
                    catch (ProcessCanceledException e$iv) {
                        throw (Throwable)e$iv;
                    }
                    catch (CancellationException e$iv) {
                        throw (Throwable)e$iv;
                    }
                    catch (Throwable e$iv) {
                        $this$runAndLogException$iv.error(e$iv);
                    }
                }
                info.updateModificationCount(info.getCurrentModificationCount());
                return true;
            }
        }
        if (defaultState == null) {
            component.noStateLoaded();
        } else {
            component.loadState(defaultState);
            info.updateModificationCount(info.getCurrentModificationCount());
        }
        return true;
    }

    protected boolean isReportStatisticAllowed(@NotNull State stateSpec) {
        return stateSpec.reportStatistic();
    }

    private final boolean isStorageChanged(Set<? extends StateStorage> changedStorages, StateStorage storage2) {
        return changedStorages.contains(storage2) || storage2 instanceof ExternalStorageWithInternalPart && changedStorages.contains(((ExternalStorageWithInternalPart)storage2).getInternalStorage());
    }

    @NotNull
    protected StateGetter<Object> doCreateStateGetter(boolean reloadData, @NotNull StateStorage storage2, @NotNull ComponentInfo info, @NotNull String name, @NotNull Class<Object> stateClass) {
        State state = info.getStateSpec();
        if (state == null) {
            Intrinsics.throwNpe();
        }
        boolean isUseLoadedStateAsExisting = state.useLoadedStateAsExisting() && this.isUseLoadedStateAsExisting(storage2);
        Object object = info.getComponent();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.PersistentStateComponent<kotlin.Any>");
        }
        return StorageBaseExKt.createStateGetter(isUseLoadedStateAsExisting, storage2, (PersistentStateComponent)object, name, stateClass, reloadData);
    }

    protected boolean isUseLoadedStateAsExisting(@NotNull StateStorage storage2) {
        StateStorage stateStorage = storage2;
        if (!(stateStorage instanceof XmlElementStorage)) {
            stateStorage = null;
        }
        XmlElementStorage xmlElementStorage = (XmlElementStorage)stateStorage;
        return (xmlElementStorage != null ? xmlElementStorage.getRoamingType() : null) != RoamingType.DISABLED && SystemProperties.getBooleanProperty((String)"use.loaded.state.as.existing", (boolean)true);
    }

    @Nullable
    protected PathMacroManager getPathMacroManagerForDefaults() {
        return null;
    }

    private final <T> T getDefaultState(Object component, String componentName, Class<T> stateClass) {
        URL uRL = DecodeDefaultsUtil.getDefaults((Object)component, (String)componentName);
        if (uRL == null) {
            return null;
        }
        URL url = uRL;
        try {
            Element element = JDOMUtil.load((URL)url);
            PathMacroManager pathMacroManager = this.getPathMacroManagerForDefaults();
            if (pathMacroManager != null) {
                pathMacroManager.expandPaths(element);
            }
            return (T)DefaultStateSerializerKt.deserializeState((Element)element, stateClass, null);
        }
        catch (Throwable e) {
            throw (Throwable)new IOException("Error loading default state from " + url, e);
        }
    }

    @NotNull
    protected <T> List<Storage> getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        Object[] storages = stateSpec.storages();
        if (storages.length == 1 || component instanceof StateStorageChooserEx) {
            return ArraysKt.toList((Object[])storages);
        }
        Object[] objectArray = storages;
        boolean bl = false;
        if (objectArray.length == 0) {
            if (stateSpec.defaultStateAsResource()) {
                return CollectionsKt.emptyList();
            }
            throw (Throwable)((Object)new AssertionError((Object)"No storage specified"));
        }
        return ComponentStoreImplKt.sortByDeprecated((Storage[])storages);
    }

    public final boolean isReloadPossible(@NotNull Set<String> componentNames) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = componentNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!this.isNotReloadable(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    private final boolean isNotReloadable(String name) {
        Object object = this.components.get(name);
        if (object == null || (object = ((ComponentInfo)object).getComponent()) == null) {
            return false;
        }
        Object component = object;
        return !(component instanceof PersistentStateComponent) || !StoreUtilKt.getStateSpec((PersistentStateComponent)((PersistentStateComponent)component)).reloadable();
    }

    @NotNull
    public final Collection<String> getNotReloadableComponents(@NotNull Collection<String> componentNames) {
        Set notReloadableComponents = null;
        for (String componentName : componentNames) {
            if (!this.isNotReloadable(componentName)) continue;
            if (notReloadableComponents == null) {
                notReloadableComponents = new LinkedHashSet();
            }
            notReloadableComponents.add(componentName);
        }
        Set set = notReloadableComponents;
        return set != null ? (Collection)set : (Collection)SetsKt.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reloadStates(@NotNull Set<String> componentNames, @NotNull MessageBus messageBus) {
        boolean $i$f$runBatchUpdate = false;
        BatchUpdateListener publisher$iv = (BatchUpdateListener)messageBus.syncPublisher(BatchUpdateListener.TOPIC);
        publisher$iv.onBatchUpdateStarted();
        try {
            boolean bl = false;
            ComponentStoreImpl.reinitComponents$default(this, componentNames, null, null, 6, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            publisher$iv.onBatchUpdateFinished();
        }
    }

    public final void reloadState(@NotNull Class<? extends PersistentStateComponent<?>> componentClass) {
        block2: {
            State stateSpec = StoreUtilKt.getStateSpecOrError(componentClass);
            ComponentInfo componentInfo = this.components.get(stateSpec.name());
            if (componentInfo == null) {
                return;
            }
            ComponentInfo info = componentInfo;
            Object object = info.getComponent();
            if (!(object instanceof PersistentStateComponent)) {
                object = null;
            }
            PersistentStateComponent persistentStateComponent = (PersistentStateComponent)object;
            if (persistentStateComponent == null) break block2;
            PersistentStateComponent persistentStateComponent2 = persistentStateComponent;
            boolean bl = false;
            boolean bl2 = false;
            PersistentStateComponent it = persistentStateComponent2;
            boolean bl3 = false;
            this.initComponent(info, SetsKt.emptySet(), ThreeState.YES);
        }
    }

    private final boolean reloadState(String componentName, Set<? extends StateStorage> changedStorages) {
        ComponentInfo componentInfo = this.components.get(componentName);
        if (componentInfo == null) {
            return false;
        }
        ComponentInfo info = componentInfo;
        if (!(info.getComponent() instanceof PersistentStateComponent)) {
            return false;
        }
        boolean isChangedStoragesEmpty = changedStorages.isEmpty();
        this.initComponent(info, isChangedStoragesEmpty ? null : changedStorages, ThreeState.UNSURE);
        return true;
    }

    @Nullable
    public Collection<String> reload(@NotNull Set<? extends StateStorage> changedStorages) {
        if (changedStorages.isEmpty()) {
            return SetsKt.emptySet();
        }
        HashSet componentNames = new HashSet();
        for (StateStorage stateStorage : changedStorages) {
            Logger $this$runAndLogException$iv = ComponentStoreImplKt.getLOG();
            boolean $i$f$runAndLogException = false;
            try {
                boolean bl = false;
                stateStorage.analyzeExternalChangesAndUpdateIfNeeded((Set)componentNames);
            }
            catch (ProcessCanceledException e$iv) {
                throw (Throwable)e$iv;
            }
            catch (CancellationException e$iv) {
                throw (Throwable)e$iv;
            }
            catch (Throwable e$iv) {
                $this$runAndLogException$iv.error(e$iv);
            }
        }
        if (componentNames.isEmpty()) {
            return SetsKt.emptySet();
        }
        Collection<String> collection = this.getNotReloadableComponents(componentNames);
        this.reinitComponents(componentNames, changedStorages, collection);
        return collection.isEmpty() ? null : collection;
    }

    public final void reinitComponents(@NotNull Set<String> componentNames, @NotNull Set<? extends StateStorage> changedStorages, @NotNull Collection<String> notReloadableComponents) {
        for (String componentName : componentNames) {
            if (notReloadableComponents.contains(componentName)) continue;
            this.reloadState(componentName, changedStorages);
        }
    }

    public static /* synthetic */ void reinitComponents$default(ComponentStoreImpl componentStoreImpl, Set set, Set set2, Collection collection, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reinitComponents");
        }
        if ((n & 2) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n & 4) != 0) {
            collection = SetsKt.emptySet();
        }
        componentStoreImpl.reinitComponents(set, set2, collection);
    }

    public void removeComponent(@NotNull String name) {
        this.components.remove(name);
    }

    public void release() {
        this.components.clear();
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.getStorageManager().getComponentManager());
    }
}

