/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.util.SmartList;
import com.intellij.util.xml.stubs.DomElementTypeHolder;
import com.intellij.util.xml.stubs.DomStub;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementStub
extends DomStub {
    private final List<Stub> myChildren = new SmartList();
    private final int myIndex;
    private final boolean myCustom;
    @Nullable
    private final String myElementClass;
    private final String myValue;

    public ElementStub(@Nullable ElementStub parent, @NotNull String name, @Nullable String namespace, int index, boolean custom, @Nullable String elementClass, @NotNull String value) {
        super(parent, name, namespace);
        this.myIndex = index;
        this.myCustom = custom;
        this.myElementClass = elementClass;
        this.myValue = value;
    }

    void addChild(Stub child) {
        this.myChildren.add(child);
    }

    @NotNull
    public List<? extends Stub> getChildrenStubs() {
        return this.myChildren;
    }

    public ObjectStubSerializer<?, ?> getStubType() {
        return DomElementTypeHolder.ElementStubSerializer;
    }

    public String toString() {
        String key = this.getNamespaceKey();
        return (StringUtil.isEmpty((String)key) ? this.getName() : key + ":" + this.getName()) + (StringUtil.isEmpty((String)this.getValue()) ? "" : ":" + this.getValue());
    }

    @Override
    public boolean isCustom() {
        return this.myCustom;
    }

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    @Nullable
    String getElementClass() {
        return this.myElementClass;
    }

    @NotNull
    public String getValue() {
        return this.myValue;
    }
}

