/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.DomSupportEnabled;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildInvocationHandler;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomFileMetaData;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.IndexedElementInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.util.xml.stubs.ElementStub;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.xml.util.IncludedXmlTag;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DomCreator {
    DomCreator() {
    }

    @Nullable
    static DomInvocationHandler createTagHandler(@NotNull XmlTag tag) {
        PsiElement candidate = PhysicalDomParentStrategy.getParentTagCandidate((XmlElement)tag);
        if (!(candidate instanceof XmlTag)) {
            return DomCreator.createRootHandler(tag);
        }
        XmlTag parentTag = (XmlTag)candidate;
        DomInvocationHandler parent = DomCreator.getParentDom(parentTag);
        if (parent == null) {
            return null;
        }
        String localName = tag.getLocalName();
        if (StringUtil.isEmpty((String)localName)) {
            return null;
        }
        DomGenericInfoEx info = parent.getGenericInfo();
        DomFixedChildDescription fixedDescription = (DomFixedChildDescription)DomCreator.findChildrenDescription(info.getFixedChildrenDescriptions(), tag, parent);
        if (fixedDescription != null) {
            return DomCreator.createIndexedHandler(parent, localName, tag.getNamespace(), fixedDescription, tag);
        }
        DomCollectionChildDescription collectionDescription = (DomCollectionChildDescription)DomCreator.findChildrenDescription(info.getCollectionChildrenDescriptions(), tag, parent);
        if (collectionDescription != null) {
            return DomCreator.createCollectionHandler(tag, collectionDescription, parent, parentTag);
        }
        return DomCreator.createCustomHandler(tag, parent, localName, info);
    }

    @Nullable
    private static DomInvocationHandler createRootHandler(XmlTag xmlTag) {
        DomRootInvocationHandler handler;
        DomFileElement element;
        PsiFile file = xmlTag.getContainingFile();
        DomFileElement domFileElement = element = file instanceof XmlFile ? DomManagerImpl.getDomManager(file.getProject()).getFileElement((XmlFile)file) : null;
        if (element != null && (handler = element.getRootHandler()).getXmlTag() == xmlTag) {
            return handler;
        }
        return null;
    }

    @Nullable
    private static DomInvocationHandler createIndexedHandler(DomInvocationHandler parent, String localName, String namespace, DomFixedChildDescription description, XmlTag tag) {
        int totalCount = description.getCount();
        int index = 0;
        XmlTag current = tag;
        while ((current = current.getPrevSibling()) != null) {
            XmlTag xmlTag;
            if (!(current instanceof XmlTag) || !localName.equals((xmlTag = current).getLocalName()) || !namespace.equals(xmlTag.getNamespace()) || ++index < totalCount) continue;
            return null;
        }
        DomManagerImpl myDomManager = parent.getManager();
        return new IndexedElementInvocationHandler(parent.createEvaluatedXmlName(description.getXmlName()), (FixedChildDescriptionImpl)description, index, new PhysicalDomParentStrategy((XmlElement)tag, myDomManager), myDomManager, null);
    }

    @NotNull
    private static CollectionElementInvocationHandler createCollectionHandler(XmlTag tag, DomCollectionChildDescription description, DomInvocationHandler parent, XmlTag parentTag) {
        DomStub parentStub = parent.getStub();
        if (parentStub != null) {
            int index = JBIterable.of((Object[])parentTag.findSubTags(tag.getName(), tag.getNamespace())).filter(t -> !(t instanceof IncludedXmlTag)).indexOf(t -> t == tag);
            ElementStub stub = parentStub.getElementStub(tag.getLocalName(), index);
            if (stub != null) {
                XmlName name = description.getXmlName();
                EvaluatedXmlNameImpl evaluatedXmlName = EvaluatedXmlNameImpl.createEvaluatedXmlName((XmlName)name, (String)name.getNamespaceKey(), (boolean)true);
                return new CollectionElementInvocationHandler((EvaluatedXmlName)evaluatedXmlName, (AbstractDomChildDescriptionImpl)description, parent.getManager(), stub);
            }
        }
        return new CollectionElementInvocationHandler(description.getType(), tag, (AbstractCollectionChildDescription)description, parent, null);
    }

    @Nullable
    private static DomInvocationHandler createCustomHandler(XmlTag tag, DomInvocationHandler parent, String localName, DomGenericInfoEx info) {
        List customs = info.getCustomNameChildrenDescription();
        if (customs.isEmpty()) {
            return null;
        }
        XmlFile file = parent.getFile();
        for (DomFixedChildDescription description : info.getFixedChildrenDescriptions()) {
            XmlName xmlName = description.getXmlName();
            if (!localName.equals(xmlName.getLocalName()) || !DomImplUtil.isNameSuitable(xmlName, tag, parent, file)) continue;
            return null;
        }
        for (DomFixedChildDescription description : customs) {
            if (description.getTagNameDescriptor() == null) continue;
            AbstractCollectionChildDescription desc = (AbstractCollectionChildDescription)description;
            Type type = description.getType();
            return new CollectionElementInvocationHandler(type, tag, desc, parent, null);
        }
        return null;
    }

    @Nullable
    static DomFileElementImpl<?> createFileElement(XmlFile xmlFile) {
        ObjectStubTree stubTree;
        VirtualFile file = xmlFile.getVirtualFile();
        if (!(xmlFile.getFileType() instanceof DomSupportEnabled) || file != null && ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file)) {
            IdempotenceChecker.logTrace((String)"DOM unsupported");
            return null;
        }
        DomFileDescription<?> description = DomCreator.findFileDescription(xmlFile);
        if (IdempotenceChecker.isLoggingEnabled()) {
            IdempotenceChecker.logTrace((String)("DOM file description: " + description));
        }
        if (description == null) {
            return null;
        }
        XmlName xmlName = DomImplUtil.createXmlName(description.getRootTagName(), description.getRootElementClass(), null);
        assert (xmlName != null);
        EvaluatedXmlNameImpl rootTagName1 = EvaluatedXmlNameImpl.createEvaluatedXmlName((XmlName)xmlName, (String)xmlName.getNamespaceKey(), (boolean)false);
        FileStub stub = null;
        DomFileMetaData meta = DomApplicationComponent.getInstance().findMeta(description);
        if (meta != null && meta.hasStubs() && file instanceof VirtualFileWithId && !DomCreator.isFileParsed(xmlFile) && FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() == null && (stubTree = StubTreeLoader.getInstance().readFromVFile(xmlFile.getProject(), file)) != null) {
            stub = (FileStub)stubTree.getRoot();
        }
        DomFileElementImpl element = new DomFileElementImpl(xmlFile, rootTagName1, description, stub);
        xmlFile.putUserData(DomManagerImpl.CACHED_FILE_ELEMENT, new WeakReference(element));
        return element;
    }

    private static boolean isFileParsed(XmlFile myXmlFile) {
        return myXmlFile instanceof PsiFileEx && ((PsiFileEx)myXmlFile).isContentsLoaded();
    }

    @Nullable
    private static DomFileDescription<?> findFileDescription(XmlFile file) {
        DomFileDescription mockDescription = (DomFileDescription)file.getUserData(DomManagerImpl.MOCK_DESCRIPTION);
        if (mockDescription != null) {
            return mockDescription;
        }
        Project project = file.getProject();
        XmlFile originalFile = (XmlFile)file.getOriginalFile();
        DomManagerImpl domManager = DomManagerImpl.getDomManager(project);
        if (!originalFile.equals(file)) {
            DomFileElement element = domManager.getFileElement(originalFile);
            if (IdempotenceChecker.isLoggingEnabled()) {
                IdempotenceChecker.logTrace((String)("Copy DOM from original file: " + element));
            }
            return element == null ? null : element.getFileDescription();
        }
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        Condition condition = d -> d.isMyFile(file, module);
        String rootTagLocalName = DomService.getInstance().getXmlFileHeader(file).getRootTagLocalName();
        DomFileDescription description = (DomFileDescription)ContainerUtil.find(domManager.getFileDescriptions(rootTagLocalName), (Condition)condition);
        return description != null ? description : (DomFileDescription)ContainerUtil.find(domManager.getAcceptingOtherRootTagNameDescriptions(), (Condition)condition);
    }

    @Nullable
    static DomInvocationHandler getParentDom(@NotNull XmlTag tag) {
        LinkedHashSet<XmlTag> allParents = new LinkedHashSet<XmlTag>();
        XmlTag each = tag;
        while (each instanceof XmlTag && allParents.add(each)) {
            each = PhysicalDomParentStrategy.getParentTagCandidate((XmlElement)each);
        }
        ArrayList list = new ArrayList(allParents);
        Collections.reverse(list);
        DomManagerImpl manager = DomManagerImpl.getDomManager(tag.getProject());
        for (XmlTag xmlTag : list) {
            manager.getDomHandler((XmlElement)xmlTag);
        }
        return manager.getDomHandler((XmlElement)tag);
    }

    @Nullable
    private static <T extends DomChildrenDescription> T findChildrenDescription(List<T> descriptions, XmlTag tag, DomInvocationHandler parent) {
        XmlFile file = parent.getFile();
        int size = descriptions.size();
        for (int i = 0; i < size; ++i) {
            DomChildrenDescription description = (DomChildrenDescription)descriptions.get(i);
            if (!DomImplUtil.isNameSuitable(description.getXmlName(), tag, parent, file)) continue;
            return (T)description;
        }
        return null;
    }

    @Nullable
    static AttributeChildInvocationHandler createAttributeHandler(@NotNull XmlAttribute attribute) {
        DomInvocationHandler handler;
        XmlTag tag = PhysicalDomParentStrategy.getParentTag((XmlElement)attribute);
        DomInvocationHandler domInvocationHandler = handler = tag == null ? null : DomCreator.getParentDom(tag);
        if (handler == null) {
            return null;
        }
        String localName = attribute.getLocalName();
        Ref result = Ref.create(null);
        handler.getGenericInfo().processAttributeChildrenDescriptions((Processor<? super AttributeChildDescriptionImpl>)((Processor)description -> {
            EvaluatedXmlName evaluatedXmlName;
            String ns;
            if (description.getXmlName().getLocalName().equals(localName) && ((ns = (evaluatedXmlName = handler.createEvaluatedXmlName(description.getXmlName())).getNamespace((XmlElement)tag, handler.getFile())).equals(tag.getNamespace()) && localName.equals(attribute.getName()) || ns.equals(attribute.getNamespace()))) {
                DomManagerImpl manager = handler.getManager();
                result.set((Object)new AttributeChildInvocationHandler(evaluatedXmlName, (AttributeChildDescriptionImpl)description, manager, new PhysicalDomParentStrategy((XmlElement)attribute, manager), null));
                return false;
            }
            return true;
        }));
        return (AttributeChildInvocationHandler)((Object)result.get());
    }
}

