/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProjectEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.testFramework.UsefulTestCase;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;

public abstract class PlatformLiteFixture
extends UsefulTestCase {
    protected MockProjectEx myProject;

    @NotNull
    public static MockApplication getApplication() {
        return (MockApplication)ApplicationManager.getApplication();
    }

    @NotNull
    public MockApplication initApplication() {
        MockApplication app = new MockApplication(this.getTestRootDisposable());
        ApplicationManager.setApplication((Application)app, () -> FileTypeManager.getInstance(), (Disposable)this.getTestRootDisposable());
        app.registerService(EncodingManager.class, EncodingManagerImpl.class);
        return app;
    }

    @Override
    protected void tearDown() throws Exception {
        this.myProject = null;
        super.tearDown();
    }

    protected <T> void registerExtension(@NotNull ExtensionPointName<T> extensionPointName, @NotNull T extension) {
        this.registerExtension(Extensions.getRootArea(), extensionPointName, extension);
    }

    public <T> void registerExtension(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> name, @NotNull T extension) {
        this.registerExtensionPoint(area, name, extension.getClass());
        area.getExtensionPoint(name.getName()).registerExtension(extension, this.getTestRootDisposable());
    }

    protected <T> void registerExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<T> aClass) {
        this.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, aClass);
    }

    protected <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        if (!area.hasExtensionPoint(extensionPointName)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || (aClass.getModifiers() & 0x400) != 0 ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            ((ExtensionsAreaImpl)area).registerExtensionPoint(extensionPointName, aClass.getName(), kind, this.getTestRootDisposable());
        }
    }

    public static <T> T registerComponentInstance(@NotNull MutablePicoContainer container, @NotNull Class<T> key, @NotNull T implementation) {
        Object old = container.getComponentInstance(key);
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
        return (T)old;
    }

    public static <T> T registerComponentInstance(@NotNull ComponentManager container, @NotNull Class<T> key, @NotNull T implementation) {
        return PlatformLiteFixture.registerComponentInstance((MutablePicoContainer)container.getPicoContainer(), key, implementation);
    }

    protected <T> void registerApplicationService(@NotNull Class<T> aClass, @NotNull T object) {
        PlatformLiteFixture.getApplication().registerService(aClass, object, this.getTestRootDisposable());
    }
}

