/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.project.TestProjectManager;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.ref.DebugReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LeakHunter {
    private static final List<String> MOCKING_SUPPORT_CLASSES = Arrays.asList("org.easymock.internal.MocksBehavior", "org.mockito.internal.stubbing.OngoingStubbingImpl");
    private static final Condition<Object> SHOULD_EXAMINE_VALUE = o -> !MOCKING_SUPPORT_CLASSES.contains(o.getClass().getName());

    public static void checkProjectLeak() {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, project2 -> !project2.isDefault() && !project2.isLight());
    }

    public static void checkNonDefaultProjectLeak() {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, project2 -> !project2.isDefault());
    }

    public static void checkLeak(@NotNull Object root, @NotNull Class<?> suspectClass) throws AssertionError {
        LeakHunter.checkLeak(root, suspectClass, null);
    }

    public static <T> void checkLeak(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak) throws AssertionError {
        LeakHunter.processLeaks(rootsSupplier, suspectClass, isReallyLeak, (leaked, backLink) -> {
            String place = leaked instanceof Project ? TestProjectManager.getCreationPlace((Project)leaked) : "";
            String message = "Found leaked " + leaked.getClass() + ": " + leaked + "; hash: " + System.identityHashCode(leaked) + "; place: " + place + "\n" + backLink;
            System.out.println(message);
            System.out.println(";-----");
            UsefulTestCase.printThreadDump();
            throw new AssertionError((Object)message);
        });
    }

    static <T> void processLeaks(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak, @NotNull PairProcessor<? super T, Object> processor) throws AssertionError {
        if (SwingUtilities.isEventDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
        PersistentEnumeratorBase.clearCacheForTests();
        Runnable runnable = () -> {
            try (AccessToken ignored = ProhibitAWTEvents.start((String)"checking for leaks");){
                DebugReflectionUtil.walkObjects((int)10000, (Map)((Map)rootsSupplier.get()), (Class)suspectClass, SHOULD_EXAMINE_VALUE, (value, backLink) -> {
                    Object leaked = value;
                    if (isReallyLeak == null || isReallyLeak.value(leaked)) {
                        return processor.process(leaked, backLink);
                    }
                    return true;
                });
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            runnable.run();
        } else {
            application.runReadAction(runnable);
        }
    }

    public static <T> void checkLeak(@NotNull Object root, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak) throws AssertionError {
        LeakHunter.checkLeak(() -> Collections.singletonMap(root, "Root object"), suspectClass, isReallyLeak);
    }

    @NotNull
    public static Supplier<Map<Object, String>> allRoots() {
        return () -> {
            ClassLoader classLoader = LeakHunter.class.getClassLoader();
            Vector allLoadedClasses = (Vector)ReflectionUtil.getField(classLoader.getClass(), (Object)classLoader, Vector.class, (String)"classes");
            LaterInvocator.purgeExpiredItems();
            IdentityHashMap<Object, String> result = new IdentityHashMap<Object, String>();
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                result.put(application, "ApplicationManager.getApplication()");
            }
            result.put(Disposer.getTree(), "Disposer.getTree()");
            result.put(IdeEventQueue.getInstance(), "IdeEventQueue.getInstance()");
            result.put(LaterInvocator.getLaterInvocatorEdtQueue(), "LaterInvocator.getLaterInvocatorEdtQueue()");
            result.put(LaterInvocator.getLaterInvocatorWtQueue(), "LaterInvocator.getLaterInvocatorWtQueue()");
            result.put(ThreadTracker.getThreads().values(), "all live threads");
            if (allLoadedClasses != null) {
                result.put(allLoadedClasses, "all loaded classes statics");
            }
            return result;
        };
    }
}

