/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.FixtureRuleKt;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0006H\u0007J:\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\rH\u0007J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0007\u00a8\u0006\u001d"}, d2={"Lcom/intellij/testFramework/HeavyTestHelper;", "", "()V", "createModuleAt", "Lcom/intellij/openapi/module/Module;", "moduleName", "", "project", "Lcom/intellij/openapi/project/Project;", "moduleType", "Lcom/intellij/openapi/module/ModuleType;", "path", "isCreateProjectFileExplicitly", "", "filesToDelete", "", "Ljava/nio/file/Path;", "createTempDirectoryForTempDirTestFixture", "dir", "prefix", "createTestProjectStructure", "Lcom/intellij/openapi/vfs/VirtualFile;", "tempName", "module", "rootPath", "addProjectRoots", "openHeavyTestFixtureProject", "moduleListener", "Lcom/intellij/openapi/project/ModuleListener;", "intellij.platform.testFramework"})
@ApiStatus.Internal
public final class HeavyTestHelper {
    public static final HeavyTestHelper INSTANCE;

    @JvmStatic
    @NotNull
    public static final Project openHeavyTestFixtureProject(@NotNull Path path, @NotNull ModuleListener moduleListener) {
        OpenProjectTask options2 = OpenProjectTask.copy$default((OpenProjectTask)FixtureRuleKt.createTestOpenProjectOptions$default(false, 1, null), (boolean)false, null, (boolean)false, (boolean)false, null, null, (boolean)false, null, null, (int)0, (int)0, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (boolean)false, null, (Function1)((Function1)new Function1<Project, Boolean>(moduleListener){
            final /* synthetic */ ModuleListener $moduleListener;

            public final boolean invoke(@NotNull Project it) {
                it.getMessageBus().simpleConnect().subscribe(ProjectTopics.MODULES, (Object)this.$moduleListener);
                return true;
            }
            {
                this.$moduleListener = moduleListener;
                super(1);
            }
        }), null, (int)786431, null);
        Project project2 = ProjectManagerEx.getInstanceEx().openProject(path, options2);
        if (project2 == null) {
            Intrinsics.throwNpe();
        }
        Project project3 = project2;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
        }
        return project3;
    }

    @JvmStatic
    @NotNull
    public static final Module createModuleAt(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType<?> moduleType, @NotNull String path, boolean isCreateProjectFileExplicitly, @NotNull Collection<Path> filesToDelete) {
        if (isCreateProjectFileExplicitly) {
            Path moduleFile = Paths.get(path, moduleName + ".iml");
            try {
                PathKt.createFile((Path)moduleFile);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            filesToDelete.add(moduleFile);
            return (Module)WriteAction.computeAndWait((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<Module, RuntimeException>(moduleFile, project2, moduleType){
                final /* synthetic */ Path $moduleFile;
                final /* synthetic */ Project $project;
                final /* synthetic */ ModuleType $moduleType;

                /*
                 * WARNING - void declaration
                 */
                public final Module compute() {
                    void var2_2;
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(this.$moduleFile);
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    VirtualFile virtualFile2 = virtualFile;
                    Module module2 = ModuleManager.getInstance((Project)this.$project).newModule(virtualFile2.getPath(), this.$moduleType.getId());
                    module2.getModuleFile();
                    return var2_2;
                }
                {
                    this.$moduleFile = path;
                    this.$project = project2;
                    this.$moduleType = moduleType;
                }
            }));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        return (Module)WriteAction.computeAndWait((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<Module, RuntimeException>(moduleManager, path, moduleName, moduleType){
            final /* synthetic */ ModuleManager $moduleManager;
            final /* synthetic */ String $path;
            final /* synthetic */ String $moduleName;
            final /* synthetic */ ModuleType $moduleType;

            public final Module compute() {
                return this.$moduleManager.newModule(this.$path + File.separatorChar + this.$moduleName + ".iml", this.$moduleType.getId());
            }
            {
                this.$moduleManager = moduleManager;
                this.$path = string;
                this.$moduleName = string2;
                this.$moduleType = moduleType;
            }
        }));
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile createTestProjectStructure(@NotNull String tempName, @Nullable Module module2, @Nullable String rootPath, @NotNull Collection<Path> filesToDelete, boolean addProjectRoots) {
        Path dir = HeavyTestHelper.createTempDirectoryForTempDirTestFixture(null, tempName);
        filesToDelete.add(dir);
        VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(dir);
        boolean bl = vDir != null && vDir.isDirectory();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            Path path = dir;
            throw (Throwable)((Object)new AssertionError(path));
        }
        VirtualFile virtualFile = vDir;
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        HeavyPlatformTestCase.synchronizeTempDirVfs(virtualFile);
        WriteAction.runAndWait((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(rootPath, vDir, addProjectRoots, module2){
            final /* synthetic */ String $rootPath;
            final /* synthetic */ VirtualFile $vDir;
            final /* synthetic */ boolean $addProjectRoots;
            final /* synthetic */ Module $module;

            public final void run() {
                if (this.$rootPath != null) {
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(StringsKt.replace$default((String)this.$rootPath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null));
                    if (virtualFile == null) {
                        throw (Throwable)new Exception(this.$rootPath + " not found");
                    }
                    VirtualFile vDir1 = virtualFile;
                    VfsUtil.copyDirectory(null, (VirtualFile)vDir1, (VirtualFile)this.$vDir, null);
                }
                if (this.$addProjectRoots) {
                    Module module2 = this.$module;
                    if (module2 == null) {
                        Intrinsics.throwNpe();
                    }
                    PsiTestUtil.addSourceContentToRoots(module2, this.$vDir);
                }
            }
            {
                this.$rootPath = string;
                this.$vDir = virtualFile;
                this.$addProjectRoots = bl;
                this.$module = module2;
            }
        }));
        return vDir;
    }

    @JvmStatic
    @NotNull
    public static final Path createTempDirectoryForTempDirTestFixture(@Nullable Path dir, @NotNull String prefix) {
        Path path = dir;
        if (path == null) {
            path = Paths.get(FileUtil.getTempDirectory(), new String[0]);
        }
        Path parentDir = path;
        Files.createDirectories(parentDir, new FileAttribute[0]);
        return Files.createTempDirectory(parentDir, prefix, new FileAttribute[0]);
    }

    private HeavyTestHelper() {
    }

    static {
        HeavyTestHelper heavyTestHelper;
        INSTANCE = heavyTestHelper = new HeavyTestHelper();
    }
}

