/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.application.options.CodeStyle;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.ui.components.LegalNoticeDialog;
import com.intellij.util.FileContentUtilCore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.jar.Manifest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.IdeaDecompiler;
import org.jetbrains.java.decompiler.IdeaDecompilerBundle;
import org.jetbrains.java.decompiler.IdeaLogger;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0004\u0017\u0018\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J'\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler;", "Lcom/intellij/psi/compiled/ClassFileDecompilers$Light;", "()V", "myLogger", "Lkotlin/Lazy;", "Lorg/jetbrains/java/decompiler/IdeaLogger;", "myOptions", "", "", "", "accepts", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "decompile", "", "getText", "pop", "T", "Lcom/intellij/openapi/util/Key;", "holder", "Lcom/intellij/openapi/util/UserDataHolder;", "(Lcom/intellij/openapi/util/Key;Lcom/intellij/openapi/util/UserDataHolder;)Ljava/lang/Object;", "Companion", "LegalBurden", "MyBytecodeProvider", "MyResultSaver", "intellij.java.decompiler"})
public final class IdeaDecompiler
extends ClassFileDecompilers.Light {
    private final Lazy<IdeaLogger> myLogger = LazyKt.lazy((Function0)myLogger.1.INSTANCE);
    private final Lazy<Map<String, Object>> myOptions = LazyKt.lazy((Function0)myOptions.1.INSTANCE);
    @NotNull
    public static final String BANNER = "//\n// Source code recreated from a .class file by IntelliJ IDEA\n// (powered by FernFlower decompiler)\n//\n\n";
    private static final String LEGAL_NOTICE_KEY = "decompiler.legal.notice.accepted";
    private static final int POSTPONE_EXIT_CODE = 1;
    private static final int DECLINE_EXIT_CODE = 2;
    private static final Key<Future<CharSequence>> TASK_KEY;
    public static final Companion Companion;

    public boolean accepts(@NotNull VirtualFile file) {
        return true;
    }

    @NotNull
    public CharSequence getText(@NotNull VirtualFile file) {
        Future<CharSequence> future;
        if (IdeaDecompiler.Companion.canWork()) {
            future = this.pop(TASK_KEY, (UserDataHolder)file);
            if (future == null || (future = (CharSequence)future.get()) == null) {
                future = this.decompile(file);
            }
        } else {
            future = ClsFileImpl.decompile((VirtualFile)file);
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private final CharSequence decompile(VirtualFile file) {
        if (Intrinsics.areEqual((Object)"package-info.class", (Object)file.getName()) || Intrinsics.areEqual((Object)"module-info.class", (Object)file.getName())) {
            return ClsFileImpl.decompile((VirtualFile)file);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(IdeaDecompilerBundle.message("decompiling.progress", file.getName()));
        }
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String mask = file.getNameWithoutExtension() + '$';
            VirtualFile[] virtualFileArray = file.getParent().getChildren();
            Collection collection = CollectionsKt.listOf((Object)file);
            boolean $i$f$filter = false;
            void var7_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var10_14 = $this$filterTo$iv$iv;
            int n = ((void)var10_14).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var10_14[i];
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it.getName(), (String)mask, (boolean)false, (int)2, null) && it.getFileType() == JavaClassFileType.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            List files = CollectionsKt.plus((Collection)collection, (Iterable)list);
            HashMap options = new HashMap((Map)this.myOptions.getValue());
            if (Registry.is((String)"decompiler.use.line.mapping")) {
                ((Map)options).put("bsm", "1");
            }
            if (Registry.is((String)"decompiler.dump.original.lines")) {
                ((Map)options).put("__dump_original_lines__", "1");
            }
            MyBytecodeProvider provider = new MyBytecodeProvider(files);
            MyResultSaver saver = new MyResultSaver();
            BaseDecompiler decompiler = new BaseDecompiler(provider, saver, options, (IFernflowerLogger)this.myLogger.getValue());
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                decompiler.addSource(new File(it.getPath()));
            }
            decompiler.decompileContext();
            int[] mapping = saver.getMyMapping();
            if (mapping != null) {
                file.putUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY, (Object)new LineNumbersMapping.ArrayBasedMapping(mapping));
            }
            return saver.getMyResult();
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            if (e instanceof IdeaLogger.InternalException && e.getCause() instanceof IOException) {
                Logger.getInstance(IdeaDecompiler.class).warn(file.getUrl(), (Throwable)e);
                return Strings.EMPTY_CHAR_SEQUENCE;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw (Throwable)((Object)new AssertionError(file.getUrl(), e));
            }
            throw (Throwable)new ClassFileDecompilers.Light.CannotDecompileException((Throwable)e);
        }
    }

    private final <T> T pop(Key<T> $this$pop, UserDataHolder holder) {
        Object value = $this$pop.get(holder);
        if (value != null) {
            $this$pop.set(holder, null);
        }
        return (T)value;
    }

    static {
        Companion = new Companion(null);
        TASK_KEY = Key.create((String)"java.decompiler.optimistic.task");
    }

    public static final /* synthetic */ CharSequence access$decompile(IdeaDecompiler $this, VirtualFile file) {
        return $this.decompile(file);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$LegalBurden;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener$Before;", "()V", "myShowNotice", "", "beforeFileOpened", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.java.decompiler"})
    public static final class LegalBurden
    implements FileEditorManagerListener.Before {
        private boolean myShowNotice = !org.jetbrains.java.decompiler.IdeaDecompiler$Companion.access$canWork(Companion);

        public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            ClassFileDecompilers.Decompiler decompiler;
            if (this.myShowNotice && file.getFileType() == JavaClassFileType.INSTANCE && (decompiler = ClassFileDecompilers.getInstance().find(file)) instanceof IdeaDecompiler) {
                TASK_KEY.set((UserDataHolder)file, (Object)ApplicationManager.getApplication().executeOnPooledThread((Callable)new Callable<CharSequence>(decompiler, file){
                    final /* synthetic */ ClassFileDecompilers.Decompiler $decompiler;
                    final /* synthetic */ VirtualFile $file;

                    public final CharSequence call() {
                        return IdeaDecompiler.access$decompile((IdeaDecompiler)this.$decompiler, this.$file);
                    }
                    {
                        this.$decompiler = decompiler;
                        this.$file = virtualFile;
                    }
                }));
                String title = IdeaDecompilerBundle.message("legal.notice.title", StringUtil.last((CharSequence)file.getPath(), (int)40, (boolean)true));
                String message = IdeaDecompilerBundle.message("legal.notice.text", new Object[0]);
                int result = LegalNoticeDialog.build((String)title, (String)message).withCancelText(IdeaDecompilerBundle.message("legal.notice.action.postpone", new Object[0])).withCustomAction(IdeaDecompilerBundle.message("legal.notice.action.reject", new Object[0]), 2).show();
                switch (result) {
                    case 0: {
                        this.myShowNotice = false;
                        PropertiesComponent.getInstance().setValue(IdeaDecompiler.LEGAL_NOTICE_KEY, true);
                        ApplicationManager.getApplication().invokeLater(new Runnable(file){
                            final /* synthetic */ VirtualFile $file;

                            public final void run() {
                                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{this.$file});
                            }
                            {
                                this.$file = virtualFile;
                            }
                        });
                        break;
                    }
                    case 2: {
                        IdeaPluginDescriptorImpl descriptor;
                        this.myShowNotice = false;
                        TASK_KEY.set((UserDataHolder)file, null);
                        PluginId id = PluginId.getId((String)"org.jetbrains.java.decompiler");
                        PluginManagerCore.disablePlugin((PluginId)id);
                        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)id);
                        if (!(plugin instanceof IdeaPluginDescriptorImpl) || !DynamicPlugins.allowLoadUnloadWithoutRestart$default((IdeaPluginDescriptorImpl)(descriptor = PluginDescriptorLoader.loadFullDescriptor((IdeaPluginDescriptorImpl)((IdeaPluginDescriptorImpl)plugin))), null, (int)2, null)) break;
                        Runnable task = DynamicPlugins.getPluginUnloadingTask((IdeaPluginDescriptorImpl)descriptor, (DynamicPlugins.UnloadPluginOptions)new DynamicPlugins.UnloadPluginOptions(true, false, false, false, false, false, 58, null));
                        ApplicationManager.getApplication().invokeLater(task);
                        break;
                    }
                    case 1: {
                        TASK_KEY.set((UserDataHolder)file, null);
                        break;
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0016R\"\u0010\u0006\u001a\u0016\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$MyBytecodeProvider;", "Lorg/jetbrains/java/decompiler/main/extern/IBytecodeProvider;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/util/List;)V", "pathMap", "", "", "kotlin.jvm.PlatformType", "getBytecode", "", "externalPath", "internalPath", "intellij.java.decompiler"})
    private static final class MyBytecodeProvider
    implements IBytecodeProvider {
        private final Map<String, VirtualFile> pathMap;

        @Override
        @NotNull
        public byte[] getBytecode(@NotNull String externalPath, @Nullable String internalPath) {
            Object object;
            block3: {
                block2: {
                    object = this.pathMap.get(externalPath);
                    if (object == null) break block2;
                    byte[] byArray = object.contentsToByteArray(false);
                    object = byArray;
                    if (byArray != null) break block3;
                }
                throw (Throwable)((Object)new AssertionError((Object)(externalPath + " not in " + this.pathMap.keySet())));
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        public MyBytecodeProvider(@NotNull List<? extends VirtualFile> files) {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = files;
            MyBytecodeProvider myBytecodeProvider = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)new File(it.getPath()).getAbsolutePath(), (Object)it);
                collection.add(pair);
            }
            collection = (List)destination$iv$iv;
            myBytecodeProvider.pathMap = MapsKt.toMap((Iterable)collection);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0016J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J \u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J0\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0016J2\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0016J \u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$MyResultSaver;", "Lorg/jetbrains/java/decompiler/main/extern/IResultSaver;", "()V", "myMapping", "", "getMyMapping", "()[I", "setMyMapping", "([I)V", "myResult", "", "getMyResult", "()Ljava/lang/String;", "setMyResult", "(Ljava/lang/String;)V", "closeArchive", "", "path", "archiveName", "copyEntry", "source", "entry", "copyFile", "entryName", "createArchive", "manifest", "Ljava/util/jar/Manifest;", "saveClassEntry", "qualifiedName", "content", "saveClassFile", "mapping", "saveDirEntry", "saveFolder", "intellij.java.decompiler"})
    private static final class MyResultSaver
    implements IResultSaver {
        @NotNull
        private String myResult = "";
        @Nullable
        private int[] myMapping;

        @NotNull
        public final String getMyResult() {
            return this.myResult;
        }

        public final void setMyResult(@NotNull String string) {
            this.myResult = string;
        }

        @Nullable
        public final int[] getMyMapping() {
            return this.myMapping;
        }

        public final void setMyMapping(@Nullable int[] nArray) {
            this.myMapping = nArray;
        }

        @Override
        public void saveClassFile(@NotNull String path, @NotNull String qualifiedName, @NotNull String entryName, @NotNull String content, @Nullable int[] mapping) {
            CharSequence charSequence = this.myResult;
            boolean bl = false;
            if (charSequence.length() == 0) {
                this.myResult = content;
                this.myMapping = mapping;
            }
        }

        @Override
        public void saveFolder(@NotNull String path) {
        }

        @Override
        public void copyFile(@NotNull String source, @NotNull String path, @NotNull String entryName) {
        }

        @Override
        public void createArchive(@NotNull String path, @NotNull String archiveName, @NotNull Manifest manifest) {
        }

        @Override
        public void saveDirEntry(@NotNull String path, @NotNull String archiveName, @NotNull String entryName) {
        }

        @Override
        public void copyEntry(@NotNull String source, @NotNull String path, @NotNull String archiveName, @NotNull String entry) {
        }

        @Override
        public void saveClassEntry(@NotNull String path, @NotNull String archiveName, @NotNull String qualifiedName, @NotNull String entryName, @NotNull String content) {
        }

        @Override
        public void closeArchive(@NotNull String path, @NotNull String archiveName) {
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$Companion;", "", "()V", "BANNER", "", "DECLINE_EXIT_CODE", "", "LEGAL_NOTICE_KEY", "POSTPONE_EXIT_CODE", "TASK_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/util/concurrent/Future;", "", "canWork", "", "getOptions", "", "intellij.java.decompiler"})
    public static final class Companion {
        private final Map<String, Object> getOptions() {
            CommonCodeStyleSettings.IndentOptions options = CodeStyle.getDefaultSettings().getIndentOptions((FileType)JavaFileType.INSTANCE);
            String indent = StringUtil.repeat((String)" ", (int)options.INDENT_SIZE);
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"hdc", (Object)"0"), TuplesKt.to((Object)"dgs", (Object)"1"), TuplesKt.to((Object)"rsy", (Object)"1"), TuplesKt.to((Object)"rbr", (Object)"1"), TuplesKt.to((Object)"lit", (Object)"1"), TuplesKt.to((Object)"nls", (Object)"1"), TuplesKt.to((Object)"ban", (Object)IdeaDecompiler.BANNER), TuplesKt.to((Object)"mpm", (Object)60), TuplesKt.to((Object)"ind", (Object)indent), TuplesKt.to((Object)"iib", (Object)"1"), TuplesKt.to((Object)"vac", (Object)"1"), TuplesKt.to((Object)"__unit_test_mode__", (Object)(ApplicationManager.getApplication().isUnitTestMode() ? "1" : "0"))});
        }

        private final boolean canWork() {
            return ApplicationManager.getApplication().isUnitTestMode() || PropertiesComponent.getInstance().isValueSet(IdeaDecompiler.LEGAL_NOTICE_KEY);
        }

        private Companion() {
        }

        public static final /* synthetic */ Map access$getOptions(Companion $this) {
            return $this.getOptions();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

