/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;

@com.intellij.openapi.components.State(name="GithubProjectSettings", storages={@Storage(value="$WORKSPACE_FILE$")}, reportStatistic=false)
public class GithubProjectSettings
implements PersistentStateComponent<State> {
    private State myState = new State();

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state2) {
        this.myState = state2;
    }

    public static GithubProjectSettings getInstance(@NotNull Project project) {
        return (GithubProjectSettings)ServiceManager.getService((Project)project, GithubProjectSettings.class);
    }

    @Nullable
    public String getCreatePullRequestDefaultBranch() {
        return this.myState.CREATE_PULL_REQUEST_DEFAULT_BRANCH;
    }

    public void setCreatePullRequestDefaultBranch(@NotNull String branch) {
        this.myState.CREATE_PULL_REQUEST_DEFAULT_BRANCH = branch;
    }

    @Nullable
    public GHRepositoryPath getCreatePullRequestDefaultRepo() {
        if (this.myState.CREATE_PULL_REQUEST_DEFAULT_REPO_USER == null || this.myState.CREATE_PULL_REQUEST_DEFAULT_REPO_NAME == null) {
            return null;
        }
        return new GHRepositoryPath(this.myState.CREATE_PULL_REQUEST_DEFAULT_REPO_USER, this.myState.CREATE_PULL_REQUEST_DEFAULT_REPO_NAME);
    }

    public void setCreatePullRequestDefaultRepo(@NotNull GHRepositoryPath repo) {
        this.myState.CREATE_PULL_REQUEST_DEFAULT_REPO_USER = repo.getOwner();
        this.myState.CREATE_PULL_REQUEST_DEFAULT_REPO_NAME = repo.getRepository();
    }

    public static class State {
        @Nullable
        public String CREATE_PULL_REQUEST_DEFAULT_BRANCH = null;
        @Nullable
        public String CREATE_PULL_REQUEST_DEFAULT_REPO_USER = null;
        @Nullable
        public String CREATE_PULL_REQUEST_DEFAULT_REPO_NAME = null;
    }
}

