/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubSelectForkPanel;
import org.jetbrains.plugins.github.util.GithubNotifications;

public class GithubSelectForkDialog
extends DialogWrapper {
    @NotNull
    private final GithubSelectForkPanel myPanel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Convertor<? super String, ? extends GithubCreatePullRequestWorker.ForkInfo> myCheckFork;
    private GithubCreatePullRequestWorker.ForkInfo mySelectedFork;

    public GithubSelectForkDialog(@NotNull Project project, @Nullable List<GHRepositoryPath> forks, @NotNull Convertor<? super String, ? extends GithubCreatePullRequestWorker.ForkInfo> checkFork) {
        super(project);
        this.myProject = project;
        this.myCheckFork = checkFork;
        this.myPanel = new GithubSelectForkPanel();
        if (forks != null) {
            this.myPanel.setUsers(ContainerUtil.map(forks, GHRepositoryPath::getOwner));
        }
        this.setTitle(GithubBundle.message("select.fork.dialog.title", new Object[0]));
        this.init();
    }

    protected void doOKAction() {
        GithubCreatePullRequestWorker.ForkInfo fork = (GithubCreatePullRequestWorker.ForkInfo)this.myCheckFork.convert((Object)this.myPanel.getUser());
        if (fork == null) {
            GithubNotifications.showErrorDialog(this.myProject, GithubBundle.message("cannot.find.repository", new Object[0]), GithubBundle.message("cannot.find.fork", new Object[0]));
        } else {
            this.mySelectedFork = fork;
            super.doOKAction();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel.getPanel();
    }

    @NotNull
    public GithubCreatePullRequestWorker.ForkInfo getPath() {
        return this.mySelectedFork;
    }
}

