/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHRepositoryOwnerName;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubIssueLabel;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.api.data.GithubUserWithPermissions;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLPagedRequestResponse;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLRequestPagination;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHTeam;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.api.util.SimpleGHGQLPagesLoader;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataServiceImpl;
import org.jetbrains.plugins.github.util.LazyCancellableBackgroundProcessValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R \u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u000f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0015R\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u000f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u000f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u001a\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "repoOwner", "Lorg/jetbrains/plugins/github/api/data/GHRepositoryOwnerName;", "(Lcom/intellij/openapi/progress/ProgressManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/api/GithubServerPath;Lorg/jetbrains/plugins/github/api/GHRepositoryPath;Lorg/jetbrains/plugins/github/api/data/GHRepositoryOwnerName;)V", "assigneesValue", "Lorg/jetbrains/plugins/github/util/LazyCancellableBackgroundProcessValue;", "", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "collaboratorsValue", "collaboratorsWithPushAccess", "Ljava/util/concurrent/CompletableFuture;", "getCollaboratorsWithPushAccess", "()Ljava/util/concurrent/CompletableFuture;", "issuesAssignees", "getIssuesAssignees", "labels", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "getLabels", "labelsValue", "potentialReviewers", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "getPotentialReviewers", "teams", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHTeam;", "getTeams", "teamsValue", "dispose", "", "resetData", "intellij.vcs.github"})
public final class GHPRRepositoryDataServiceImpl
implements GHPRRepositoryDataService {
    private final LazyCancellableBackgroundProcessValue<List<GHUser>> collaboratorsValue;
    private final LazyCancellableBackgroundProcessValue<List<GHTeam>> teamsValue;
    private final LazyCancellableBackgroundProcessValue<List<GHUser>> assigneesValue;
    private final LazyCancellableBackgroundProcessValue<List<GHLabel>> labelsValue;
    private final GithubApiRequestExecutor requestExecutor;
    private final GithubServerPath serverPath;
    private final GHRepositoryPath repoPath;
    private final GHRepositoryOwnerName repoOwner;

    @Override
    @NotNull
    public CompletableFuture<List<GHUser>> getCollaboratorsWithPushAccess() {
        return (CompletableFuture)this.collaboratorsValue.getValue();
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHTeam>> getTeams() {
        return (CompletableFuture)this.teamsValue.getValue();
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHPullRequestRequestedReviewer>> getPotentialReviewers() {
        return this.getCollaboratorsWithPushAccess().thenCombine(this.getTeams(), (BiFunction)potentialReviewers.1.INSTANCE);
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHUser>> getIssuesAssignees() {
        return (CompletableFuture)this.assigneesValue.getValue();
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHLabel>> getLabels() {
        return (CompletableFuture)this.labelsValue.getValue();
    }

    @Override
    public void resetData() {
        this.collaboratorsValue.drop();
        this.teamsValue.drop();
        this.assigneesValue.drop();
        this.labelsValue.drop();
    }

    public void dispose() {
        this.resetData();
    }

    public GHPRRepositoryDataServiceImpl(@NotNull ProgressManager progressManager, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GithubServerPath serverPath, @NotNull GHRepositoryPath repoPath, @NotNull GHRepositoryOwnerName repoOwner) {
        this.requestExecutor = requestExecutor;
        this.serverPath = serverPath;
        this.repoPath = repoPath;
        this.repoOwner = repoOwner;
        this.requestExecutor.addListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.resetData();
            }
        }));
        this.collaboratorsValue = LazyCancellableBackgroundProcessValue.Companion.create(progressManager, (Function1)new Function1<ProgressIndicator, List<? extends GHUser>>(this){
            final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<GHUser> invoke(@NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                GithubUserWithPermissions it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = GithubApiPagesLoader.loadAll(GHPRRepositoryDataServiceImpl.access$getRequestExecutor$p(this.this$0), indicator, GithubApiRequests.Repos.Collaborators.pages(GHPRRepositoryDataServiceImpl.access$getServerPath$p(this.this$0), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getOwner(), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getRepository()));
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (GithubUserWithPermissions)element$iv$iv;
                    boolean bl = false;
                    if (!it.getPermissions().isPush()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (GithubUserWithPermissions)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getNodeId();
                    String string2 = it.getLogin();
                    String string3 = it.getHtmlUrl();
                    String string4 = it.getAvatarUrl();
                    if (string4 == null) {
                        string4 = "";
                    }
                    GHUser gHUser = new GHUser(string, string2, string3, string4, null);
                    collection.add(gHUser);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = gHPRRepositoryDataServiceImpl;
                super(1);
            }
        });
        this.teamsValue = LazyCancellableBackgroundProcessValue.Companion.create(progressManager, (Function1)new Function1<ProgressIndicator, List<? extends GHTeam>>(this){
            final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;

            @NotNull
            public final List<GHTeam> invoke(@NotNull ProgressIndicator indicator) {
                return !(GHPRRepositoryDataServiceImpl.access$getRepoOwner$p(this.this$0) instanceof GHRepositoryOwnerName.Organization) ? CollectionsKt.emptyList() : new SimpleGHGQLPagesLoader<T>(GHPRRepositoryDataServiceImpl.access$getRequestExecutor$p(this.this$0), (Function1)new Function1<GHGQLRequestPagination, GithubApiRequest.Post<? extends GHGQLPagedRequestResponse<? extends GHTeam>>>(this){
                    final /* synthetic */ teamsValue.1 this$0;

                    @NotNull
                    public final GithubApiRequest.Post<GHGQLPagedRequestResponse<GHTeam>> invoke(@NotNull GHGQLRequestPagination it) {
                        return GHGQLRequests.Organization.Team.INSTANCE.findAll(GHPRRepositoryDataServiceImpl.access$getServerPath$p(this.this$0.this$0), GHPRRepositoryDataServiceImpl.access$getRepoOwner$p(this.this$0.this$0).getLogin(), it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, false, 0, 12, null).loadAll(indicator);
            }
            {
                this.this$0 = gHPRRepositoryDataServiceImpl;
                super(1);
            }
        });
        this.assigneesValue = LazyCancellableBackgroundProcessValue.Companion.create(progressManager, (Function1)new Function1<ProgressIndicator, List<? extends GHUser>>(this){
            final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<GHUser> invoke(@NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = GithubApiPagesLoader.loadAll(GHPRRepositoryDataServiceImpl.access$getRequestExecutor$p(this.this$0), indicator, GithubApiRequests.Repos.Assignees.pages(GHPRRepositoryDataServiceImpl.access$getServerPath$p(this.this$0), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getOwner(), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getRepository()));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GithubUser githubUser = (GithubUser)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getNodeId();
                    String string2 = it.getLogin();
                    String string3 = it.getHtmlUrl();
                    String string4 = it.getAvatarUrl();
                    if (string4 == null) {
                        string4 = "";
                    }
                    GHUser gHUser = new GHUser(string, string2, string3, string4, null);
                    collection.add(gHUser);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = gHPRRepositoryDataServiceImpl;
                super(1);
            }
        });
        this.labelsValue = LazyCancellableBackgroundProcessValue.Companion.create(progressManager, (Function1)new Function1<ProgressIndicator, List<? extends GHLabel>>(this){
            final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<GHLabel> invoke(@NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = GithubApiPagesLoader.loadAll(GHPRRepositoryDataServiceImpl.access$getRequestExecutor$p(this.this$0), indicator, GithubApiRequests.Repos.Labels.pages(GHPRRepositoryDataServiceImpl.access$getServerPath$p(this.this$0), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getOwner(), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getRepository()));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GithubIssueLabel githubIssueLabel = (GithubIssueLabel)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    GHLabel gHLabel = new GHLabel(it.getNodeId(), it.getUrl(), it.getName(), it.getColor());
                    collection.add(gHLabel);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = gHPRRepositoryDataServiceImpl;
                super(1);
            }
        });
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GHPRRepositoryDataServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GithubServerPath access$getServerPath$p(GHPRRepositoryDataServiceImpl $this) {
        return $this.serverPath;
    }

    public static final /* synthetic */ GHRepositoryPath access$getRepoPath$p(GHPRRepositoryDataServiceImpl $this) {
        return $this.repoPath;
    }

    public static final /* synthetic */ GHRepositoryOwnerName access$getRepoOwner$p(GHPRRepositoryDataServiceImpl $this) {
        return $this.repoOwner;
    }
}

