/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.accounts;

import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubServerPath;

@Tag(value="account")
public class GithubAccount {
    @Attribute(value="id")
    @NotNull
    private final String myId;
    @Attribute(value="name")
    @NotNull
    private String myName;
    @Property(style=Property.Style.ATTRIBUTE, surroundWithTag=false)
    @NotNull
    private final GithubServerPath myServer;

    private GithubAccount() {
        this.myId = "";
        this.myName = "";
        this.myServer = new GithubServerPath();
    }

    GithubAccount(@NotNull String name, @NotNull GithubServerPath server) {
        this.myId = UUID.randomUUID().toString();
        this.myName = name;
        this.myServer = server;
    }

    public String toString() {
        return this.myServer + "/" + this.myName;
    }

    @NotNull
    String getId() {
        return this.myId;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Transient
    public void setName(@NotNull String name) {
        this.myName = name;
    }

    @NotNull
    public GithubServerPath getServer() {
        return this.myServer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GithubAccount)) {
            return false;
        }
        GithubAccount account = (GithubAccount)o;
        return Objects.equals(this.myId, account.myId);
    }

    public int hashCode() {
        return Objects.hash(this.myId);
    }
}

