/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.sun.jdi.connect.spi.ClosedConnectionException;
import com.sun.jdi.connect.spi.Connection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class SocketConnection
extends Connection {
    private final Socket socket;
    private boolean closed = false;
    private final OutputStream socketOutput;
    private final InputStream socketInput;
    private final Object receiveLock = new Object();
    private final Object sendLock = new Object();
    private final Object closeLock = new Object();

    SocketConnection(Socket socket) throws IOException {
        this.socket = socket;
        socket.setTcpNoDelay(true);
        this.socketInput = socket.getInputStream();
        this.socketOutput = socket.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.socketOutput.close();
            this.socketInput.close();
            this.socket.close();
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.closeLock;
        synchronized (object) {
            return !this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readPacket() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedConnectionException("connection is closed");
        }
        Object object = this.receiveLock;
        synchronized (object) {
            int b4;
            int b3;
            int b2;
            int b1;
            try {
                b1 = this.socketInput.read();
                b2 = this.socketInput.read();
                b3 = this.socketInput.read();
                b4 = this.socketInput.read();
            }
            catch (IOException ioe) {
                if (!this.isOpen()) {
                    throw new ClosedConnectionException("connection is closed");
                }
                throw ioe;
            }
            if (b1 < 0) {
                return new byte[0];
            }
            if (b2 < 0 || b3 < 0 || b4 < 0) {
                throw new IOException("protocol error - premature EOF");
            }
            int len = b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
            if (len < 0) {
                throw new IOException("protocol error - invalid length");
            }
            byte[] b = new byte[len];
            b[0] = (byte)b1;
            b[1] = (byte)b2;
            b[2] = (byte)b3;
            b[3] = (byte)b4;
            int off = 4;
            len -= off;
            while (len > 0) {
                int count;
                try {
                    count = this.socketInput.read(b, off, len);
                }
                catch (IOException ioe) {
                    if (!this.isOpen()) {
                        throw new ClosedConnectionException("connection is closed");
                    }
                    throw ioe;
                }
                if (count < 0) {
                    throw new IOException("protocol error - premature EOF");
                }
                len -= count;
                off += count;
            }
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePacket(byte[] b) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedConnectionException("connection is closed");
        }
        if (b.length < 11) {
            throw new IllegalArgumentException("packet is insufficient size");
        }
        int b0 = b[0] & 0xFF;
        int b1 = b[1] & 0xFF;
        int b2 = b[2] & 0xFF;
        int b3 = b[3] & 0xFF;
        int len = b0 << 24 | b1 << 16 | b2 << 8 | b3 << 0;
        if (len < 11) {
            throw new IllegalArgumentException("packet is insufficient size");
        }
        if (len > b.length) {
            throw new IllegalArgumentException("length mis-match");
        }
        Object object = this.sendLock;
        synchronized (object) {
            try {
                this.socketOutput.write(b, 0, len);
            }
            catch (IOException ioe) {
                if (!this.isOpen()) {
                    throw new ClosedConnectionException("connection is closed");
                }
                throw ioe;
            }
        }
    }
}

