/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.MutableSyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;

class SyntaxNodeDescriptorImpl
implements MutableSyntaxNodeDescriptor {
    private static final Logger LOG = Logger.getInstance(SyntaxNodeDescriptor.class);
    private TIntObjectHashMap<SyntaxNodeDescriptor> myRepository = new TIntObjectHashMap();
    private Map<Constants.StringKey, CharSequence> myStringAttributes = new EnumMap<Constants.StringKey, CharSequence>(Constants.StringKey.class);
    private Map<Constants.CaptureKey, TIntObjectHashMap<CharSequence>> myCaptures = new EnumMap<Constants.CaptureKey, TIntObjectHashMap<CharSequence>>(Constants.CaptureKey.class);
    private List<SyntaxNodeDescriptor> myChildren = new ArrayList<SyntaxNodeDescriptor>();
    private List<InjectionNodeDescriptor> myInjections = new ArrayList<InjectionNodeDescriptor>();
    private final SyntaxNodeDescriptor myParentNode;
    private CharSequence myScopeName = null;

    SyntaxNodeDescriptorImpl(@Nullable SyntaxNodeDescriptor parentNode) {
        this.myParentNode = parentNode;
    }

    @Override
    public void setStringAttribute(@NotNull Constants.StringKey key, @Nullable CharSequence value) {
        this.myStringAttributes.put(key, value);
    }

    @Override
    @Nullable
    public CharSequence getStringAttribute(@NotNull Constants.StringKey key) {
        return this.myStringAttributes.get((Object)key);
    }

    @Override
    public void setCaptures(@NotNull Constants.CaptureKey key, @Nullable TIntObjectHashMap<CharSequence> captures) {
        this.myCaptures.put(key, captures);
    }

    @Override
    @Nullable
    public TIntObjectHashMap<CharSequence> getCaptures(@NotNull Constants.CaptureKey key) {
        return this.myCaptures.get((Object)key);
    }

    @Override
    public void addChild(SyntaxNodeDescriptor descriptor) {
        this.myChildren.add(descriptor);
    }

    @Override
    @NotNull
    public List<SyntaxNodeDescriptor> getChildren() {
        return this.myChildren;
    }

    @Override
    public void appendRepository(int ruleId, SyntaxNodeDescriptor descriptor) {
        this.myRepository.put(ruleId, (Object)descriptor);
    }

    @Override
    public void setScopeName(@NotNull CharSequence scopeName) {
        this.myScopeName = scopeName;
    }

    @Override
    public void compact() {
        this.myStringAttributes = PreferencesReadUtil.compactMap(this.myStringAttributes);
        this.myCaptures = PreferencesReadUtil.compactMap(this.myCaptures);
        this.myChildren = SyntaxNodeDescriptorImpl.compactList(this.myChildren);
        this.myInjections = SyntaxNodeDescriptorImpl.compactList(this.myInjections);
        this.myRepository = SyntaxNodeDescriptorImpl.compactMap(this.myRepository);
    }

    private static TIntObjectHashMap<SyntaxNodeDescriptor> compactMap(TIntObjectHashMap<SyntaxNodeDescriptor> map) {
        if (map.isEmpty()) {
            return null;
        }
        map.trimToSize();
        return map;
    }

    private static <T> List<T> compactList(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    @Override
    @NotNull
    public List<InjectionNodeDescriptor> getInjections() {
        return this.myInjections;
    }

    @Override
    public void addInjection(@NotNull InjectionNodeDescriptor injection) {
        this.myInjections.add(injection);
    }

    @Override
    @NotNull
    public SyntaxNodeDescriptor findInRepository(int ruleId) {
        SyntaxNodeDescriptor syntaxNodeDescriptor;
        SyntaxNodeDescriptor syntaxNodeDescriptor2 = syntaxNodeDescriptor = this.myRepository != null ? (SyntaxNodeDescriptor)this.myRepository.get(ruleId) : null;
        if (syntaxNodeDescriptor == null && this.myParentNode != null) {
            return this.myParentNode.findInRepository(ruleId);
        }
        if (syntaxNodeDescriptor == null) {
            LOG.warn("Can't find repository " + ruleId);
            return EMPTY_NODE;
        }
        return syntaxNodeDescriptor;
    }

    @Override
    @NotNull
    public CharSequence getScopeName() {
        return this.myScopeName;
    }

    @Override
    @Nullable
    public SyntaxNodeDescriptor getParentNode() {
        return this.myParentNode;
    }

    public String toString() {
        CharSequence name = this.myStringAttributes.get((Object)Constants.StringKey.NAME);
        return name != null ? "Syntax rule: " + name : super.toString();
    }
}

