/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import com.intellij.util.containers.Interner;
import gnu.trove.THashSet;
import java.io.File;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public final class PreferencesReadUtil {
    @Nullable
    public static Map.Entry<String, Plist> retrieveSettingsPlist(Plist rootPlist) {
        String scopeName = null;
        Plist settingsValuePlist = null;
        PListValue value = rootPlist.getPlistValue("scope");
        if (value != null) {
            scopeName = value.getString();
            PListValue settingsValue = rootPlist.getPlistValue("settings");
            if (scopeName != null && !scopeName.isEmpty() && settingsValue != null) {
                settingsValuePlist = settingsValue.getPlist();
            }
        }
        return settingsValuePlist != null ? new AbstractMap.SimpleImmutableEntry<String, Object>(scopeName, settingsValuePlist) : null;
    }

    @Nullable
    public static Set<TextMateBracePair> readPairs(@Nullable PListValue pairsValue) {
        if (pairsValue == null) {
            return null;
        }
        THashSet result = new THashSet();
        List<PListValue> pairs = pairsValue.getArray();
        for (PListValue pair : pairs) {
            List<PListValue> chars = pair.getArray();
            if (chars.size() != 2) continue;
            String left = chars.get(0).getString();
            String right = chars.get(1).getString();
            if (left.length() != 1 || right.length() != 1) continue;
            result.add((Object)new TextMateBracePair(left.charAt(0), right.charAt(0)));
        }
        if (result.size() == 0) {
            return Collections.emptySet();
        }
        result.trimToSize();
        return result;
    }

    @Nullable
    private static TextMateSnippet loadTextMateSnippet(@NotNull Plist plist, @NotNull String filePath, @NotNull Interner<CharSequence> interner) {
        String name = plist.getPlistValue("name", "").getString();
        String key = plist.getPlistValue("tabTrigger", "").getString();
        String content = plist.getPlistValue(Constants.StringKey.CONTENT.value, "").getString();
        String scope = plist.getPlistValue("scope", "").getString();
        String description = plist.getPlistValue("description", "").getString();
        String uuid = plist.getPlistValue("uuid", "").getString();
        if (!key.isEmpty() && !content.isEmpty()) {
            if (name.isEmpty()) {
                name = key;
            }
            if (uuid.isEmpty()) {
                uuid = filePath + ":" + name;
            }
            return new TextMateSnippet(key, content, (CharSequence)interner.intern((Object)scope), name, description, uuid);
        }
        return null;
    }

    @NotNull
    public static <K, V> Map<K, V> compactMap(@NotNull Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> singleEntry = map.entrySet().iterator().next();
            return Collections.singletonMap(singleEntry.getKey(), singleEntry.getValue());
        }
        if (!(map instanceof HashMap)) {
            return map;
        }
        HashMap<K, V> result = new HashMap<K, V>(map.size(), 1.0f);
        result.putAll(map);
        return result;
    }

    private PreferencesReadUtil() {
    }

    @Nullable
    public static TextMateSnippet loadSnippet(@NotNull File snippetFile, @NotNull Plist plist, @NotNull Interner<CharSequence> interner) {
        return snippetFile.getName().endsWith(".sublime-snippet") ? null : PreferencesReadUtil.loadTextMateSnippet(plist, snippetFile.getAbsolutePath(), interner);
    }
}

