/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageView;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.scale.JBUIScale;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

@State(name="CoverageViewManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public final class CoverageViewManager
implements PersistentStateComponent<StateBean> {
    private static final Logger LOG = Logger.getInstance(CoverageViewManager.class);
    public static final String TOOLWINDOW_ID = "Coverage";
    private final Project myProject;
    private final ContentManager myContentManager;
    private StateBean myStateBean = new StateBean();
    private final Map<String, CoverageView> myViews = new HashMap<String, CoverageView>();
    private boolean myReady;

    public CoverageViewManager(@NotNull Project project) {
        this.myProject = project;
        RegisterToolWindowTask registerToolWindowTask = RegisterToolWindowTask.closableSecondary((String)TOOLWINDOW_ID, CoverageBundle.messagePointer("coverage.view.title", new Object[0]), (Icon)AllIcons.Toolwindows.ToolWindowCoverage, (ToolWindowAnchor)ToolWindowAnchor.RIGHT);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).registerToolWindow(registerToolWindowTask);
        toolWindow.setHelpId("reference.toolWindows.Coverage");
        this.myContentManager = toolWindow.getContentManager();
        ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)this.myContentManager);
    }

    public StateBean getState() {
        return this.myStateBean;
    }

    public void loadState(@NotNull StateBean state) {
        this.myStateBean = state;
    }

    public CoverageView getToolwindow(CoverageSuitesBundle suitesBundle) {
        return this.myViews.get(CoverageViewManager.getDisplayName(suitesBundle));
    }

    public void activateToolwindow(@NotNull CoverageView view, boolean requestFocus) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOLWINDOW_ID);
        if (requestFocus) {
            this.myContentManager.setSelectedContent(this.myContentManager.getContent((JComponent)((Object)view)));
            LOG.assertTrue(toolWindow != null);
            toolWindow.activate(null, false);
        }
    }

    public static CoverageViewManager getInstance(@NotNull Project project) {
        return (CoverageViewManager)ServiceManager.getService((Project)project, CoverageViewManager.class);
    }

    public void createToolWindow(String displayName, boolean defaultFileProvider) {
        CoverageView coverageView = new CoverageView(this.myProject, CoverageDataManager.getInstance(this.myProject), this.myStateBean);
        this.myViews.put(displayName, coverageView);
        Content content = this.myContentManager.getFactory().createContent((JComponent)((Object)coverageView), displayName, true);
        this.myContentManager.addContent(content);
        this.myContentManager.setSelectedContent(content);
        if (CoverageOptionsProvider.getInstance(this.myProject).activateViewOnRun() && defaultFileProvider) {
            this.activateToolwindow(coverageView, true);
        }
    }

    void closeView(String displayName) {
        CoverageView oldView = this.myViews.remove(displayName);
        if (oldView != null) {
            oldView.saveSize();
            Content content = this.myContentManager.getContent((JComponent)((Object)oldView));
            ApplicationManager.getApplication().invokeLater(() -> {
                if (content != null) {
                    this.myContentManager.removeContent(content, false);
                }
            });
        }
        this.setReady(false);
    }

    public boolean isReady() {
        return this.myReady;
    }

    public void setReady(boolean ready) {
        this.myReady = ready;
    }

    public static String getDisplayName(CoverageSuitesBundle suitesBundle) {
        RunConfigurationBase configuration = suitesBundle.getRunConfiguration();
        return configuration != null ? configuration.getName() : suitesBundle.getPresentableName();
    }

    public static final class StateBean {
        public boolean myFlattenPackages = false;
        public boolean myAutoScrollToSource = false;
        public boolean myAutoScrollFromSource = false;
        public int myElementSize = JBUIScale.scale((int)200);
    }
}

