/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeAction;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.references.I18nizeQuickFixDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nizeQuickFix
implements LocalQuickFix,
I18nQuickFixHandler,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(I18nizeQuickFix.class);
    private static final Set<String> AUXILIARY_WORDS = ContainerUtil.immutableSet((Object[])new String[]{"is", "not", "the", "of", "and", "a", "an"});
    private final NlsInfo.Localized myInfo;
    private TextRange mySelectionRange;

    public I18nizeQuickFix(NlsInfo.Localized info) {
        this.myInfo = info;
    }

    public I18nizeQuickFix() {
        this(NlsInfo.localized());
    }

    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        this.doFix(descriptor, project);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return JavaI18nBundle.message("inspection.i18n.quickfix", new Object[0]);
    }

    @Override
    public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
        PsiLiteralExpression literalExpression = I18nizeAction.getEnclosingStringLiteral(psiFile, editor);
        if (literalExpression != null) {
            SelectionModel selectionModel = editor.getSelectionModel();
            if (!selectionModel.hasSelection()) {
                return;
            }
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            TextRange textRange = literalExpression.getTextRange();
            if (textRange.contains(start) && textRange.contains(end)) {
                this.mySelectionRange = new TextRange(start, end);
                return;
            }
        }
        String message = JavaI18nBundle.message("i18nize.error.message", new Object[0]);
        throw new IncorrectOperationException(message);
    }

    @Override
    public void performI18nization(PsiFile psiFile, Editor editor, PsiLiteralExpression literalExpression, Collection<PropertiesFile> propertiesFiles, String key, String value, String i18nizedText, PsiExpression[] parameters, PropertyCreationHandler propertyCreationHandler) throws IncorrectOperationException {
        Project project = psiFile.getProject();
        propertyCreationHandler.createProperty(project, propertiesFiles, key, value, parameters);
        try {
            PsiElement newExpression = this.doReplacementInJava(psiFile, editor, literalExpression, i18nizedText);
            I18nizeQuickFix.reformatAndCorrectReferences(newExpression);
        }
        catch (IncorrectOperationException e) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)JavaI18nBundle.message("inspection.i18n.expression.is.invalid.error.message", new Object[0]), (String)JavaI18nBundle.message("inspection.error.dialog.title", new Object[0])));
        }
    }

    @Override
    public JavaI18nizeQuickFixDialog createDialog(Project project, Editor editor, PsiFile psiFile) {
        PsiLiteralExpression literalExpression = I18nizeAction.getEnclosingStringLiteral(psiFile, editor);
        return this.createDialog(project, psiFile, literalExpression);
    }

    private void doFix(ProblemDescriptor descriptor, Project project) {
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)descriptor.getPsiElement();
        PsiFile psiFile = literalExpression.getContainingFile();
        if (!JavaI18nizeQuickFixDialog.isAvailable(psiFile)) {
            return;
        }
        JavaI18nizeQuickFixDialog dialog = this.createDialog(project, psiFile, literalExpression);
        if (!dialog.showAndGet()) {
            return;
        }
        Collection propertiesFiles = dialog.getAllPropertiesFiles();
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)literalExpression)) {
            return;
        }
        for (PropertiesFile file : propertiesFiles) {
            if (file.findPropertyByKey(dialog.getKey()) != null || FileModificationService.getInstance().prepareFileForWrite(file.getContainingFile())) continue;
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                this.performI18nization(psiFile, PsiEditorUtil.findEditor((PsiElement)psiFile), dialog.getLiteralExpression(), propertiesFiles, dialog.getKey(), dialog.getValue(), dialog.getI18nizedText(), dialog.getParameters(), dialog.getPropertyCreationHandler());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }), PropertiesBundle.message((String)"quickfix.i18n.command.name", (Object[])new Object[0]), (Object)project);
    }

    protected PsiElement doReplacementInJava(@NotNull PsiFile psiFile, Editor editor, PsiLiteralExpression literalExpression, String i18nizedText) throws IncorrectOperationException {
        return this.replaceStringLiteral(literalExpression, i18nizedText);
    }

    private static void reformatAndCorrectReferences(PsiElement newExpression) throws IncorrectOperationException {
        Project project = newExpression.getProject();
        newExpression = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newExpression);
        CodeStyleManager.getInstance((Project)project).reformat(newExpression);
    }

    protected JavaI18nizeQuickFixDialog createDialog(Project project, PsiFile context, PsiLiteralExpression literalExpression) {
        String value = StringUtil.notNullize((String)((String)literalExpression.getValue()));
        if (this.mySelectionRange != null) {
            TextRange literalRange = literalExpression.getTextRange();
            TextRange intersection = literalRange.intersection(this.mySelectionRange);
            value = literalExpression.getText().substring(intersection.getStartOffset() - literalRange.getStartOffset(), intersection.getEndOffset() - literalRange.getStartOffset());
        }
        return new JavaI18nizeQuickFixDialog(project, context, literalExpression, value, this.getCustomization(value), true, true);
    }

    @NotNull
    I18nizeQuickFixDialog.DialogCustomization getCustomization(String value) {
        return new I18nizeQuickFixDialog.DialogCustomization(null, true, false, null, this.getSuggestedName(value));
    }

    private String getSuggestedName(String value) {
        String prefix = this.myInfo.getPrefix();
        String suffix = this.myInfo.getSuffix();
        if (prefix.isEmpty() && suffix.isEmpty()) {
            return null;
        }
        if (!prefix.isEmpty()) {
            prefix = prefix + ".";
        }
        if (!suffix.isEmpty()) {
            suffix = "." + suffix;
        }
        String payload = I18nizeQuickFixDialog.generateDefaultPropertyKey((String)value);
        payload = Stream.of(payload.split("\\.")).filter(s -> !s.matches("\\d+") && !AUXILIARY_WORDS.contains(s)).collect(Collectors.joining("."));
        return prefix + payload + suffix;
    }

    @Nullable
    private static PsiBinaryExpression breakStringLiteral(PsiLiteralExpression literalExpression, int offset) throws IncorrectOperationException {
        TextRange literalRange = literalExpression.getTextRange();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)literalExpression.getProject()).getElementFactory();
        if (literalRange.getStartOffset() + 1 < offset && offset < literalRange.getEndOffset() - 1) {
            PsiBinaryExpression expression = (PsiBinaryExpression)factory.createExpressionFromText("a + b", (PsiElement)literalExpression);
            String value = (String)literalExpression.getValue();
            int breakIndex = offset - literalRange.getStartOffset() - 1;
            String lsubstring = value.substring(0, breakIndex);
            expression.getLOperand().replace((PsiElement)factory.createExpressionFromText("\"" + lsubstring + "\"", (PsiElement)literalExpression));
            String rsubstring = value.substring(breakIndex);
            expression.getROperand().replace((PsiElement)factory.createExpressionFromText("\"" + rsubstring + "\"", (PsiElement)literalExpression));
            return (PsiBinaryExpression)literalExpression.replace((PsiElement)expression);
        }
        return null;
    }

    private PsiElement replaceStringLiteral(PsiLiteralExpression literalExpression, String i18nizedText) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)literalExpression.getProject()).getElementFactory();
        if (this.mySelectionRange != null) {
            try {
                PsiBinaryExpression binaryExpression = I18nizeQuickFix.breakStringLiteral(literalExpression, this.mySelectionRange.getEndOffset());
                if (binaryExpression != null) {
                    literalExpression = (PsiLiteralExpression)binaryExpression.getLOperand();
                }
                if ((binaryExpression = I18nizeQuickFix.breakStringLiteral(literalExpression, this.mySelectionRange.getStartOffset())) != null) {
                    literalExpression = (PsiLiteralExpression)binaryExpression.getROperand();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        PsiExpression expression = factory.createExpressionFromText(i18nizedText, (PsiElement)literalExpression);
        return literalExpression.replace((PsiElement)expression);
    }
}

