/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrefixReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance(PrefixReferenceProvider.class);

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        XmlAttributeValue value = (XmlAttributeValue)element;
        String s = value.getValue();
        int i = s.indexOf(58);
        if (i <= 0 || s.startsWith("xml:")) {
            return PsiReference.EMPTY_ARRAY;
        }
        return new PsiReference[]{new PrefixReference(value, i)};
    }

    private static class PrefixReference
    extends BasicAttributeValueReference
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        PrefixReference(XmlAttributeValue value, int length) {
            super((PsiElement)value, TextRange.from((int)1, (int)length));
        }

        @Nullable
        public PsiElement resolve() {
            String prefix = this.getCanonicalText();
            for (XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class); tag != null; tag = tag.getParentTag()) {
                if (!tag.getLocalNamespaceDeclarations().containsKey(prefix)) continue;
                XmlAttribute attribute = tag.getAttribute("xmlns:" + prefix, "");
                TextRange textRange = TextRange.from((int)"xmlns:".length(), (int)prefix.length());
                return new SchemaPrefix(attribute, textRange, prefix);
            }
            return null;
        }

        @Override
        public boolean isReferenceTo(@NotNull PsiElement element) {
            PsiElement e;
            if (element instanceof SchemaPrefix && element.getContainingFile() == this.myElement.getContainingFile() && (e = this.resolve()) instanceof SchemaPrefix) {
                String s = ((SchemaPrefix)e).getName();
                return s != null && s.equals(((SchemaPrefix)element).getName());
            }
            return super.isReferenceTo(element);
        }

        public LocalQuickFix @Nullable [] getQuickFixes() {
            PsiElement element = this.getElement();
            XmlElementFactory factory = XmlElementFactory.getInstance((Project)element.getProject());
            String value = ((XmlAttributeValue)element).getValue();
            String[] name = value.split(":");
            XmlTag tag = factory.createTagFromText((CharSequence)("<" + (name.length > 1 ? name[1] : value) + " />"), (Language)XMLLanguage.INSTANCE);
            return new LocalQuickFix[]{XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)tag, this.getCanonicalText(), null)};
        }

        public boolean isSoft() {
            return false;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            return RelaxngBundle.message("undefined.namespace.prefix.0", new Object[0]);
        }
    }
}

