/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.annotation;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.intellij.plugins.relaxNG.model.Define;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OverridingDefineRenderer
extends GutterIconRenderer
implements DumbAware {
    private final Set<? extends Define> mySet;
    private final String myMessage;

    OverridingDefineRenderer(String message, Set<? extends Define> set) {
        this.mySet = set;
        this.myMessage = message;
    }

    @NotNull
    public Icon getIcon() {
        return AllIcons.Gutter.OverridingMethod;
    }

    public boolean isNavigateAction() {
        return true;
    }

    @Nullable
    public AnAction getClickAction() {
        return new MyClickAction();
    }

    @Nullable
    public String getTooltipText() {
        return this.myMessage;
    }

    static void doClickAction(AnActionEvent e, Collection<? extends Define> set, String title) {
        if (set.size() == 1) {
            Navigatable n = (Navigatable)set.iterator().next().getPsiElement();
            OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{n});
        } else {
            Object[] array = set.toArray(new Define[0]);
            NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])ContainerUtil.map((Object[])array, define -> define.getPsiElement(), (Object[])PsiElement.EMPTY_ARRAY)), (String)title).show(new RelativePoint((MouseEvent)e.getInputEvent()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OverridingDefineRenderer that = (OverridingDefineRenderer)((Object)o);
        if (this.myMessage != null ? !this.myMessage.equals(that.myMessage) : that.myMessage != null) {
            return false;
        }
        return !(this.mySet != null ? !this.mySet.equals(that.mySet) : that.mySet != null);
    }

    public int hashCode() {
        int result = this.mySet != null ? this.mySet.hashCode() : 0;
        result = 31 * result + (this.myMessage != null ? this.myMessage.hashCode() : 0);
        return result;
    }

    private class MyClickAction
    extends AnAction {
        private MyClickAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            OverridingDefineRenderer.doClickAction(e, OverridingDefineRenderer.this.mySet, "Go to overridden define");
        }
    }
}

