/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDecl;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncElementImpl;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RncDeclImpl
extends RncElementImpl
implements RncDecl {
    public RncDeclImpl(ASTNode node) {
        super(node);
    }

    @Override
    public String getPrefix() {
        ASTNode ns = this.findIdentifierNode();
        return ns != null ? EscapeUtil.unescapeText(ns) : null;
    }

    @Override
    public String getDeclaredNamespace() {
        ASTNode ns = this.getNode().findChildByType(RncTokenTypes.LITERAL);
        return ns != null ? EscapeUtil.parseLiteralValue(ns) : null;
    }

    public int getTextOffset() {
        ASTNode ns = this.findIdentifierNode();
        if (ns != null) {
            return ns.getStartOffset();
        }
        return super.getTextOffset();
    }

    private ASTNode findIdentifierNode() {
        ASTNode[] nodes;
        ASTNode node = this.getNode().findChildByType(RncTokenTypes.IDENTIFIERS);
        if (node == null && (nodes = this.getNode().getChildren(RncTokenTypes.KEYWORDS)).length > 1) {
            return nodes[1];
        }
        return node;
    }

    public String getName() {
        String s = this.getPrefix();
        return s != null ? s : "";
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode node = this.findIdentifierNode();
        if (node == null) {
            return this;
        }
        node.getTreeParent().replaceChild(node, RenameUtil.createIdentifierNode((PsiManager)this.getManager(), name));
        return this;
    }

    @Override
    public void accept(@NotNull RncElementVisitor visitor) {
        visitor.visitElement(this);
    }
}

