/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlPrefixReferenceProvider
extends PsiReferenceProvider {
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        String type;
        XmlAttributeDescriptor descriptor;
        XmlTag tag;
        XmlAttributeValue attributeValue = (XmlAttributeValue)element;
        String value = attributeValue.getValue();
        if (value == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        int i = value.indexOf(58);
        if (i <= 0) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement parent = attributeValue.getParent();
        if (parent instanceof XmlAttribute && (tag = ((XmlAttribute)parent).getParent()) != null && !XmlNSDescriptorImpl.checkSchemaNamespace(tag) && (descriptor = ((XmlAttribute)parent).getDescriptor()) instanceof XmlAttributeDescriptorImpl && (type = ((XmlAttributeDescriptorImpl)descriptor).getType()) != null && type.endsWith(":QName")) {
            String prefix = XmlUtil.findPrefixByQualifiedName(type);
            String ns = ((XmlTag)descriptor.getDeclaration()).getNamespaceByPrefix(prefix);
            if (XmlNSDescriptorImpl.checkSchemaNamespace(ns)) {
                return new PsiReference[]{new SchemaPrefixReference((XmlElement)attributeValue, TextRange.from((int)1, (int)i), value.substring(0, i), null)};
            }
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

