/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.IncludedXmlTag;
import com.intellij.xml.util.XmlIncludeHandler;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InclusionProvider
implements CachedValueProvider<PsiElement[]> {
    private final XmlTag myXincludeTag;

    InclusionProvider(XmlTag xincludeTag) {
        this.myXincludeTag = xincludeTag;
    }

    public static PsiElement @NotNull [] getIncludedTags(XmlTag xincludeTag) {
        if (!XmlTagImpl.shouldProcessIncludesNow()) {
            IdempotenceChecker.logTrace((String)"!shouldProcessIncludesNow");
            return PsiElement.EMPTY_ARRAY;
        }
        return (PsiElement[])CachedValuesManager.getCachedValue((PsiElement)xincludeTag, (CachedValueProvider)new InclusionProvider(xincludeTag));
    }

    public CachedValueProvider.Result<PsiElement[]> compute() {
        PsiElement[] result = (PsiElement[])RecursionManager.doPreventingRecursion((Object)this.myXincludeTag, (boolean)true, () -> InclusionProvider.computeInclusion(this.myXincludeTag));
        if (result == null) {
            IdempotenceChecker.logTrace((String)"InclusionProvider recursion prevented");
        }
        return CachedValueProvider.Result.create((Object)(result == null ? PsiElement.EMPTY_ARRAY : result), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    }

    private static XmlTag[] extractXpointer(@NotNull XmlTag rootTag, @Nullable String xpointer) {
        String pointer;
        Matcher matcher;
        if (xpointer != null && (matcher = JDOMUtil.XPOINTER_PATTERN.matcher(xpointer)).matches() && (matcher = JDOMUtil.CHILDREN_PATTERN.matcher(pointer = matcher.group(1))).matches() && matcher.group(1).equals(rootTag.getName())) {
            Object[] tags = rootTag.getSubTags();
            String subTagName = matcher.group(2);
            if (subTagName == null) {
                return tags;
            }
            XmlTag subTag = (XmlTag)ContainerUtil.find((Object[])tags, t -> subTagName.substring(1).equals(t.getName()));
            return subTag == null ? XmlTag.EMPTY : subTag.getSubTags();
        }
        return new XmlTag[]{rootTag};
    }

    private static PsiElement @Nullable [] computeInclusion(XmlTag xincludeTag) {
        XmlTag rootTag;
        XmlFile included = XmlIncludeHandler.resolveXIncludeFile(xincludeTag);
        if (IdempotenceChecker.isLoggingEnabled()) {
            IdempotenceChecker.logTrace((String)("InclusionProvider resolved file=" + included));
        }
        XmlDocument document = included != null ? included.getDocument() : null;
        XmlTag xmlTag = rootTag = document != null ? document.getRootTag() : null;
        if (rootTag != null) {
            String xpointer = xincludeTag.getAttributeValue("xpointer", "http://www.w3.org/2001/XInclude");
            XmlTag[] includeTag = InclusionProvider.extractXpointer(rootTag, xpointer);
            if (IdempotenceChecker.isLoggingEnabled()) {
                IdempotenceChecker.logTrace((String)("InclusionProvider found " + includeTag.length + " tags by " + xpointer));
            }
            PsiElement[] result = new PsiElement[includeTag.length];
            for (int i = 0; i < includeTag.length; ++i) {
                result[i] = new IncludedXmlTag(includeTag[i], (PsiElement)xincludeTag.getParentTag());
            }
            return result;
        }
        return null;
    }
}

