/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlTagValueImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.IncludedXmlAttribute;
import com.intellij.xml.util.IncludedXmlElement;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludedXmlTag
extends IncludedXmlElement<XmlTag>
implements XmlTag {
    private static final Logger LOG = Logger.getInstance(IncludedXmlTag.class);

    public IncludedXmlTag(@NotNull XmlTag original, @Nullable PsiElement parent) {
        super(original, parent);
    }

    @Nullable
    public XmlTag getParentTag() {
        return this.getParent() instanceof XmlTag ? (XmlTag)this.getParent() : null;
    }

    @NotNull
    @NonNls
    public String getName() {
        return ((XmlTag)this.getOriginal()).getName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        throw new UnsupportedOperationException("Can't modify included tags");
    }

    @NotNull
    @NonNls
    public String getNamespace() {
        XmlTag original = (XmlTag)this.getOriginal();
        LOG.assertTrue(original.isValid());
        return original.getNamespace();
    }

    @NotNull
    @NonNls
    public String getLocalName() {
        return ((XmlTag)this.getOriginal()).getLocalName();
    }

    @Nullable
    public XmlElementDescriptor getDescriptor() {
        return ((XmlTag)this.getOriginal()).getDescriptor();
    }

    public XmlAttribute @NotNull [] getAttributes() {
        XmlAttribute[] original = ((XmlTag)this.getOriginal()).getAttributes();
        XmlAttribute[] attributes = new XmlAttribute[original.length];
        for (int i = 0; i < original.length; ++i) {
            XmlAttribute attribute = original[i];
            attributes[i] = new IncludedXmlAttribute(attribute, this);
        }
        return attributes;
    }

    @Nullable
    public XmlAttribute getAttribute(@NonNls String name, @NonNls String namespace) {
        XmlAttribute attribute = ((XmlTag)this.getOriginal()).getAttribute(name, namespace);
        return attribute == null ? null : new IncludedXmlAttribute(attribute, this);
    }

    @Nullable
    public XmlAttribute getAttribute(@NonNls String qname) {
        XmlAttribute attribute = ((XmlTag)this.getOriginal()).getAttribute(qname);
        return attribute == null ? null : new IncludedXmlAttribute(attribute, this);
    }

    @Nullable
    public String getAttributeValue(@NonNls String name, @NonNls String namespace) {
        return ((XmlTag)this.getOriginal()).getAttributeValue(name, namespace);
    }

    @Nullable
    public String getAttributeValue(@NonNls String qname) {
        return ((XmlTag)this.getOriginal()).getAttributeValue(qname);
    }

    public XmlAttribute setAttribute(@NonNls String name, @NonNls String namespace, @NonNls String value) throws IncorrectOperationException {
        throw new UnsupportedOperationException("Can't modify included tags");
    }

    public XmlAttribute setAttribute(@NonNls String qname, @NonNls String value) throws IncorrectOperationException {
        throw new UnsupportedOperationException("Can't modify included tags");
    }

    public XmlTag createChildTag(@NonNls String localName, @NonNls String namespace, @Nullable @NonNls String bodyText, boolean enforceNamespacesDeep) {
        return ((XmlTag)this.getOriginal()).createChildTag(localName, namespace, bodyText, enforceNamespacesDeep);
    }

    public XmlTag addSubTag(XmlTag subTag, boolean first) {
        throw new UnsupportedOperationException("Can't modify included tags");
    }

    public XmlTag @NotNull [] getSubTags() {
        return this.wrapTags(((XmlTag)this.getOriginal()).getSubTags());
    }

    private XmlTag[] wrapTags(XmlTag[] original) {
        XmlTag[] result = new XmlTag[original.length];
        for (int i = 0; i < original.length; ++i) {
            result[i] = new IncludedXmlTag(original[i], (PsiElement)this);
        }
        return result;
    }

    public XmlTag @NotNull [] findSubTags(@NonNls String qname) {
        return this.wrapTags(((XmlTag)this.getOriginal()).findSubTags(qname));
    }

    public XmlTag @NotNull [] findSubTags(@NonNls String localName, @NonNls String namespace) {
        return this.wrapTags(((XmlTag)this.getOriginal()).findSubTags(localName, namespace));
    }

    @Nullable
    public XmlTag findFirstSubTag(@NonNls String qname) {
        XmlTag tag = ((XmlTag)this.getOriginal()).findFirstSubTag(qname);
        return tag == null ? null : new IncludedXmlTag(tag, (PsiElement)this);
    }

    @NotNull
    @NonNls
    public String getNamespacePrefix() {
        return ((XmlTag)this.getOriginal()).getNamespacePrefix();
    }

    @NotNull
    @NonNls
    public String getNamespaceByPrefix(@NonNls String prefix) {
        return ((XmlTag)this.getOriginal()).getNamespaceByPrefix(prefix);
    }

    @Nullable
    public String getPrefixByNamespace(@NonNls String namespace) {
        return ((XmlTag)this.getOriginal()).getPrefixByNamespace(namespace);
    }

    public String[] knownNamespaces() {
        return ((XmlTag)this.getOriginal()).knownNamespaces();
    }

    public boolean hasNamespaceDeclarations() {
        return ((XmlTag)this.getOriginal()).hasNamespaceDeclarations();
    }

    @NotNull
    public Map<String, String> getLocalNamespaceDeclarations() {
        return ((XmlTag)this.getOriginal()).getLocalNamespaceDeclarations();
    }

    @NotNull
    public XmlTagValue getValue() {
        return XmlTagValueImpl.createXmlTagValue(this);
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(@NonNls String namespace, boolean strict) {
        return ((XmlTag)this.getOriginal()).getNSDescriptor(namespace, strict);
    }

    public boolean isEmpty() {
        return ((XmlTag)this.getOriginal()).isEmpty();
    }

    public void collapseIfEmpty() {
        throw new UnsupportedOperationException("Can't modify included tags");
    }

    @Nullable
    @NonNls
    public String getSubTagText(@NonNls String qname) {
        return ((XmlTag)this.getOriginal()).getSubTagText(qname);
    }

    public PsiMetaData getMetaData() {
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        return null;
    }

    public XmlTagChild getPrevSiblingInTag() {
        return null;
    }
}

