/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckEmptyTagInspection
extends XmlSuppressableInspectionTool {
    @NonNls
    private static final Set<String> ourTagsWithEmptyEndsNotAllowed = ContainerUtil.set((Object[])new String[]{"script", "div", "iframe"});

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (XmlExtension.shouldIgnoreSelfClosingTag(tag) || !CheckEmptyTagInspection.isTagWithEmptyEndNotAllowed(tag)) {
                    return;
                }
                if (XmlChildRole.EMPTY_TAG_END_FINDER.findChild(tag.getNode()) == null || !CheckEmptyTagInspection.tagIsWellFormed(tag)) {
                    return;
                }
                MyLocalQuickFix fix = new MyLocalQuickFix();
                holder.registerProblem((PsiElement)tag, XmlAnalysisBundle.message((String)"html.inspections.check.empty.script.message", (Object[])new Object[0]), tag.getContainingFile().getContext() != null ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
            }
        };
    }

    public static boolean isTagWithEmptyEndNotAllowed(XmlTag tag) {
        String tagName = tag.getName();
        if (tag instanceof HtmlTag) {
            tagName = StringUtil.toLowerCase((String)tagName);
        }
        Language language = tag.getLanguage();
        return ourTagsWithEmptyEndsNotAllowed.contains(tagName) && (language.isKindOf((Language)HTMLLanguage.INSTANCE) || language.isKindOf((Language)XHTMLLanguage.INSTANCE)) || language.isKindOf((Language)HTMLLanguage.INSTANCE) && !HtmlUtil.isSingleHtmlTag(tag, false) && tagName.indexOf(58) == -1 && !XmlExtension.isCollapsible(tag);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "CheckEmptyScriptTag";
    }

    public static boolean tagIsWellFormed(XmlTag tag) {
        PsiElement[] children;
        boolean ok = false;
        for (PsiElement child : children = tag.getChildren()) {
            if (child instanceof XmlToken) {
                IElementType tokenType = ((XmlToken)child).getTokenType();
                if (tokenType.equals(XmlTokenType.XML_EMPTY_ELEMENT_END) && "/>".equals(child.getText())) {
                    ok = true;
                    continue;
                }
                if (!tokenType.equals(XmlTokenType.XML_END_TAG_START)) continue;
                ok = true;
                continue;
            }
            if (!(child instanceof OuterLanguageElement)) continue;
            return false;
        }
        return ok;
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private MyLocalQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            return XmlAnalysisBundle.message((String)"html.inspections.check.empty.script.tag.fix.message", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlTag tag = (XmlTag)descriptor.getPsiElement();
            if (tag == null) {
                return;
            }
            XmlUtil.expandTag(tag);
        }
    }
}

