/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.refactoring;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.PossiblePrefixReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaPrefixRenameHandler
extends VariableInplaceRenameHandler {
    @Nullable
    private static PossiblePrefixReference getReference(PsiFile file, Editor editor) {
        int offset;
        PsiReference reference;
        if (file != null && editor != null && (reference = file.findReferenceAt(offset = editor.getCaretModel().getOffset())) instanceof PossiblePrefixReference) {
            return (PossiblePrefixReference)reference;
        }
        return null;
    }

    protected boolean isAvailable(@Nullable PsiElement element, @NotNull Editor editor, @NotNull PsiFile file) {
        PossiblePrefixReference ref = SchemaPrefixRenameHandler.getReference(file, editor);
        return ref != null && ref.resolve() instanceof SchemaPrefix;
    }

    protected VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, @NotNull Editor editor) {
        PsiElement prefix;
        PossiblePrefixReference reference = SchemaPrefixRenameHandler.getReference(elementToRename.getContainingFile(), editor);
        if (reference != null && (prefix = reference.resolve()) instanceof SchemaPrefix) {
            return new VariableInplaceRenamer((PsiNamedElement)prefix, editor){

                protected void addReferenceAtCaret(Collection<PsiReference> refs) {
                }

                protected boolean isReferenceAtCaret(PsiElement selectedElement, PsiReference ref) {
                    return false;
                }
            };
        }
        return null;
    }
}

