/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdTagNameBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class XmlTagNamesIndex
extends XmlIndex<Void> {
    static final ID<String, Void> NAME = ID.create((String)"XmlTagNames");

    public static Collection<VirtualFile> getFilesByTagName(String tagName, Project project) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)tagName, XmlTagNamesIndex.createFilter(project));
    }

    public static Collection<String> getAllTagNames(Project project) {
        return FileBasedIndex.getInstance().getAllKeys(NAME, project);
    }

    @NotNull
    public ID<String, Void> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return new DataIndexer<String, Void, FileContent>(){

            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                CharSequence text = inputData.getContentAsText();
                if (StringUtil.indexOf((CharSequence)text, (CharSequence)"http://www.w3.org/2001/XMLSchema") == -1) {
                    return Collections.emptyMap();
                }
                Collection<String> tags = XsdTagNameBuilder.computeTagNames(CharArrayUtil.readerFromCharSequence((CharSequence)text));
                HashMap<String, Void> map = new HashMap<String, Void>(tags.size());
                for (String tag : tags) {
                    map.put(tag, null);
                }
                return map;
            }
        };
    }

    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        return VoidDataExternalizer.INSTANCE;
    }
}

