/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.search.SearchRequest;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlNamedReferenceHost;
import com.intellij.util.SmartList;
import com.intellij.xml.XmlNamedReferenceProviderBean;
import com.intellij.xml.impl.NamedReferenceProviders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class XmlNamedReferenceProvider
implements PsiSymbolReferenceProvider {
    @NotNull
    public Collection<? extends PsiSymbolReference> getReferences(@NotNull PsiExternalReferenceHost element, @NotNull PsiSymbolReferenceHints hints) {
        if (!(element instanceof XmlNamedReferenceHost)) {
            return Collections.emptyList();
        }
        XmlNamedReferenceHost host = (XmlNamedReferenceHost)element;
        Collection<XmlNamedReferenceProviderBean> beans = NamedReferenceProviders.getInstance().getNamedReferenceProviderBeans(host);
        SmartList result = new SmartList();
        for (XmlNamedReferenceProviderBean bean : beans) {
            result.addAll(((PsiSymbolReferenceProvider)bean.getInstance()).getReferences(element, hints));
        }
        return result;
    }

    @NotNull
    public @NotNull Collection<? extends @NotNull SearchRequest> getSearchRequests(@NotNull Project project, @NotNull Symbol target) {
        ArrayList result = new ArrayList();
        for (PsiSymbolReferenceProvider provider : NamedReferenceProviders.getInstance().getNamedReferenceProviders(target)) {
            result.addAll(provider.getSearchRequests(project, target));
        }
        return result;
    }
}

