/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.validate;

import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.ui.content.MessageView;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.actions.validate.ErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXParseException;

public class StdErrorReporter
extends ErrorReporter {
    private static final Logger LOG = Logger.getInstance(StdErrorReporter.class);
    private static final Key<NewErrorTreeViewPanel> KEY = Key.create((String)"ValidateXmlAction.KEY");
    private final NewErrorTreeViewPanel myErrorsView;
    private final String myContentName;
    private final Project myProject;

    public StdErrorReporter(ValidateXmlActionHandler handler, PsiFile psiFile, Runnable rerunAction) {
        super(handler);
        this.myProject = psiFile.getProject();
        this.myContentName = XmlBundle.message((String)"xml.validate.tab.content.title", (Object[])new Object[]{psiFile.getName()});
        this.myErrorsView = new NewErrorTreeViewPanel(this.myProject, null, true, true, rerunAction);
        this.myErrorsView.getEmptyText().setText(XmlBundle.message((String)"no.errors.found", (Object[])new Object[0]));
    }

    @Override
    public void startProcessing() {
        MyProcessController processController = new MyProcessController();
        this.myErrorsView.setProcessController((NewErrorTreeViewPanel.ProcessController)processController);
        this.openMessageView();
        processController.setFuture(ApplicationManager.getApplication().executeOnPooledThread(() -> ApplicationManager.getApplication().runReadAction(() -> super.startProcessing())));
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Messages").activate(null);
    }

    private void openMessageView() {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            MessageView messageView = MessageView.SERVICE.getInstance((Project)this.myProject);
            Content content = ContentFactory.SERVICE.getInstance().createContent(this.myErrorsView.getComponent(), this.myContentName, true);
            content.putUserData(KEY, (Object)this.myErrorsView);
            messageView.getContentManager().addContent(content);
            messageView.getContentManager().setSelectedContent(content);
            messageView.getContentManager().addContentManagerListener((ContentManagerListener)new CloseListener(content, messageView.getContentManager()));
            ContentManagerUtil.cleanupContents((Content)content, (Project)this.myProject, (String)this.myContentName);
            messageView.getContentManager().addContentManagerListener((ContentManagerListener)new MyContentDisposer(content, messageView));
        }, XmlBundle.message((String)"validate.xml.open.message.view.command.name", (Object[])new Object[0]), null);
    }

    @Override
    public void processError(SAXParseException ex, ValidateXmlActionHandler.ProblemType problemType) {
        if (LOG.isDebugEnabled()) {
            String error = this.myHandler.buildMessageString(ex);
            LOG.debug("enter: processError(error='" + error + "')");
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile file = this.myHandler.getProblemFile(ex);
            this.myErrorsView.addMessage(problemType == ValidateXmlActionHandler.ProblemType.WARNING ? 5 : 4, new String[]{ex.getLocalizedMessage()}, file, ex.getLineNumber() - 1, ex.getColumnNumber() - 1, null);
        });
    }

    private static class MyProcessController
    implements NewErrorTreeViewPanel.ProcessController {
        private Future<?> myFuture;

        private MyProcessController() {
        }

        public void setFuture(Future<?> future) {
            this.myFuture = future;
        }

        public void stopProcess() {
            if (this.myFuture != null) {
                this.myFuture.cancel(true);
            }
        }

        public boolean isProcessStopped() {
            return this.myFuture != null && this.myFuture.isDone();
        }
    }

    private class CloseListener
    implements ContentManagerListener {
        private Content myContent;
        private final ContentManager myContentManager;

        CloseListener(Content content, ContentManager contentManager) {
            this.myContent = content;
            this.myContentManager = contentManager;
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            if (event.getContent() == this.myContent) {
                StdErrorReporter.this.myErrorsView.stopProcess();
                this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                this.myContent.release();
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
            int result;
            if (event.getContent() == this.myContent && !StdErrorReporter.this.myErrorsView.isProcessStopped() && (result = Messages.showYesNoDialog((String)XmlBundle.message((String)"xml.validate.validation.is.running.terminate.confirmation.text", (Object[])new Object[0]), (String)XmlBundle.message((String)"xml.validate.validation.is.running.terminate.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                event.consume();
            }
        }
    }

    private static class MyContentDisposer
    implements ContentManagerListener {
        private final Content myContent;
        private final MessageView myMessageView;

        MyContentDisposer(Content content, MessageView messageView) {
            this.myContent = content;
            this.myMessageView = messageView;
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            Content eventContent = event.getContent();
            if (!eventContent.equals(this.myContent)) {
                return;
            }
            this.myMessageView.getContentManager().removeContentManagerListener((ContentManagerListener)this);
            NewErrorTreeViewPanel errorTreeView = (NewErrorTreeViewPanel)eventContent.getUserData(KEY);
            if (errorTreeView != null) {
                Disposer.dispose((Disposable)errorTreeView);
            }
            eventContent.putUserData(KEY, null);
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
        }
    }
}

