/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.NotNull;

public class EscapeEntitiesAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler {
    private static String escape(XmlFile file, TIntObjectHashMap<String> map, String text, int start) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String escape;
            char c = text.charAt(i);
            PsiElement element = file.findElementAt(start + i);
            if (element != null && EscapeEntitiesAction.isCharacterElement(element) && (c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'' || c > '\u007f') && (escape = (String)map.get((int)c)) != null) {
                result.append("&").append(escape).append(";");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @NotNull
    private static TIntObjectHashMap<String> computeMap(XmlFile xmlFile) {
        XmlFile file = XmlUtil.findXmlFile((PsiFile)xmlFile, Html5SchemaProvider.getCharsDtdLocation());
        assert (file != null);
        TIntObjectHashMap result = new TIntObjectHashMap();
        XmlUtil.processXmlElements((XmlElement)file, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element -> {
            String value;
            int key;
            if (element instanceof XmlEntityDecl && !result.containsKey(key = Integer.parseInt((value = ((XmlEntityDecl)element).getValueElement().getValue()).substring(2, value.length() - 1)))) {
                result.put(key, (Object)((XmlEntityDecl)element).getName());
            }
            return true;
        }), true);
        return result;
    }

    private static boolean isCharacterElement(PsiElement element) {
        IElementType type = element.getNode().getElementType();
        if (type == XmlTokenType.XML_DATA_CHARACTERS) {
            return true;
        }
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && element.getParent().getParent() instanceof XmlAttribute) {
            return true;
        }
        if (type == XmlTokenType.XML_BAD_CHARACTER) {
            return true;
        }
        if (type == XmlTokenType.XML_START_TAG_START) {
            if (element.getNextSibling() instanceof PsiErrorElement) {
                return true;
            }
            if (element.getParent() instanceof PsiErrorElement) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        return file instanceof XmlFile;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return this;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int[] starts = editor.getSelectionModel().getBlockSelectionStarts();
        int[] ends = editor.getSelectionModel().getBlockSelectionEnds();
        Document document = editor.getDocument();
        XmlFile xmlFile = (XmlFile)file;
        TIntObjectHashMap<String> map = EscapeEntitiesAction.computeMap(xmlFile);
        for (int i = starts.length - 1; i >= 0; --i) {
            String newText;
            int start = starts[i];
            int end = ends[i];
            String oldText = document.getText(new TextRange(start, end));
            if (oldText.equals(newText = EscapeEntitiesAction.escape(xmlFile, map, oldText, start))) continue;
            document.replaceString(start, end, (CharSequence)newText);
        }
    }
}

