/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.xml.XmlAttributeDelegate;
import com.intellij.psi.impl.source.xml.XmlStubBasedElement;
import com.intellij.psi.impl.source.xml.stub.XmlAttributeStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class XmlStubBasedAttributeBase<StubT extends XmlAttributeStub<?>>
extends XmlStubBasedElement<StubT>
implements XmlAttribute,
HintedReferenceHost,
StubBasedPsiElement<StubT> {
    @Nullable
    private volatile XmlAttributeDelegate myImpl;

    public XmlStubBasedAttributeBase(@NotNull StubT stub, @NotNull IStubElementType<? extends StubT, ? extends XmlAttribute> nodeType) {
        super(stub, nodeType);
    }

    public XmlStubBasedAttributeBase(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    private XmlAttributeDelegate getImpl() {
        XmlAttributeDelegate impl = this.myImpl;
        if (impl != null) {
            return impl;
        }
        this.myImpl = impl = this.createDelegate();
        return impl;
    }

    @NotNull
    protected XmlAttributeDelegate createDelegate() {
        return new XmlStubBasedAttributeBaseDelegate();
    }

    public XmlAttributeValue getValueElement() {
        return (XmlAttributeValue)XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this.getNode());
    }

    public void setValue(@NotNull String valueText) throws IncorrectOperationException {
        this.getImpl().setValue(valueText);
    }

    public XmlElement getNameElement() {
        return (XmlElement)XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(this.getNode());
    }

    @NotNull
    public String getNamespace() {
        return this.getImpl().getNamespace();
    }

    @NonNls
    @NotNull
    public String getNamespacePrefix() {
        return XmlUtil.findPrefixByQualifiedName(this.getName());
    }

    public XmlTag getParent() {
        PsiElement parentTag = super.getParent();
        return parentTag instanceof XmlTag ? (XmlTag)parentTag : null;
    }

    @Override
    public PsiElement getContext() {
        XmlAttributeStub stub = (XmlAttributeStub)this.getStub();
        if (stub != null && !(stub instanceof PsiFileStub)) {
            return stub.getParentStub().getPsi();
        }
        return super.getParent();
    }

    @NotNull
    public String getLocalName() {
        return XmlUtil.findLocalNameByQualifiedName(this.getName());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttribute((XmlAttribute)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getValue() {
        XmlAttributeValue valueElement = this.getValueElement();
        return valueElement != null ? valueElement.getValue() : null;
    }

    @Nullable
    public String getDisplayValue() {
        XmlAttributeDelegate.VolatileState state = this.getImpl().getFreshState();
        return state == null ? null : state.myDisplayText;
    }

    public int physicalToDisplay(int physicalIndex) {
        return this.getImpl().physicalToDisplay(physicalIndex);
    }

    public int displayToPhysical(int displayIndex) {
        return this.getImpl().displayToPhysical(displayIndex);
    }

    @NotNull
    public TextRange getValueTextRange() {
        XmlAttributeDelegate.VolatileState state = this.getImpl().getFreshState();
        return state == null ? TextRange.EMPTY_RANGE : state.myValueTextRange;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myImpl = null;
    }

    @NotNull
    public String getName() {
        XmlElement element = this.getNameElement();
        return element != null ? element.getText() : "";
    }

    public boolean isNamespaceDeclaration() {
        String name = this.getName();
        return name.startsWith("xmlns:") || name.equals("xmlns");
    }

    @NotNull
    public PsiElement setName(@NotNull String nameText) throws IncorrectOperationException {
        return this.getImpl().setName(nameText);
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences(PsiReferenceService.Hints.NO_HINTS));
    }

    @Deprecated
    public final PsiReference @NotNull [] getReferences() {
        return this.getReferences(PsiReferenceService.Hints.NO_HINTS);
    }

    public PsiReference @NotNull [] getReferences(@NotNull PsiReferenceService.Hints hints) {
        return this.getImpl().getDefaultReferences(hints);
    }

    public boolean shouldAskParentForReferences(@NotNull PsiReferenceService.Hints hints) {
        return false;
    }

    @Nullable
    public XmlAttributeDescriptor getDescriptor() {
        return this.getImpl().getDescriptor();
    }

    protected class XmlStubBasedAttributeBaseDelegate
    extends XmlAttributeDelegate {
        public XmlStubBasedAttributeBaseDelegate() {
            super(XmlStubBasedAttributeBase.this);
        }
    }
}

