/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.xml.XmlAttributeDelegate;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeImpl
extends XmlElementImpl
implements XmlAttribute,
HintedReferenceHost {
    private static final Logger LOG = Logger.getInstance(XmlAttributeImpl.class);
    private final int myHC = ourHC++;
    @Nullable
    private volatile XmlAttributeDelegate myImpl;

    public final int hashCode() {
        return this.myHC;
    }

    public XmlAttributeImpl() {
        super(XmlElementType.XML_ATTRIBUTE);
    }

    protected XmlAttributeImpl(@NotNull IElementType elementType) {
        super(elementType);
    }

    @NotNull
    private XmlAttributeDelegate getImpl() {
        XmlAttributeDelegate impl = this.myImpl;
        if (impl != null) {
            return impl;
        }
        this.myImpl = impl = this.createDelegate();
        return impl;
    }

    @NotNull
    protected XmlAttributeDelegate createDelegate() {
        return new XmlAttributeImplDelegate();
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == XmlTokenType.XML_NAME) {
            return 229;
        }
        if (i == XmlElementType.XML_ATTRIBUTE_VALUE) {
            return 243;
        }
        return 0;
    }

    public XmlAttributeValue getValueElement() {
        return (XmlAttributeValue)XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild((ASTNode)this);
    }

    public void setValue(@NotNull String valueText) throws IncorrectOperationException {
        this.getImpl().setValue(valueText);
    }

    public XmlElement getNameElement() {
        ASTNode child = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild((ASTNode)this);
        return child == null ? null : (XmlElement)child.getPsi();
    }

    @NotNull
    public String getNamespace() {
        return this.getImpl().getNamespace();
    }

    @NonNls
    @NotNull
    public String getNamespacePrefix() {
        return XmlUtil.findPrefixByQualifiedName(this.getName());
    }

    public XmlTag getParent() {
        PsiElement parentTag = super.getParent();
        return parentTag instanceof XmlTag ? (XmlTag)parentTag : null;
    }

    @NotNull
    public String getLocalName() {
        return XmlUtil.findLocalNameByQualifiedName(this.getName());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttribute((XmlAttribute)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getValue() {
        XmlAttributeValue valueElement = this.getValueElement();
        return valueElement != null ? valueElement.getValue() : null;
    }

    @Nullable
    public String getDisplayValue() {
        XmlAttributeDelegate.VolatileState state = this.getImpl().getFreshState();
        return state == null ? null : state.myDisplayText;
    }

    public int physicalToDisplay(int physicalIndex) {
        return this.getImpl().physicalToDisplay(physicalIndex);
    }

    public int displayToPhysical(int displayIndex) {
        return this.getImpl().displayToPhysical(displayIndex);
    }

    @NotNull
    public TextRange getValueTextRange() {
        XmlAttributeDelegate.VolatileState state = this.getImpl().getFreshState();
        return state == null ? TextRange.EMPTY_RANGE : state.myValueTextRange;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myImpl = null;
    }

    @NotNull
    public String getName() {
        XmlElement element = this.getNameElement();
        return element != null ? element.getText() : "";
    }

    public boolean isNamespaceDeclaration() {
        String name = this.getName();
        return name.startsWith("xmlns:") || name.equals("xmlns");
    }

    @NotNull
    public PsiElement setName(@NotNull String nameText) throws IncorrectOperationException {
        return this.getImpl().setName(nameText);
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences(PsiReferenceService.Hints.NO_HINTS));
    }

    public boolean shouldAskParentForReferences(@NotNull PsiReferenceService.Hints hints) {
        return false;
    }

    @Deprecated
    public final PsiReference @NotNull [] getReferences() {
        return this.getReferences(PsiReferenceService.Hints.NO_HINTS);
    }

    public PsiReference @NotNull [] getReferences(@NotNull PsiReferenceService.Hints hints) {
        return this.getImpl().getDefaultReferences(hints);
    }

    @Nullable
    public XmlAttributeDescriptor getDescriptor() {
        return this.getImpl().getDescriptor();
    }

    @NotNull
    public static String getRealName(@NotNull XmlAttribute attribute) {
        String name = attribute.getLocalName();
        return name.endsWith("IntellijIdeaRulezzz") ? name.substring(0, name.length() - "IntellijIdeaRulezzz".length()) : name;
    }

    protected class XmlAttributeImplDelegate
    extends XmlAttributeDelegate {
        public XmlAttributeImplDelegate() {
            super(XmlAttributeImpl.this);
        }
    }
}

