/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.impl.schema.XsdNsDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

class CreateXmlElementIntentionAction
implements IntentionAction {
    private final String myMessageKey;
    protected final TypeOrElementOrAttributeReference myRef;
    private boolean myIsAvailableEvaluated;
    private XmlFile myTargetFile;
    private final String myDeclarationTagName;

    CreateXmlElementIntentionAction(@PropertyKey(resourceBundle="messages.XmlAnalysisBundle") String messageKey, @NonNls @NotNull String declarationTagName, TypeOrElementOrAttributeReference ref) {
        this.myMessageKey = messageKey;
        this.myRef = ref;
        this.myDeclarationTagName = declarationTagName;
    }

    @NotNull
    public String getText() {
        return XmlAnalysisBundle.message((String)this.myMessageKey, (Object[])new Object[]{XmlUtil.findLocalNameByQualifiedName(this.myRef.getCanonicalText())});
    }

    @NotNull
    public String getFamilyName() {
        return XmlBundle.message((String)"xml.create.xml.declaration.intention.type", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!this.myIsAvailableEvaluated) {
            XsdNsDescriptor descriptor;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myRef.getElement(), XmlTag.class);
            if (tag != null && (descriptor = this.myRef.getDescriptor(tag, this.myRef.getCanonicalText(), new boolean[1])) != null && descriptor.getDescriptorFile() != null && descriptor.getDescriptorFile().isWritable()) {
                this.myTargetFile = descriptor.getDescriptorFile();
            }
            this.myIsAvailableEvaluated = true;
        }
        return this.myTargetFile != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        XmlTag rootTag = this.myTargetFile.getDocument().getRootTag();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, this.myTargetFile.getVirtualFile(), rootTag.getValue().getTextRange().getEndOffset());
        Editor targetEditor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        Template template = manager.createTemplate("", "");
        this.addTextTo(template, rootTag);
        manager.startTemplate(targetEditor, template);
    }

    protected void addTextTo(Template template, XmlTag rootTag) {
        String schemaPrefix = rootTag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema");
        if (!schemaPrefix.isEmpty()) {
            schemaPrefix = schemaPrefix + ":";
        }
        template.addTextSegment("<" + schemaPrefix + this.myDeclarationTagName + " name=\"" + XmlUtil.findLocalNameByQualifiedName(this.myRef.getCanonicalText()) + "\">");
        template.addEndVariable();
        template.addTextSegment("</" + schemaPrefix + this.myDeclarationTagName + ">\n");
        template.setToReformat(true);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

