/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.html.HtmlLikeFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlFileImpl
extends XmlFileImpl
implements FileReferenceResolver,
HtmlLikeFile {
    public HtmlFileImpl(FileViewProvider provider) {
        this(provider, XmlElementType.HTML_FILE);
    }

    public HtmlFileImpl(FileViewProvider provider, IFileElementType type) {
        super(provider, (IElementType)type);
    }

    @Override
    public String toString() {
        return "HtmlFile:" + this.getName();
    }

    @Override
    public XmlDocument getDocument() {
        FileElement treeElement = this.calcTreeElement();
        ASTNode node = treeElement.findChildByType(XmlElementType.HTML_DOCUMENT);
        return node != null ? (XmlDocument)node.getPsi() : null;
    }

    @Nullable
    public PsiFileSystemItem resolveFileReference(@NotNull FileReference reference, @NotNull String name) {
        VirtualFile file = this.getVirtualFile();
        if (!(file instanceof HttpVirtualFile)) {
            return null;
        }
        VirtualFile parent = file;
        if (!parent.isDirectory() && (parent = parent.getParent()) == null) {
            parent = file;
        }
        VirtualFile childFile = parent.findChild(name);
        HttpFileSystem fileSystem = (HttpFileSystem)parent.getFileSystem();
        if (childFile == null) {
            childFile = fileSystem.createChild(parent, name, !reference.isLast());
        }
        if (childFile.isDirectory()) {
            VirtualFile childParent = childFile;
            FileReference[] references = reference.getFileReferenceSet().getAllReferences();
            int n = references.length;
            for (int i = reference.getIndex() + 1; i < n; ++i) {
                FileReference childReference = references[i];
                childParent = fileSystem.createChild(childParent, childReference.decode(childReference.getText()), i != n - 1);
            }
            return this.getManager().findDirectory(childFile);
        }
        return this.getManager().findFile(childFile);
    }

    public Collection<Object> getVariants(@NotNull FileReference reference) {
        return Collections.emptyList();
    }
}

