/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.navigation.RelatedToHtmlFilesContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HtmlGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        PsiFile file = context.getContainingFile();
        if (file == null || !HtmlGotoRelatedProvider.isAvailable(file)) {
            return Collections.emptyList();
        }
        return HtmlGotoRelatedProvider.getRelatedFiles(file);
    }

    private static boolean isAvailable(@NotNull PsiFile psiFile) {
        for (PsiFile file : psiFile.getViewProvider().getAllFiles()) {
            Language language = file.getLanguage();
            if (!language.isKindOf((Language)HTMLLanguage.INSTANCE) && !language.isKindOf((Language)XHTMLLanguage.INSTANCE)) continue;
            return true;
        }
        return false;
    }

    private static List<? extends GotoRelatedItem> getRelatedFiles(@NotNull PsiFile file) {
        ArrayList<GotoRelatedItem> items = new ArrayList<GotoRelatedItem>();
        for (PsiFile psiFile : file.getViewProvider().getAllFiles()) {
            if (!(psiFile instanceof XmlFile)) continue;
            XmlFile xmlFile = (XmlFile)psiFile;
            for (RelatedToHtmlFilesContributor contributor : RelatedToHtmlFilesContributor.EP_NAME.getExtensionList()) {
                HashSet resultSet = new HashSet();
                contributor.fillRelatedFiles(xmlFile, resultSet);
                for (PsiFile f : resultSet) {
                    items.add(new GotoRelatedItem((PsiElement)f, contributor.getGroupName()));
                }
            }
        }
        return items;
    }
}

