/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public class HtmlQuotesFormatPreprocessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range) {
        PsiElement psiElement = node.getPsi();
        if (psiElement != null && psiElement.isValid() && psiElement.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE)) {
            PsiFile file = psiElement.getContainingFile();
            PsiElement fileContext = file.getContext();
            String contextQuote = fileContext != null ? Character.toString(fileContext.getText().charAt(0)) : null;
            CodeStyleSettings rootSettings = CodeStyle.getSettings((PsiFile)file);
            HtmlCodeStyleSettings htmlSettings = (HtmlCodeStyleSettings)rootSettings.getCustomSettings(HtmlCodeStyleSettings.class);
            CodeStyleSettings.QuoteStyle quoteStyle = htmlSettings.HTML_QUOTE_STYLE;
            if (quoteStyle != CodeStyleSettings.QuoteStyle.None && htmlSettings.HTML_ENFORCE_QUOTES && !StringUtil.equals((CharSequence)quoteStyle.quote, (CharSequence)contextQuote)) {
                PostFormatProcessorHelper postFormatProcessorHelper = new PostFormatProcessorHelper(rootSettings.getCommonSettings((Language)HTMLLanguage.INSTANCE));
                postFormatProcessorHelper.setResultTextRange(range);
                HtmlQuotesConverter converter = new HtmlQuotesConverter(quoteStyle, psiElement, postFormatProcessorHelper);
                Document document = converter.getDocument();
                if (document != null) {
                    DocumentUtil.executeInBulk((Document)document, (boolean)true, (Runnable)converter);
                }
                return postFormatProcessorHelper.getResultTextRange();
            }
        }
        return range;
    }

    public static class HtmlQuotesConverter
    extends XmlRecursiveElementVisitor
    implements Runnable {
        private final TextRange myOriginalRange;
        private final Document myDocument;
        private final PsiDocumentManager myDocumentManager;
        private final PostFormatProcessorHelper myPostProcessorHelper;
        private final PsiElement myContext;
        private final String myNewQuote;

        public HtmlQuotesConverter(@NotNull CodeStyleSettings.QuoteStyle style, @NotNull PsiElement context, @NotNull PostFormatProcessorHelper postFormatProcessorHelper) {
            this.myPostProcessorHelper = postFormatProcessorHelper;
            Project project = context.getProject();
            PsiFile file = context.getContainingFile();
            this.myContext = context;
            this.myOriginalRange = postFormatProcessorHelper.getResultTextRange();
            this.myDocumentManager = PsiDocumentManager.getInstance((Project)project);
            this.myDocument = file.getViewProvider().getDocument();
            switch (style) {
                case Single: {
                    this.myNewQuote = "'";
                    break;
                }
                case Double: {
                    this.myNewQuote = "\"";
                    break;
                }
                default: {
                    this.myNewQuote = String.valueOf(0);
                }
            }
        }

        public Document getDocument() {
            return this.myDocument;
        }

        public void visitXmlAttributeValue(XmlAttributeValue value) {
            PsiElement child;
            if (this.myOriginalRange.contains(value.getTextRange()) && (child = value.getFirstChild()) != null && !this.containsQuoteChars(value)) {
                if (child.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                    CharSequence delimiterChars;
                    PsiElement lastChild = value.getLastChild();
                    if (lastChild != null && lastChild.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && (delimiterChars = child.getNode().getChars()).length() == 1 && !StringUtil.equals((CharSequence)delimiterChars, (CharSequence)this.myNewQuote)) {
                        int startOffset = value.getTextRange().getStartOffset();
                        int endOffset = value.getTextRange().getEndOffset();
                        this.replaceString(startOffset, startOffset + 1, this.myNewQuote);
                        this.replaceString(endOffset - 1, endOffset, this.myNewQuote);
                    }
                } else if (child.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && child == value.getLastChild()) {
                    this.insertString(child.getTextRange().getStartOffset(), this.myNewQuote);
                    this.insertString(child.getTextRange().getEndOffset(), this.myNewQuote);
                }
            }
        }

        private void replaceString(int start, int end, String newValue) {
            int mappedStart = this.myPostProcessorHelper.mapOffset(start);
            int mappedEnd = this.myPostProcessorHelper.mapOffset(end);
            this.myDocument.replaceString(mappedStart, mappedEnd, (CharSequence)newValue);
            this.myPostProcessorHelper.updateResultRange(end - start, newValue.length());
        }

        private void insertString(int offset, String value) {
            int mappedOffset = this.myPostProcessorHelper.mapOffset(offset);
            this.myDocument.insertString(mappedOffset, (CharSequence)value);
            this.myPostProcessorHelper.updateResultRange(0, value.length());
        }

        private boolean containsQuoteChars(@NotNull XmlAttributeValue value) {
            for (PsiElement child = value.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (HtmlQuotesConverter.isDelimiter(child.getNode().getElementType()) || !StringUtil.contains((CharSequence)child.getNode().getChars(), (CharSequence)this.myNewQuote)) continue;
                return true;
            }
            return false;
        }

        private static boolean isDelimiter(@NotNull IElementType elementType) {
            return elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER || elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
        }

        @Override
        public void run() {
            if (this.myDocument != null) {
                this.myDocumentManager.doPostponedOperationsAndUnblockDocument(this.myDocument);
                this.myContext.accept((PsiElementVisitor)this);
                this.myDocumentManager.commitDocument(this.myDocument);
            }
        }

        public static void runOnElement(@NotNull CodeStyleSettings.QuoteStyle quoteStyle, @NotNull PsiElement element) {
            PostFormatProcessorHelper postFormatProcessorHelper = new PostFormatProcessorHelper(CodeStyle.getDefaultSettings());
            postFormatProcessorHelper.setResultTextRange(element.getTextRange());
            new HtmlQuotesConverter(quoteStyle, element, postFormatProcessorHelper).run();
        }
    }
}

