/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.impl;

import com.intellij.html.impl.RelaxedHtmlFromSchemaElementDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorAwareAboutChildren;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class DelegatingRelaxedHtmlElementDescriptor
implements XmlElementDescriptor,
XmlElementDescriptorAwareAboutChildren {
    protected final XmlElementDescriptor myDelegate;

    public DelegatingRelaxedHtmlElementDescriptor(@NotNull XmlElementDescriptor delegate) {
        this.myDelegate = delegate;
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlElementDescriptor elementDescriptor = this.myDelegate.getElementDescriptor(childTag, contextTag);
        if (elementDescriptor == null) {
            return RelaxedHtmlFromSchemaElementDescriptor.getRelaxedDescriptor(this, childTag);
        }
        return elementDescriptor;
    }

    public String getQualifiedName() {
        return this.myDelegate.getQualifiedName();
    }

    public String getDefaultName() {
        return this.myDelegate.getDefaultName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        return (XmlElementDescriptor[])ArrayUtil.mergeArrays((Object[])this.myDelegate.getElementsDescriptors(context), (Object[])HtmlUtil.getCustomTagDescriptors((PsiElement)context));
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(XmlTag context) {
        return RelaxedHtmlFromSchemaElementDescriptor.addAttrDescriptorsForFacelets(context, this.myDelegate.getAttributesDescriptors(context));
    }

    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        XmlAttributeDescriptor descriptor = this.myDelegate.getAttributeDescriptor(attribute);
        if (descriptor != null) {
            return descriptor;
        }
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myDelegate.getNSDescriptor();
    }

    public XmlElementsGroup getTopGroup() {
        return this.myDelegate.getTopGroup();
    }

    public int getContentType() {
        return this.myDelegate.getContentType();
    }

    public String getDefaultValue() {
        return null;
    }

    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        XmlAttributeDescriptor descriptor = this.myDelegate.getAttributeDescriptor(StringUtil.toLowerCase((String)attributeName), context);
        if (descriptor != null) {
            return descriptor;
        }
        return RelaxedHtmlFromSchemaElementDescriptor.getAttributeDescriptorFromFacelets(attributeName, context);
    }

    public PsiElement getDeclaration() {
        return this.myDelegate.getDeclaration();
    }

    public String getName(PsiElement context) {
        return this.myDelegate.getName(context);
    }

    public String getName() {
        return this.myDelegate.getName();
    }

    public void init(PsiElement element) {
        this.myDelegate.init(element);
    }

    public Object @NotNull [] getDependencies() {
        return this.myDelegate.getDependencies();
    }

    public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
        return true;
    }

    public int hashCode() {
        return this.myDelegate.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DelegatingRelaxedHtmlElementDescriptor && this.myDelegate.equals(((DelegatingRelaxedHtmlElementDescriptor)obj).myDelegate);
    }
}

